/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.shiro;

import com.ebaiyihui.server.conmon.enums.LoginType;
import com.ebaiyihui.server.shiro.realm.UserToken;
import java.util.Collection;
import java.util.HashMap;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.pam.ModularRealmAuthenticator;
import org.apache.shiro.realm.Realm;

public class MyModularRealmAuthenticator
extends ModularRealmAuthenticator {
    protected AuthenticationInfo doAuthenticate(AuthenticationToken authenticationToken) throws AuthenticationException {
        this.assertRealmsConfigured();
        Collection realms = this.getRealms();
        HashMap<String, Realm> realmHashMap = new HashMap<String, Realm>(realms.size());
        for (Realm realm : realms) {
            realmHashMap.put(realm.getName(), realm);
        }
        UserToken token = (UserToken)authenticationToken;
        LoginType loginType = token.getLoginType();
        if (realmHashMap.get(loginType.getType()) != null) {
            return this.doSingleRealmAuthentication((Realm)realmHashMap.get(loginType.getType()), (AuthenticationToken)token);
        }
        return this.doMultiRealmAuthentication(realms, (AuthenticationToken)token);
    }
}

