/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.service.impl;

import cn.binarywang.wx.miniapp.bean.WxMaJscode2SessionResult;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.common.pojo.AccountEntity;
import com.ebaiyihui.common.pojo.WeChatConfigEntity;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.response.IError;
import com.ebaiyihui.server.conmon.ProjProperties;
import com.ebaiyihui.server.conmon.enums.ErrorEnum;
import com.ebaiyihui.server.dao.AccountDao;
import com.ebaiyihui.server.dao.WeChatConfigDao;
import com.ebaiyihui.server.service.AccessTokenService;
import com.ebaiyihui.server.token.TokenBody;
import com.ebaiyihui.server.token.TokenJson;
import com.ebaiyihui.server.token.TokenUtil;
import com.ebaiyihui.server.token.exception.TokenParseException;
import com.ebaiyihui.server.util.RedisUtil;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AccessTokenServiceImpl
implements AccessTokenService {
    private static final Logger log = LoggerFactory.getLogger(AccessTokenServiceImpl.class);
    @Autowired
    private WeChatConfigDao weChatConfigDao;
    @Autowired
    ProjProperties projProperties;
    @Autowired
    protected RedisUtil redisUtil;
    @Autowired
    AccountDao accountDao;

    public BaseResponse validAcessToken(String accessToken) {
        log.info("token\u6821\u9a8c");
        TokenBody tokenBody = new TokenBody();
        try {
            tokenBody = TokenUtil.parse((String)accessToken, (String)this.projProperties.getAuthTokenAppSecret());
            log.info("token \u89e3\u6790\u7ed3\u679c\uff1a{}", (Object)tokenBody);
        }
        catch (TokenParseException e) {
            e.printStackTrace();
        }
        if (null == this.redisUtil.get(tokenBody.getTokenJson().getAccountId() + tokenBody.getTokenJson().getDeviceNumber())) {
            return BaseResponse.error((IError)ErrorEnum.NO_PERMISSION);
        }
        return BaseResponse.success();
    }

    public BaseResponse validAcessTokennew(String accessToken) {
        log.info("token\u6821\u9a8c\u89e3\u6790");
        TokenBody tokenBody = new TokenBody();
        try {
            tokenBody = TokenUtil.parse((String)accessToken, (String)this.projProperties.getAuthTokenAppSecret());
            log.info("token \u89e3\u6790\u7ed3\u679c\uff1a{}", (Object)tokenBody);
        }
        catch (TokenParseException e) {
            e.printStackTrace();
            return BaseResponse.error((IError)ErrorEnum.NO_PERMISSION);
        }
        if (null == this.redisUtil.get(tokenBody.getTokenJson().getAccountId() + tokenBody.getTokenJson().getDeviceNumber())) {
            return BaseResponse.error((IError)ErrorEnum.NO_PERMISSION);
        }
        return BaseResponse.success((Object)tokenBody);
    }

    public BaseResponse refreshAccessToken(String refreshToken) {
        TokenBody tokenBody = null;
        try {
            tokenBody = TokenUtil.parse((String)refreshToken, (String)this.projProperties.getRefreshTokenAppSecret());
        }
        catch (TokenParseException e) {
            return BaseResponse.error((IError)ErrorEnum.NO_PERMISSION);
        }
        Boolean flag = tokenBody.expire();
        if (!flag.booleanValue()) {
            return BaseResponse.error((IError)ErrorEnum.NO_PERMISSION);
        }
        JSONObject json = new JSONObject();
        String accessToken = TokenUtil.gen((TokenJson)tokenBody.getTokenJson(), (String)this.projProperties.getAuthTokenAppSecret(), (Long)2L, (TimeUnit)TimeUnit.HOURS);
        String refreshTokenNew = TokenUtil.gen((TokenJson)tokenBody.getTokenJson(), (String)this.projProperties.getRefreshTokenAppSecret(), (Long)30L, (TimeUnit)TimeUnit.DAYS);
        json.put("accessToken", (Object)accessToken);
        json.put("refreshToken", (Object)refreshTokenNew);
        return BaseResponse.success((Object)json);
    }

    public BaseResponse getUserUnique(String token, String code, String appId) {
        WxMaJscode2SessionResult result;
        TokenBody tokenBody = new TokenBody();
        try {
            tokenBody = TokenUtil.parse((String)token, (String)this.projProperties.getAuthTokenAppSecret());
        }
        catch (TokenParseException e) {
            e.printStackTrace();
        }
        String accountId = tokenBody.getTokenJson().getAccountId();
        AccountEntity accountEntity = this.accountDao.findAccountEntityByAccountId(accountId);
        WeChatConfigEntity weChatConfig = this.weChatConfigDao.findByAppId(appId);
        try {
            String resultStr = HttpUtil.get((String)("https://api.weixin.qq.com/sns/jscode2session?appid=" + weChatConfig.getAppId() + "&secret=" + weChatConfig.getAppSecret() + "&js_code=" + code + "&grant_type=authorization_code"));
            result = WxMaJscode2SessionResult.fromJson((String)resultStr);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5fae\u4fe1\u4e2a\u4eba\u6807\u8bc6\u5931\u8d25{}", (Object)e.getMessage());
            return BaseResponse.error((String)"\u83b7\u53d6\u5fae\u4fe1\u4e2a\u4eba\u6807\u8bc6\u5931\u8d25");
        }
        accountEntity.setWxUserUnique(result.getOpenid());
        this.accountDao.save((Object)accountEntity);
        return BaseResponse.success((Object)result.getOpenid());
    }

    public BaseResponse loginout(String accessToken) {
        TokenBody tokenBody = new TokenBody();
        try {
            tokenBody = TokenUtil.parse((String)accessToken, (String)this.projProperties.getAuthTokenAppSecret());
            log.info("token \u89e3\u6790\u7ed3\u679c\uff1a{}", (Object)tokenBody);
        }
        catch (TokenParseException e) {
            e.printStackTrace();
        }
        this.redisUtil.del(new String[]{tokenBody.getTokenJson().getAccountId() + tokenBody.getTokenJson().getDeviceNumber()});
        return BaseResponse.error((IError)ErrorEnum.NO_PERMISSION);
    }

    public BaseResponse tokenout(String accountId) {
        try {
            this.redisUtil.removeAll(accountId);
            return BaseResponse.success();
        }
        catch (Exception e) {
            return BaseResponse.error((String)"token \u5220\u9664\u5931\u8d25");
        }
    }
}

