/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.shiro;

import com.ebaiyihui.server.conmon.enums.LoginType;
import com.ebaiyihui.server.shiro.CredentialsMatcher;
import com.ebaiyihui.server.shiro.MyModularRealmAuthenticator;
import com.ebaiyihui.server.shiro.realm.UserPasswordRealm;
import com.ebaiyihui.server.shiro.realm.UserPhoneRealm;
import com.ebaiyihui.server.shiro.realm.WechatLoginRealm;
import java.util.ArrayList;
import org.apache.shiro.authc.Authenticator;
import org.apache.shiro.authc.pam.AtLeastOneSuccessfulStrategy;
import org.apache.shiro.authc.pam.AuthenticationStrategy;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.spring.LifecycleBeanPostProcessor;
import org.apache.shiro.spring.security.interceptor.AuthorizationAttributeSourceAdvisor;
import org.apache.shiro.spring.web.ShiroFilterFactoryBean;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.springframework.aop.framework.autoproxy.DefaultAdvisorAutoProxyCreator;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ShiroConfig {
    @Bean(name={"securityManager"})
    public SecurityManager securityManager() {
        DefaultWebSecurityManager securityManager = new DefaultWebSecurityManager();
        securityManager.setAuthenticator((Authenticator)this.modularRealmAuthenticator());
        ArrayList<Object> realms = new ArrayList<Object>();
        realms.add(this.userPasswordRealm());
        realms.add(this.userPhoneRealm());
        realms.add(this.wechatLoginRealm());
        securityManager.setRealms(realms);
        return securityManager;
    }

    @Bean
    public ShiroFilterFactoryBean shiroFilterFactoryBean(@Qualifier(value="securityManager") SecurityManager securityManager) {
        ShiroFilterFactoryBean bean = new ShiroFilterFactoryBean();
        bean.setSecurityManager(securityManager);
        return bean;
    }

    @Bean(value={"myModularRealmAuthenticator"})
    public MyModularRealmAuthenticator modularRealmAuthenticator() {
        MyModularRealmAuthenticator customizedModularRealmAuthenticator = new MyModularRealmAuthenticator();
        customizedModularRealmAuthenticator.setAuthenticationStrategy((AuthenticationStrategy)new AtLeastOneSuccessfulStrategy());
        return customizedModularRealmAuthenticator;
    }

    @Bean
    public UserPasswordRealm userPasswordRealm() {
        UserPasswordRealm userPasswordRealm = new UserPasswordRealm();
        userPasswordRealm.setName(LoginType.USER_PASSWORD.getType());
        userPasswordRealm.setCredentialsMatcher((org.apache.shiro.authc.credential.CredentialsMatcher)this.credentialsMatcher());
        return userPasswordRealm;
    }

    @Bean
    public UserPhoneRealm userPhoneRealm() {
        UserPhoneRealm userPhoneRealm = new UserPhoneRealm();
        userPhoneRealm.setName(LoginType.USER_PHONE.getType());
        userPhoneRealm.setCredentialsMatcher((org.apache.shiro.authc.credential.CredentialsMatcher)this.credentialsMatcher());
        return userPhoneRealm;
    }

    @Bean
    public WechatLoginRealm wechatLoginRealm() {
        WechatLoginRealm wechatLoginRealm = new WechatLoginRealm();
        wechatLoginRealm.setName(LoginType.WECHAT_LOGIN.getType());
        wechatLoginRealm.setCredentialsMatcher((org.apache.shiro.authc.credential.CredentialsMatcher)this.credentialsMatcher());
        return wechatLoginRealm;
    }

    @Bean
    public CredentialsMatcher credentialsMatcher() {
        return new CredentialsMatcher();
    }

    @Bean
    public DefaultAdvisorAutoProxyCreator getDefaultAdvisorAutoProxyCreator() {
        DefaultAdvisorAutoProxyCreator defaultAdvisorAutoProxyCreator = new DefaultAdvisorAutoProxyCreator();
        defaultAdvisorAutoProxyCreator.setProxyTargetClass(true);
        return defaultAdvisorAutoProxyCreator;
    }

    @Bean
    public AuthorizationAttributeSourceAdvisor authorizationAttributeSourceAdvisor(SecurityManager securityManager) {
        AuthorizationAttributeSourceAdvisor authorizationAttributeSourceAdvisor = new AuthorizationAttributeSourceAdvisor();
        authorizationAttributeSourceAdvisor.setSecurityManager(securityManager);
        return authorizationAttributeSourceAdvisor;
    }

    @Bean
    public static LifecycleBeanPostProcessor getLifecycleBeanPostProcessor() {
        return new LifecycleBeanPostProcessor();
    }
}

