/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.shiro.realm;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.common.pojo.AccountEntity;
import com.ebaiyihui.server.conmon.enums.ErrorEnum;
import com.ebaiyihui.server.conmon.enums.LoginDeviceType;
import com.ebaiyihui.server.conmon.enums.LoginType;
import com.ebaiyihui.server.loginbusiness.LoginProcess;
import com.ebaiyihui.server.service.AccountService;
import com.ebaiyihui.server.shiro.realm.UserToken;
import com.ebaiyihui.server.util.DateUtils;
import com.ebaiyihui.server.util.PasswordUtil;
import com.ebaiyihui.server.util.RSAUtils;
import com.ebaiyihui.server.util.RedisUtil;
import com.ebaiyihui.server.vo.LoginRequestVo;
import java.util.concurrent.TimeUnit;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.DisabledAccountException;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class UserPasswordRealm
extends AuthorizingRealm {
    private static final Logger log = LoggerFactory.getLogger(UserPasswordRealm.class);
    @Autowired
    private AccountService accountService;
    @Autowired
    private LoginProcess loginProcess;
    @Autowired
    private RedisUtil redisUtil;

    public String getName() {
        return LoginType.USER_PASSWORD.getType();
    }

    public boolean supports(AuthenticationToken token) {
        if (token instanceof UserToken) {
            return ((UserToken)token).getLoginType() == LoginType.USER_PASSWORD;
        }
        return false;
    }

    public void setAuthorizationCacheName(String authorizationCacheName) {
        super.setAuthorizationCacheName(authorizationCacheName);
    }

    protected void clearCachedAuthorizationInfo(PrincipalCollection principals) {
        super.clearCachedAuthorizationInfo(principals);
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        log.info("---------------- \u7528\u6237\u5bc6\u7801\u767b\u5f55 ----------------------");
        UserToken statelessToken = (UserToken)token;
        LoginRequestVo loginRequestVo = statelessToken.getLoginRequestVo();
        AccountEntity user = this.accountService.getByAccountId(loginRequestVo.getAccountNo(), loginRequestVo.getUserType(), loginRequestVo.getAppCode());
        log.info("\u767b\u9646\u7528\u6237------>" + JSON.toJSONString((Object)user));
        if (null == user) {
            throw new UnknownAccountException(ErrorEnum.USER_NOT_EXIT.getMsg());
        }
        if (user.getDelFlag().equals(-1)) {
            throw new DisabledAccountException(ErrorEnum.DISABLED_USER.getMsg());
        }
        String verCodeKey = "verCode_" + user.getAccountId();
        Long lockExpire = null;
        Integer lockNumNew = null;
        Integer verCodeNum = null;
        if (loginRequestVo.getLoginDeviceType().equals((Object)LoginDeviceType.WEB)) {
            if (null == loginRequestVo.getVercodeKey() || null == loginRequestVo.getVercodeValue()) {
                throw new DisabledAccountException("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u56fe\u6587\u9a8c\u8bc1\u7801\uff01");
            }
            Boolean flag = this.loginProcess.verifyVercode(loginRequestVo.getVercodeKey(), loginRequestVo.getVercodeValue());
            if (!flag.booleanValue()) {
                Integer o = (Integer)this.redisUtil.get(verCodeKey);
                if (null == o) {
                    verCodeNum = 1;
                } else if (0 < o && o < 4) {
                    verCodeNum = o + 1;
                } else if (o == 4) {
                    Integer lockNum = (Integer)this.redisUtil.get("lockNum_" + user.getAccountId());
                    if (null == lockNum) {
                        lockExpire = 600000L;
                        lockNumNew = 1;
                    } else {
                        switch (lockNum) {
                            case 1: {
                                lockExpire = 1800000L;
                                lockNumNew = 2;
                                break;
                            }
                            case 2: {
                                lockExpire = 3600000L;
                                lockNumNew = 3;
                                break;
                            }
                            case 3: {
                                lockExpire = DateUtils.getNowToNextDaySeconds();
                                lockNumNew = 4;
                                break;
                            }
                        }
                    }
                    this.redisUtil.set("lockNum_" + user.getAccountId(), (Object)lockNumNew, DateUtils.getNowToNextDaySeconds().longValue(), TimeUnit.MILLISECONDS);
                    this.redisUtil.set("lock_" + user.getAccountId(), (Object)lockNumNew, lockExpire.longValue(), TimeUnit.MILLISECONDS);
                    this.redisUtil.del(new String[]{verCodeKey});
                    throw new DisabledAccountException("\u56fe\u6587\u9a8c\u8bc1\u7801\u8fde\u7eed\u6821\u9a8c\u5931\u8d25\u4e94\u6b21\uff0c\u8d26\u53f7\u5df2\u88ab\u9501\u5b9a\uff0c\u8bf7\u5728" + lockExpire / 1000L / 60L + "\u5206\u949f\u540e\u518d\u6b21\u5c1d\u8bd5");
                }
                this.redisUtil.set(verCodeKey, (Object)verCodeNum, DateUtils.getNowToNextDaySeconds().longValue(), TimeUnit.MILLISECONDS);
                throw new DisabledAccountException(ErrorEnum.VERCODE_ERROR.getMsg());
            }
            this.redisUtil.del(new String[]{verCodeKey});
        }
        if (-1 == user.getDelFlag()) {
            throw new DisabledAccountException(ErrorEnum.USER_NOT_EXIT.getMsg());
        }
        if (user.getStatus() == -1) {
            throw new DisabledAccountException("\u8d26\u6237\u72b6\u6001\u5f02\u5e38");
        }
        String pwd = loginRequestVo.getPassword().length() > 20 ? PasswordUtil.mix((String)RSAUtils.decode((String)loginRequestVo.getPassword()), (String)user.getSalt()) : PasswordUtil.mix((String)loginRequestVo.getPassword(), (String)user.getSalt());
        if (!pwd.equals(user.getPassword())) {
            Integer pwdNumNew = null;
            Integer pwdNum = (Integer)this.redisUtil.get("pwd_" + user.getAccountId());
            if (null == pwdNum) {
                pwdNumNew = 1;
            } else if (0 < pwdNum && pwdNum < 4) {
                pwdNumNew = pwdNum + 1;
            } else if (4 == pwdNum) {
                Integer lockNum = (Integer)this.redisUtil.get("lockNum_" + user.getAccountId());
                if (null == lockNum) {
                    lockExpire = 600000L;
                    lockNumNew = 1;
                } else {
                    switch (lockNum) {
                        case 1: {
                            lockExpire = 1800000L;
                            lockNumNew = 2;
                            break;
                        }
                        case 2: {
                            lockExpire = 3600000L;
                            lockNumNew = 3;
                            break;
                        }
                        case 3: {
                            lockExpire = DateUtils.getNowToNextDaySeconds();
                            lockNumNew = 4;
                            break;
                        }
                    }
                }
                this.redisUtil.set("lockNum_" + user.getAccountId(), (Object)lockNumNew, DateUtils.getNowToNextDaySeconds().longValue(), TimeUnit.MILLISECONDS);
                this.redisUtil.set("lock_" + user.getAccountId(), (Object)lockNumNew, lockExpire.longValue(), TimeUnit.MILLISECONDS);
                this.redisUtil.del(new String[]{"pwd_" + user.getAccountId()});
                throw new DisabledAccountException("\u5bc6\u7801\u8fde\u7eed\u6821\u9a8c\u5931\u8d25\u4e94\u6b21\uff0c\u8d26\u53f7\u5df2\u88ab\u9501\u5b9a\uff0c\u8bf7\u5728" + lockExpire / 1000L / 60L + "\u5206\u949f\u540e\u518d\u6b21\u5c1d\u8bd5");
            }
            this.redisUtil.set("pwd_" + user.getAccountId(), (Object)pwdNumNew, DateUtils.getNowToNextDaySeconds().longValue(), TimeUnit.MILLISECONDS);
            throw new DisabledAccountException(ErrorEnum.INVALID_PASSWORD.getMsg());
        }
        SimpleAuthenticationInfo authenticationInfo = new SimpleAuthenticationInfo((Object)user.getMobilePhone(), (Object)user.getPassword(), this.getName());
        return authenticationInfo;
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        return null;
    }
}

