/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.shiro.realm;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.common.pojo.AccountEntity;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.JsonUtil;
import com.ebaiyihui.server.conmon.ProjProperties;
import com.ebaiyihui.server.conmon.enums.ErrorEnum;
import com.ebaiyihui.server.conmon.enums.LoginDeviceType;
import com.ebaiyihui.server.conmon.enums.LoginType;
import com.ebaiyihui.server.dao.AccountDao;
import com.ebaiyihui.server.loginbusiness.LoginProcess;
import com.ebaiyihui.server.service.AccountService;
import com.ebaiyihui.server.shiro.realm.UserToken;
import com.ebaiyihui.server.util.DateUtils;
import com.ebaiyihui.server.util.RSAUtils;
import com.ebaiyihui.server.util.RedisUtil;
import com.ebaiyihui.server.vo.LoginRequestVo;
import com.ebaiyihui.server.vo.SmsVerifiAuthCodeReqVO;
import java.util.concurrent.TimeUnit;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.DisabledAccountException;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class UserPhoneRealm
extends AuthorizingRealm {
    private static final Logger log = LoggerFactory.getLogger(UserPhoneRealm.class);
    @Autowired
    private AccountService accountService;
    @Autowired
    AccountDao accountDao;
    @Autowired
    private LoginProcess loginProcess;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    protected RestTemplate restTemplate;
    @Autowired
    ProjProperties projProperties;

    public String getName() {
        return LoginType.USER_PHONE.getType();
    }

    public boolean supports(AuthenticationToken token) {
        if (token instanceof UserToken) {
            return ((UserToken)token).getLoginType() == LoginType.USER_PHONE;
        }
        return false;
    }

    public void setAuthorizationCacheName(String authorizationCacheName) {
        super.setAuthorizationCacheName(authorizationCacheName);
    }

    protected void clearCachedAuthorizationInfo(PrincipalCollection principals) {
        super.clearCachedAuthorizationInfo(principals);
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authcToken) throws AuthenticationException {
        UserToken token;
        log.info("---------------- \u624b\u673a\u9a8c\u8bc1\u7801\u767b\u5f55 ----------------------");
        UserToken statelessToken = token = (UserToken)authcToken;
        LoginRequestVo loginRequestVo = statelessToken.getLoginRequestVo();
        AccountEntity user = this.accountService.getByPhone(loginRequestVo.getAccountNo(), loginRequestVo.getUserType(), loginRequestVo.getAppCode());
        if (null == user) {
            if (!loginRequestVo.getUserType().equals(3)) {
                throw new UnknownAccountException(ErrorEnum.USER_NOT_EXIT.getMsg());
            }
            AccountEntity accountEntity = new AccountEntity();
            this.accountDao.save((Object)accountEntity);
            user = accountEntity;
        }
        if (user.getDelFlag().equals(-1)) {
            throw new DisabledAccountException(ErrorEnum.DISABLED_USER.getMsg());
        }
        Integer lock = (Integer)this.redisUtil.get("lock_" + user.getAccountId());
        Long expireTime = this.redisUtil.getExpire("lock_" + user.getAccountId()) / 60L;
        if (null != lock) {
            throw new DisabledAccountException("\u8d26\u53f7\u5df2\u88ab\u9501\u5b9a\uff0c\u8bf7" + expireTime + "\u5206\u949f\u540e\u518d\u5c1d\u8bd5");
        }
        String verCodeKey = "verCode_" + user.getAccountId();
        Long lockExpire = null;
        Integer lockNumNew = null;
        Integer verCodeNum = null;
        if (loginRequestVo.getLoginDeviceType().equals((Object)LoginDeviceType.WEB)) {
            if (loginRequestVo.getVercodeKey().isEmpty() || loginRequestVo.getVercodeValue().isEmpty()) {
                throw new DisabledAccountException();
            }
            Boolean flag = this.loginProcess.verifyVercode(loginRequestVo.getVercodeKey(), loginRequestVo.getVercodeValue());
            if (!flag.booleanValue()) {
                Integer o = (Integer)this.redisUtil.get(verCodeKey);
                if (null == o) {
                    verCodeNum = 1;
                } else if (0 < o && o < 4) {
                    verCodeNum = o + 1;
                } else if (o == 4) {
                    Integer lockNum = (Integer)this.redisUtil.get("lockNum_" + user.getAccountId());
                    if (null == lockNum) {
                        lockExpire = 600000L;
                        lockNumNew = 1;
                    } else {
                        switch (lockNum) {
                            case 1: {
                                lockExpire = 1800000L;
                                lockNumNew = 2;
                                break;
                            }
                            case 2: {
                                lockExpire = 3600000L;
                                lockNumNew = 3;
                                break;
                            }
                            case 3: {
                                lockExpire = DateUtils.getNowToNextDaySeconds();
                                lockNumNew = 4;
                                break;
                            }
                        }
                    }
                    this.redisUtil.set("lockNum_" + user.getAccountId(), (Object)lockNumNew, DateUtils.getNowToNextDaySeconds().longValue(), TimeUnit.MILLISECONDS);
                    this.redisUtil.set("lock_" + user.getAccountId(), (Object)lockNumNew, lockExpire.longValue(), TimeUnit.MILLISECONDS);
                    this.redisUtil.del(new String[]{verCodeKey});
                    throw new DisabledAccountException("\u56fe\u6587\u9a8c\u8bc1\u7801\u8fde\u7eed\u6821\u9a8c\u5931\u8d25\u4e94\u6b21\uff0c\u8d26\u53f7\u5df2\u88ab\u9501\u5b9a\uff0c\u8bf7\u5728" + lockExpire / 1000L / 60L + "\u5206\u949f\u540e\u518d\u6b21\u5c1d\u8bd5");
                }
                this.redisUtil.set(verCodeKey, (Object)verCodeNum, DateUtils.getNowToNextDaySeconds().longValue(), TimeUnit.MILLISECONDS);
                throw new DisabledAccountException(ErrorEnum.VERCODE_ERROR.getMsg());
            }
            this.redisUtil.del(new String[]{verCodeKey});
        }
        if (-1 == user.getDelFlag()) {
            throw new DisabledAccountException(ErrorEnum.USER_NOT_EXIT.getMsg());
        }
        if (user.getStatus() == -1) {
            throw new DisabledAccountException("\u8d26\u6237\u72b6\u6001\u5f02\u5e38");
        }
        SmsVerifiAuthCodeReqVO smsVerifiAuthCodeReqVo = new SmsVerifiAuthCodeReqVO();
        smsVerifiAuthCodeReqVo.setAuthCode(RSAUtils.decode((String)loginRequestVo.getPassword()));
        smsVerifiAuthCodeReqVo.setAuthKey(loginRequestVo.getAuthKey());
        smsVerifiAuthCodeReqVo.setPhoneNum(loginRequestVo.getAccountNo());
        String SMS_DEL_FLAG = "D";
        smsVerifiAuthCodeReqVo.setOperate(SMS_DEL_FLAG);
        String requestUrl = this.projProperties.getEbaiyihuiDomain() + "/cloud/push/alismsapi/verifialismsauthcode";
        log.info("\u8d26\u6237\u767b\u9646\uff0c\u8c03\u7528\u63a8\u9001\u670d\u52a1\uff0c\u6821\u9a8c\u77ed\u4fe1\u9a8c\u8bc1\u7801\uff0c\u8bf7\u6c42\u53c2\u6570{}", (Object)JsonUtil.convertObject((Object)smsVerifiAuthCodeReqVo));
        HttpHeaders headers = new HttpHeaders();
        headers.set("accept-language", "zh-CN,zh;q=0.9,en;q=0.8");
        HttpEntity httpEntity = new HttpEntity((Object)smsVerifiAuthCodeReqVo, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        try {
            responseEntity = this.restTemplate.exchange(requestUrl, HttpMethod.POST, httpEntity, BaseResponse.class, new Object[0]);
            log.info("\u9a8c\u8bc1\u7801\u6821\u9a8c\u7ed3\u679c\uff0c{}", (Object)JSON.toJSONString((Object)responseEntity));
        }
        catch (Exception e) {
            throw new DisabledAccountException(ErrorEnum.SYSTEM_BUSY.getMsg());
        }
        Boolean flag = false;
        if (HttpStatus.OK.getReasonPhrase().equals(responseEntity.getStatusCode().getReasonPhrase()) && ((BaseResponse)responseEntity.getBody()).isSuccess()) {
            flag = true;
        }
        if (!flag.booleanValue()) {
            log.info(flag.toString());
            Integer pwdNumNew = null;
            Integer pwdNum = (Integer)this.redisUtil.get("DynamicVerCode_" + user.getAccountId());
            if (null == pwdNum) {
                pwdNumNew = 1;
            } else if (0 < pwdNum && pwdNum < 4) {
                pwdNumNew = pwdNum + 1;
            } else if (4 == pwdNum) {
                Integer lockNum = (Integer)this.redisUtil.get("lockNum_" + user.getAccountId());
                if (null == lockNum) {
                    lockExpire = 600000L;
                    lockNumNew = 1;
                } else {
                    switch (lockNum) {
                        case 1: {
                            lockExpire = 1800000L;
                            lockNumNew = 2;
                            break;
                        }
                        case 2: {
                            lockExpire = 3600000L;
                            lockNumNew = 3;
                            break;
                        }
                        case 3: {
                            lockExpire = DateUtils.getNowToNextDaySeconds();
                            lockNumNew = 4;
                            break;
                        }
                    }
                }
                this.redisUtil.set("lockNum_" + user.getAccountId(), (Object)lockNumNew, DateUtils.getNowToNextDaySeconds().longValue(), TimeUnit.MILLISECONDS);
                this.redisUtil.set("lock_" + user.getAccountId(), (Object)lockNumNew, lockExpire.longValue(), TimeUnit.MILLISECONDS);
                this.redisUtil.del(new String[]{"DynamicVerCode_" + user.getAccountId()});
                throw new DisabledAccountException("\u52a8\u6001\u9a8c\u8bc1\u7801\u8fde\u7eed\u6821\u9a8c\u5931\u8d25\u4e94\u6b21\uff0c\u8d26\u53f7\u5df2\u88ab\u9501\u5b9a\uff0c\u8bf7\u5728" + lockExpire / 1000L / 60L + "\u5206\u949f\u540e\u518d\u6b21\u5c1d\u8bd5");
            }
            this.redisUtil.set("DynamicVerCode_" + user.getAccountId(), (Object)pwdNumNew, DateUtils.getNowToNextDaySeconds().longValue(), TimeUnit.MILLISECONDS);
            throw new DisabledAccountException("\u77ed\u4fe1\u9a8c\u8bc1\u7801\u6821\u9a8c\u5931\u8d25!");
        }
        this.redisUtil.del(new String[]{"DynamicVerCode_" + user.getAccountId()});
        this.redisUtil.del(new String[]{"lock_" + user.getAccountId()});
        SimpleAuthenticationInfo authenticationInfo = new SimpleAuthenticationInfo((Object)user.getMobilePhone(), (Object)user.getPassword(), this.getName());
        return authenticationInfo;
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principalCollection) {
        return null;
    }
}

