/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.shiro.realm;

import com.ebaiyihui.server.conmon.enums.LoginType;
import com.ebaiyihui.server.vo.LoginRequestVo;
import org.apache.shiro.authc.DisabledAccountException;
import org.apache.shiro.authc.UsernamePasswordToken;

public class UserToken
extends UsernamePasswordToken {
    private LoginType loginType;
    private LoginRequestVo loginRequestVo;
    private String accountId;

    public UserToken(LoginType loginType, LoginRequestVo loginRequestVo, String username, String password) {
        super(username, password);
        this.loginType = loginType;
        this.loginRequestVo = loginRequestVo;
    }

    public Object getPrincipal() {
        if (null != this.loginRequestVo.getAccountNo()) {
            return this.loginRequestVo.getAccountNo();
        }
        throw new DisabledAccountException();
    }

    public Object getCredentials() {
        if (null != this.loginRequestVo.getPassword()) {
            return this.loginRequestVo.getPassword();
        }
        throw new DisabledAccountException();
    }

    private UserToken() {
    }

    public LoginType getLoginType() {
        return this.loginType;
    }

    public LoginRequestVo getLoginRequestVo() {
        return this.loginRequestVo;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public void setLoginType(LoginType loginType) {
        this.loginType = loginType;
    }

    public void setLoginRequestVo(LoginRequestVo loginRequestVo) {
        this.loginRequestVo = loginRequestVo;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserToken)) {
            return false;
        }
        UserToken other = (UserToken)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        LoginType this$loginType = this.getLoginType();
        LoginType other$loginType = other.getLoginType();
        if (this$loginType == null ? other$loginType != null : !this$loginType.equals(other$loginType)) {
            return false;
        }
        LoginRequestVo this$loginRequestVo = this.getLoginRequestVo();
        LoginRequestVo other$loginRequestVo = other.getLoginRequestVo();
        if (this$loginRequestVo == null ? other$loginRequestVo != null : !this$loginRequestVo.equals(other$loginRequestVo)) {
            return false;
        }
        String this$accountId = this.getAccountId();
        String other$accountId = other.getAccountId();
        return !(this$accountId == null ? other$accountId != null : !this$accountId.equals(other$accountId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UserToken;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LoginType $loginType = this.getLoginType();
        result = result * 59 + ($loginType == null ? 43 : $loginType.hashCode());
        LoginRequestVo $loginRequestVo = this.getLoginRequestVo();
        result = result * 59 + ($loginRequestVo == null ? 43 : $loginRequestVo.hashCode());
        String $accountId = this.getAccountId();
        result = result * 59 + ($accountId == null ? 43 : $accountId.hashCode());
        return result;
    }

    public String toString() {
        return "UserToken(loginType=" + this.getLoginType() + ", loginRequestVo=" + this.getLoginRequestVo() + ", accountId=" + this.getAccountId() + ")";
    }
}

