/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.token;

import com.ebaiyihui.server.token.JwtUtil;
import com.ebaiyihui.server.token.TokenBody;
import com.ebaiyihui.server.token.TokenJson;
import com.ebaiyihui.server.token.UserCenterTokenParseUtil;
import com.ebaiyihui.server.token.exception.TokenParseException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

/*
 * Exception performing whole class analysis ignored.
 */
public class TokenUtil {
    private static String SPACE_MARK = "***";

    public static TokenBody parse(String token, String secryKey) throws TokenParseException {
        if (token.contains(SPACE_MARK)) {
            int i = token.indexOf(SPACE_MARK);
            token = token.substring(0, i);
        }
        return UserCenterTokenParseUtil.parse((String)token, (String)secryKey);
    }

    public static String gen(TokenJson tokenJson, String secryKey, Long timeToLive, TimeUnit timeUnit) {
        Objects.requireNonNull(tokenJson, "\u751f\u6210token\u53c2\u6570tokenJson\u4e0d\u80fd\u4e3anull");
        String id = tokenJson.getAccountNo() + tokenJson.getAccountId() + tokenJson.getDeviceNumber();
        String genJwt = JwtUtil.genJwt((String)id, (Object)tokenJson, (long)8L, (TimeUnit)timeUnit, (String)secryKey);
        return genJwt + SPACE_MARK + tokenJson.getAppCode();
    }

    public static boolean validateToken(String accesstoken, String secryKey) {
        try {
            TokenBody tokenBody = TokenUtil.parse((String)accesstoken, (String)secryKey);
            return tokenBody.expire();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String genTokenKey(String userId, String appCode, String deviceType) {
        return userId + "_" + appCode + "_" + deviceType;
    }

    public static String getTokenAppCode(String token) {
        return token.substring(token.indexOf(SPACE_MARK) + 3);
    }
}

