/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.response.IError;
import com.ebaiyihui.server.conmon.ProjProperties;
import com.ebaiyihui.server.conmon.enums.ErrorEnum;
import com.ebaiyihui.server.conmon.enums.PushCenterEnums;
import com.ebaiyihui.server.util.RedisUtil;
import com.ebaiyihui.server.vo.AliSmsSendAuthCodeReqPhone;
import com.ebaiyihui.server.vo.SmsConfig;
import com.ebaiyihui.server.vo.SmsSendAuthCodeReqVO;
import com.ebaiyihui.server.vo.SmsSendAuthCodeRspVO;
import org.apache.shiro.authc.DisabledAccountException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class PushUtils {
    private static final Logger log = LoggerFactory.getLogger(PushUtils.class);
    @Autowired
    private ProjProperties projProperties;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    RestTemplate restTemplate;

    public BaseResponse getSms(SmsSendAuthCodeReqVO smsSendAuthCodeReqVO) {
        BaseResponse body;
        AliSmsSendAuthCodeReqPhone params = new AliSmsSendAuthCodeReqPhone();
        params.setAppSdkType("ali");
        params.setPhone(smsSendAuthCodeReqVO.getPhone());
        params.setTemplateCode("czmm");
        SmsConfig smsConfig = this.getSmsConfig("BYH", PushCenterEnums.PushTypeEnum.SMS.getValue());
        if (smsConfig.getPatientSignCode() == null || smsConfig.getClientCode() == null) {
            log.error("\u8c03\u7528\u533b\u751f\u670d\u52a1 - \u67e5\u8be2\u63a8\u9001\u914d\u7f6e\u4fe1\u606f \u914d\u7f6e\u4e3a\u7a7asmsConfig:{}", (Object)smsConfig);
            return BaseResponse.error((IError)ErrorEnum.PUSH_CONFIG_NULL);
        }
        params.setSignCode(smsConfig.getPatientSignCode());
        params.setSmsAppCode(smsConfig.getClientCode());
        params.setUserType(smsSendAuthCodeReqVO.getUserType());
        params.setParams(smsSendAuthCodeReqVO.getParam());
        String baseUrl = this.projProperties.getEbaiyihuiDomain().concat("/cloud/push/alismsapi/sendAuthCodeWithPhoneV2");
        log.info("\u8c03\u7528\u63a8\u9001\u63a5\u53e3URL:{},\u5165\u53c2:{}", (Object)baseUrl, (Object)JSON.toJSONString((Object)params));
        HttpHeaders headers = new HttpHeaders();
        headers.set("accept-language", "zh-CN,zh;q=0.9,en;q=0.8");
        HttpEntity httpEntity = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(baseUrl, HttpMethod.POST, httpEntity, BaseResponse.class, new Object[0]);
        log.info("\u6821\u9a8c\u77ed\u4fe1\u9a8c\u8bc1\u7801--\u54cd\u5e94:" + JSON.toJSONString((Object)responseEntity));
        if (HttpStatus.OK.equals((Object)responseEntity.getStatusCode()) && responseEntity.getBody() != null && (body = (BaseResponse)responseEntity.getBody()).isSuccess()) {
            SmsSendAuthCodeRspVO rspVO = (SmsSendAuthCodeRspVO)JSONObject.parseObject((String)JSON.toJSONString((Object)body.getData()), SmsSendAuthCodeRspVO.class);
            return BaseResponse.success((Object)rspVO);
        }
        return BaseResponse.error((IError)ErrorEnum.OTHER_SERVICE_ERROR_DEFAULT_CODE, (String)(responseEntity.getBody() == null ? "\u77ed\u4fe1\u53d1\u9001\u5931\u8d25" : ((BaseResponse)responseEntity.getBody()).getMsg()));
    }

    private SmsConfig getSmsConfig(String appCode, String type) {
        String cacheKey = "PUSH".concat(appCode).concat("_").concat(type);
        SmsConfig smsConfig = new SmsConfig();
        smsConfig.setAppCode(appCode);
        smsConfig.setType(type);
        String url = this.projProperties.getEbaiyihuiDomain().concat("/cloud/doctoruser/configuration/getdetail");
        log.info("\u8c03\u7528\u533b\u751f\u63a5\u53e3URL:{},\u5165\u53c2:{}", (Object)url, (Object)smsConfig);
        BaseResponse baseResponse = (BaseResponse)this.restTemplate.postForObject(url, (Object)smsConfig, BaseResponse.class, new Object[0]);
        if (baseResponse == null) {
            log.error("\u8c03\u7528\u533b\u751f\u670d\u52a1 - \u67e5\u8be2\u63a8\u9001\u914d\u7f6e\u4fe1\u606f - \u8fd4\u56denull");
            throw new DisabledAccountException(ErrorEnum.DOCTOR_SYSTEM_RETURN_NULL.getMsg());
        }
        String toJSONString = JSON.toJSONString((Object)baseResponse);
        JSONObject jsonObject1 = JSONObject.parseObject((String)toJSONString);
        log.info("\u8c03\u7528\u533b\u751f\u670d\u52a1 - \u67e5\u8be2\u63a8\u9001\u914d\u7f6e\u4fe1\u606f \u8fd4\u56de " + toJSONString);
        if ("1".equalsIgnoreCase(jsonObject1.getString("code"))) {
            String data = jsonObject1.getString("data");
            JSONObject jsonDate = JSONObject.parseObject((String)data);
            if (null == jsonDate) {
                throw new DisabledAccountException(ErrorEnum.INVALID_PUSH_PARAMETER.getMsg());
            }
            String clientCodeStr = jsonDate.getString("clientCode");
            String statusStr = jsonDate.getString("status");
            if (statusStr != null) {
                smsConfig.setStatus(Integer.valueOf(statusStr).intValue());
            }
            if (clientCodeStr != null) {
                log.info("==========clientCodeStr========" + clientCodeStr);
                JSONObject clientCodeJson = JSONObject.parseObject((String)clientCodeStr);
                if (PushCenterEnums.PushTypeEnum.SMS.getValue().equalsIgnoreCase(type) && clientCodeJson != null) {
                    String clientCode1 = clientCodeJson.getString("clientCode");
                    smsConfig.setClientCode(clientCode1);
                    String signCode = clientCodeJson.getString("signCode");
                    JSONObject signCodeJson = JSONObject.parseObject((String)signCode);
                    if (signCodeJson != null) {
                        smsConfig.setDoctorSignCode(signCodeJson.getString("doctorCode"));
                        smsConfig.setPatientSignCode(signCodeJson.getString("patientCode"));
                    }
                }
            }
        }
        return smsConfig;
    }
}

