/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.common.pojo.AccountEntity;
import com.ebaiyihui.common.pojo.AccountEntityVo;
import com.ebaiyihui.common.pojo.AccountInfoBO;
import com.ebaiyihui.common.pojo.AccountInfoEntity;
import com.ebaiyihui.common.vo.AccountBatchDeleteReqVO;
import com.ebaiyihui.common.vo.ResetPassWordReqVo;
import com.ebaiyihui.common.vo.SetPassswordVo;
import com.ebaiyihui.framework.utils.HttpKit;
import com.ebaiyihui.framework.utils.UUIDUtils;
import com.ebaiyihui.server.conmon.ProjProperties;
import com.ebaiyihui.server.dao.AccountDao;
import com.ebaiyihui.server.service.AccountService;
import com.ebaiyihui.server.util.HttpUtils;
import com.ebaiyihui.server.util.PasswordAndSalt;
import com.ebaiyihui.server.util.PasswordUtil;
import com.ebaiyihui.server.util.PushUtils;
import com.ebaiyihui.server.vo.SmsSendAuthCodeReqVO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AccountServiceImpl
implements AccountService {
    private static final Logger log = LoggerFactory.getLogger(AccountServiceImpl.class);
    @Autowired
    AccountDao accountDao;
    @Autowired
    private PushUtils pushUtils;
    @Autowired
    ProjProperties projProperties;
    private ExecutorService executor = new ThreadPoolExecutor(5, 200, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(10), Executors.defaultThreadFactory(), new ThreadPoolExecutor.AbortPolicy());

    public AccountEntity getByPhone(String mobilePhone, Integer userType, String appCode) {
        return this.accountDao.findAccountEntityByMobilePhoneAndUserTypeAndAppCode(mobilePhone, userType, appCode);
    }

    public AccountEntity getByAccountId(String loginName, Integer userType, String appCode) {
        AccountEntity accountEntity = this.accountDao.findAccountEntityByLoginName(loginName, userType, appCode);
        if (null == accountEntity) {
            accountEntity = this.accountDao.findAccountEntityByMobilePhoneAndUserTypeAndAppCode(loginName, userType, appCode);
        }
        return accountEntity;
    }

    public void inert(List<AccountEntityVo> accountEntities) {
        ArrayList<AccountEntity> accountEntityList = new ArrayList<AccountEntity>();
        for (AccountEntityVo accountEntity : accountEntities) {
            AccountEntity accountEntity1;
            if (accountEntity.getAppCode().equals("PEC_PRES") && accountEntity.getUserType().equals(3) || accountEntity.getUserType().equals(1)) {
                accountEntity.setAppCode("PEC");
                AccountInfoBO accountInfoBO = new AccountInfoBO();
                accountInfoBO.setAccountInfoId(accountEntity.getAccountId());
                accountInfoBO.setAccountNo(accountEntity.getMobilePhone());
                accountInfoBO.setAccountPw(accountEntity.getPassword());
                accountInfoBO.setPwSalt(accountEntity.getSalt());
                accountInfoBO.setLoginName(accountEntity.getLoginName());
                accountInfoBO.setTelephone(accountEntity.getMobilePhone());
                accountInfoBO.setPwInitStatus(Integer.valueOf(2));
                accountInfoBO.setStatus(Integer.valueOf(1));
                String url = this.projProperties.getPatientUrl();
                try {
                    HttpKit.jsonPost((String)url, (String)JSON.toJSONString((Object)accountInfoBO));
                }
                catch (Exception e) {
                    log.error("\u540c\u6b65\u8d26\u53f7\u5230\u60e0\u5c14\u5eb7\u5931\u8d25\uff1a{}", (Object)accountEntity.getAccountId());
                    e.printStackTrace();
                }
            }
            if (accountEntity.getAppCode().equals("PEC_PAT") && accountEntity.getUserType().equals(3)) {
                accountEntity.setAppCode("PEC");
                String url = this.projProperties.getPresUrl();
                AccountInfoEntity accountInfoEntity = new AccountInfoEntity();
                accountInfoEntity.setId(accountEntity.getAccountId());
                accountInfoEntity.setAccountNo(accountEntity.getMobilePhone());
                accountInfoEntity.setAccountPw(accountEntity.getPassword());
                accountInfoEntity.setLoginName(accountEntity.getLoginName());
                accountInfoEntity.setTelephone(accountEntity.getMobilePhone());
                accountInfoEntity.setPwSalt(accountEntity.getSalt());
                accountInfoEntity.setTotalId(JSONObject.toJSONString((Object)accountEntity.getStoreIds()));
                accountInfoEntity.setStatus(Integer.valueOf(1));
                try {
                    HttpKit.jsonPost((String)url, (String)JSON.toJSONString((Object)accountInfoEntity));
                }
                catch (Exception e) {
                    log.error("\u540c\u6b65\u8d26\u53f7\u5230\u60e0\u5904\u65b9\u6d41\u8f6c\u5e73\u53f0\u5931\u8d25\uff1a{}", (Object)accountEntity.getAccountId());
                    e.printStackTrace();
                }
            }
            if (StringUtils.isBlank((CharSequence)accountEntity.getPassword()) && StringUtils.isBlank((CharSequence)accountEntity.getSalt())) {
                String passWord = accountEntity.getAccountId().substring(0, 5);
                PasswordAndSalt passwordAndSalt = PasswordUtil.mix((String)passWord);
                accountEntity.setSalt(passwordAndSalt.getSalt());
                accountEntity.setPassword(passwordAndSalt.getMixedPassword());
            }
            if (null != (accountEntity1 = this.accountDao.findAccountEntityByAccountId(accountEntity.getAccountId()))) {
                log.info("\u6267\u884c\u4fee\u6539\u64cd\u4f5c------>");
                accountEntity.set_id(accountEntity1.get_id());
                accountEntity.setPassword(accountEntity.getPassword());
                accountEntity.setSalt(accountEntity.getSalt());
            }
            AccountEntity accountEntity2 = new AccountEntity();
            BeanUtils.copyProperties((Object)accountEntity, (Object)accountEntity2);
            accountEntityList.add(accountEntity2);
        }
        this.accountDao.saveAll(accountEntityList);
    }

    public void resetPassword(ResetPassWordReqVo resetPassWordReqVo) {
        AccountEntity accountEntity = this.accountDao.findAccountEntityByAccountId(resetPassWordReqVo.getAccountId());
        String uuid = UUIDUtils.getUUID();
        String password = uuid.substring(0, 5);
        PasswordAndSalt p = PasswordUtil.mix((String)password);
        accountEntity.setStatus(Integer.valueOf(0));
        accountEntity.setPassword(p.getMixedPassword());
        accountEntity.setSalt(p.getSalt());
        this.accountDao.save((Object)accountEntity);
        SmsSendAuthCodeReqVO smsSendAuthCodeReqVO = new SmsSendAuthCodeReqVO();
        smsSendAuthCodeReqVO.setAppCode(accountEntity.getAppCode() == "cloud" ? "BYH" : accountEntity.getAppCode());
        smsSendAuthCodeReqVO.setPhone(accountEntity.getMobilePhone());
        smsSendAuthCodeReqVO.setUserType(Short.valueOf(Short.parseShort(accountEntity.getUserType().toString())));
        HashMap<String, String> param = new HashMap<String, String>(16);
        param.put("password", password);
        smsSendAuthCodeReqVO.setParam(param);
        this.pushUtils.getSms(smsSendAuthCodeReqVO);
    }

    public void setPassword(SetPassswordVo setPassswordVo) {
        AccountEntity accountEntity = this.accountDao.findAccountEntityByAccountId(setPassswordVo.getAccountId());
        accountEntity.setStatus(Integer.valueOf(1));
        accountEntity.setPassword(setPassswordVo.getPassword());
        this.accountDao.save((Object)accountEntity);
    }

    public void remove(String accountId, String token) {
        AccountEntity accountEntity = this.accountDao.findAccountEntityByAccountId(accountId);
        String url = this.projProperties.getPresdeleteUrl();
        this.accountDao.delete((Object)accountEntity);
        HashMap<String, String> headmap = new HashMap<String, String>();
        headmap.put("token", token);
        AccountBatchDeleteReqVO accountInfoEntity = new AccountBatchDeleteReqVO();
        ArrayList<String> accountids = new ArrayList<String>();
        accountids.add(accountId);
        accountInfoEntity.setAccountIds(accountids);
        try {
            HttpUtils.post((String)url, headmap, (String)JSON.toJSONString((Object)accountInfoEntity));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public AccountEntity findByAccountId(String accountId) {
        AccountEntity accountEntity = this.accountDao.findAccountEntityByAccountId(accountId);
        return accountEntity;
    }
}

