/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.authentication.center.aop;

import com.ebaiyihui.authentication.center.annotation.AccessCheck;
import com.ebaiyihui.authentication.center.token.AccessTokenService;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.annotation.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class AccessCheckAspect {
    private Logger log = LoggerFactory.getLogger(AccessCheckAspect.class);
    @Autowired
    private AccessTokenService tokenService;

    @Before(value="@within(accessCheck)")
    public void doBeforeForClass(AccessCheck accessCheck) {
        this.doBefore(accessCheck);
    }

    @Before(value="@annotation(accessCheck)")
    public void doBefore(AccessCheck accessCheck) {
        HttpServletRequest request = this.currentRequest();
        if (Objects.isNull(request)) {
            this.log.info("without request, skip");
            return;
        }
        String parameter = (String)request.getAttribute("token_verified");
        this.log.info("\u6743\u9650\u6821\u9a8c" + (Object)((Object)accessCheck.value()));
        if ("true".equalsIgnoreCase(parameter)) {
            return;
        }
        AccessCheck.PermissionType tokenAnno = accessCheck.value();
        StringBuffer requestURL = request.getRequestURL();
        if (AccessCheck.PermissionType.OPEN_API == tokenAnno) {
            this.log.info("\u8fdb\u5165OPEN_API==\u300b" + requestURL);
        } else if (AccessCheck.PermissionType.ACCESS_TOKEN_API == tokenAnno) {
            this.log.info("\u8fdb\u5165TOKEN_API==\u300b" + requestURL);
            String accessToken = request.getHeader("accessToken");
            if (!this.tokenService.validateAccessToken(accessToken).booleanValue()) {
                this.log.info("\u8fdb\u5165token\u6821\u9a8c \u4e0d\u901a\u8fc7==\u300b" + requestURL);
                throw new RuntimeException("token\u6821\u9a8c\u4e0d\u901a\u8fc7");
            }
        } else if (AccessCheck.PermissionType.BIZ_API == tokenAnno) {
            this.log.info("\u8fdb\u5165BIZ_API==\u300b" + requestURL);
        } else if (AccessCheck.PermissionType.ADMIN_API == tokenAnno) {
            this.log.info("\u8fdb\u5165ADMIN_API==\u300b" + requestURL);
        } else {
            this.log.info("\u63a5\u53e3\u672a\u52a0\u4efb\u4f55token\u6821\u9a8c\u6ce8\u89e3==>" + requestURL);
        }
        request.setAttribute("token_verified", (Object)"true");
        Object once_token_acc = request.getAttribute("token_verified");
        System.out.println(once_token_acc + "" + (Object)((Object)accessCheck.value()));
    }

    private HttpServletRequest currentRequest() {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        return Optional.ofNullable(servletRequestAttributes).map(ServletRequestAttributes::getRequest).orElse(null);
    }
}

