/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.authentication.center.config;

import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.authentication.center.config.AuthorityConfig;
import com.ebaiyihui.authentication.center.intercepter.ApiAccessInterceptor;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.context.request.WebRequestInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport;

@Configuration
public class ByhResourceServerConfiguration
extends WebMvcConfigurationSupport {
    Logger logger = LoggerFactory.getLogger(ByhResourceServerConfiguration.class);

    @Bean
    protected ApiAccessInterceptor apiAccessInterceptor() {
        return new ApiAccessInterceptor();
    }

    @Bean
    protected AuthorityConfig authorityConfig() {
        return new AuthorityConfig();
    }

    protected void addInterceptors(InterceptorRegistry registry) {
        InterceptorRegistration registration = registry.addWebRequestInterceptor((WebRequestInterceptor)this.apiAccessInterceptor());
        registration.addPathPatterns(new String[]{"/**"});
        registration.excludePathPatterns(new String[]{"/**/swagger-ui.html"});
        registration.excludePathPatterns(new String[]{"/**/*.html"});
        registration.excludePathPatterns(new String[]{"/**/*.jsp"});
        registration.excludePathPatterns(new String[]{"/**/error/**"});
        AuthorityConfig authorityConfig = this.authorityConfig();
        if (authorityConfig.isEnabled()) {
            List<String> whiteUriList = authorityConfig.getWhiteUriList();
            registration.excludePathPatterns(whiteUriList);
            this.logger.info("==\u8ba4\u8bc1\u670d\u52a1==\u63a5\u53e3\u767d\u540d\u5355\uff1a{}", (Object)JSONObject.toJSONString(whiteUriList));
            this.logger.info("==\u8ba4\u8bc1\u670d\u52a1==ip\u767d\u540d\u5355\uff1a{}", (Object)JSONObject.toJSONString(authorityConfig.getWhiteIpList()));
        } else {
            registration.excludePathPatterns(new String[]{"/**"});
            this.logger.info("==\u8ba4\u8bc1\u670d\u52a1==\u9274\u6743\u5173\u95ed==\u5c06\u5f00\u653e\u6240\u6709\u63a5\u53e3==");
        }
    }
}

