/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.authentication.center.config;

import java.time.Duration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CachingConfigurerSupport;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.core.env.Environment;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.GenericJackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.util.StringUtils;

public class RedisConfig
extends CachingConfigurerSupport {
    @Autowired
    private Environment env;
    private static Duration timeToLive;

    @Bean
    @Primary
    public RedisCacheManager cacheManager(RedisConnectionFactory redisConnectionFactory) {
        String keyPrefix = this.env.getProperty("spring.application.name");
        if (StringUtils.isEmpty((Object)keyPrefix)) {
            throw new RuntimeException("\u672a\u8bfb\u53d6\u5230spring.application.name\u914d\u7f6e\u7684\u503c");
        }
        String timeout = this.env.getProperty("spring.redis.timout");
        timeToLive = StringUtils.isEmpty((Object)timeout) ? Duration.ofHours(24L) : Duration.ofHours(Integer.parseInt(timeout));
        RedisCacheConfiguration cacheConfiguration = RedisCacheConfiguration.defaultCacheConfig().entryTtl(timeToLive).computePrefixWith(cacheName -> keyPrefix.concat(":").concat(cacheName).concat(":")).serializeKeysWith(RedisSerializationContext.SerializationPair.fromSerializer(this.myKeySerializer())).serializeValuesWith(RedisSerializationContext.SerializationPair.fromSerializer(this.myValueSerializer())).disableCachingNullValues();
        return RedisCacheManager.builder((RedisConnectionFactory)redisConnectionFactory).cacheDefaults(cacheConfiguration).build();
    }

    @Bean(name={"redisTemplate"})
    public RedisTemplate<String, Object> redisTemplate(RedisConnectionFactory redisConnectionFactory) {
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setConnectionFactory(redisConnectionFactory);
        redisTemplate.setKeySerializer(this.myKeySerializer());
        redisTemplate.setHashKeySerializer(this.myKeySerializer());
        redisTemplate.setValueSerializer(this.myValueSerializer());
        redisTemplate.setHashValueSerializer(this.myValueSerializer());
        return redisTemplate;
    }

    private RedisSerializer<String> myKeySerializer() {
        return new StringRedisSerializer();
    }

    private RedisSerializer<Object> myValueSerializer() {
        return new GenericJackson2JsonRedisSerializer();
    }
}

