/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.authentication.center.intercepter;

import feign.RequestInterceptor;
import feign.RequestTemplate;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Configuration
public class FeignAccessInterceptor
implements RequestInterceptor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public void apply(RequestTemplate requestTemplate) {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        String accessToken = request == null ? "" : request.getHeader("accessToken");
        this.log.info("===Feign Interceptor AccessToken: " + accessToken);
        requestTemplate.header("accessToken", new String[]{accessToken});
    }
}

