/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.card.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.card.common.enums.AppCodeEnum;
import com.ebaiyihui.card.common.enums.CardErrorEnum;
import com.ebaiyihui.card.common.vo.BasePatientRespVO;
import com.ebaiyihui.card.common.vo.CardDetailsInfoReqVO;
import com.ebaiyihui.card.common.vo.CardDetailsInfoRespVO;
import com.ebaiyihui.card.common.vo.HYCardInfoReqVo;
import com.ebaiyihui.card.common.vo.HYCardInfoResVo;
import com.ebaiyihui.card.common.vo.HYCardVerificationRequest;
import com.ebaiyihui.card.common.vo.HYCardVerificationResponse;
import com.ebaiyihui.card.common.vo.HytRegisterCardReqVO;
import com.ebaiyihui.card.common.vo.HytRegisterResVO;
import com.ebaiyihui.card.common.vo.NCEFYCardInfoResVo;
import com.ebaiyihui.card.common.vo.PatientCardNoCheckReqVo;
import com.ebaiyihui.card.common.vo.PatientNumQueryPatRes;
import com.ebaiyihui.card.common.vo.PatientNumQueryReq;
import com.ebaiyihui.card.common.vo.PersonInfoVO;
import com.ebaiyihui.card.common.vo.QueryCardInfoReqVo;
import com.ebaiyihui.card.common.vo.QueryCardReqVo;
import com.ebaiyihui.card.common.vo.RegisterCardReqVO;
import com.ebaiyihui.card.common.vo.RegisterCardReqVONew;
import com.ebaiyihui.card.common.vo.RegisterVirtualCardReqVO;
import com.ebaiyihui.card.common.vo.SavePatientInfoReqVo;
import com.ebaiyihui.card.common.vo.UpdateCardInfoReqVO;
import com.ebaiyihui.card.common.vo.ehc.EhcFindCardVO;
import com.ebaiyihui.card.common.vo.ehc.EhcRegisterCardVO;
import com.ebaiyihui.card.server.common.CardStatusEnums;
import com.ebaiyihui.card.server.common.CommonEnums;
import com.ebaiyihui.card.server.common.EhcConstants;
import com.ebaiyihui.card.server.common.SexEnum;
import com.ebaiyihui.card.server.exception.CardRuntimeException;
import com.ebaiyihui.card.server.pojo.entity.CardEntity;
import com.ebaiyihui.card.server.pojo.entity.RegisteredCardResVO;
import com.ebaiyihui.card.server.service.BaseService;
import com.ebaiyihui.card.server.service.ICardService;
import com.ebaiyihui.card.server.util.DateUtils;
import com.ebaiyihui.card.server.util.MessageUtils;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.response.IError;
import com.ebaiyihui.framework.utils.IdCardUtil;
import com.ebaiyihui.framework.utils.JsonUtil;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.base.GatewayRequest;
import com.ebaiyihui.his.pojo.vo.base.GatewayResponse;
import com.ebaiyihui.his.pojo.vo.card.QueryCardInfoReqVO;
import com.ebaiyihui.his.pojo.vo.card.QueryCardInfoResVO;
import com.ebaiyihui.his.pojo.vo.card.RegisteredCardReqVO;
import com.ydwy.ehcmssdk.EhcmsUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Service
public class CardServiceImpl
extends BaseService
implements ICardService {
    private static String ID_CARD_CODE = "01";
    private static String HYTCHANNEL = "byh-card";
    private static String HYTCHANNELNAME = "\u4e2d\u536b\u4f70\u533b";
    private static String HYTFAILCODE = "0";
    private static String MZJH = "MZJH";
    private static String YYHT = "YYHT";
    private static final String SUCCESS_FLAG = "1";
    private String appId;
    private String termID;
    @Value(value="${baseCloudUrl}")
    protected String baseCloudUrl;
    @Value(value="${htzxBaseCloudUrl}")
    protected String htzxBaseCloudUrl;
    @Value(value="${ncefyBaseCloudUrl}")
    private String ncefyBaseCloudUrl;
    private String bdUrl = "http://111.61.102.82:9097";

    public BaseResponse<CardDetailsInfoRespVO> updateCardInfo(UpdateCardInfoReqVO reqVO) {
        log.info("\u66f4\u65b0\u5361\u5165\u53c2\uff1a{}", (Object)JsonUtil.convertObject((Object)reqVO));
        Optional cardOp = this.cardRepository.findByCardId(reqVO.getCardId());
        if (!cardOp.isPresent()) {
            log.warn("\u5c31\u8bca\u5361\u4e0d\u5b58\u5728,\u5c31\u8bca\u5361ID={}", (Object)reqVO.getCardId());
            String msg = MessageUtils.get((String)CardErrorEnum.CARD_NOT_EXIST.name());
            return BaseResponse.error((String)msg);
        }
        CardEntity card = (CardEntity)cardOp.get();
        log.info("\u4fee\u6539\u5c31\u8bca\u5361\u8d44\u6599\u8bf7\u6c42\u53c2\u6570={},\u539f\u5361\u4fe1\u606f={}", (Object)JsonUtil.convertObject((Object)reqVO), (Object)JsonUtil.convertObject((Object)card));
        this.updateCardInfo(reqVO, card);
        log.info("\u4fee\u6539\u5c31\u8bca\u5361\u8d44\u6599\u6210\u529f,\u65b0\u5361\u4fe1\u606f={}", (Object)JsonUtil.convertObject((Object)card));
        CardDetailsInfoRespVO data = this.buildCardDetailsInfo(card);
        return BaseResponse.success((Object)data);
    }

    public BaseResponse<CardDetailsInfoRespVO> getCardDetail(CardDetailsInfoReqVO reqVO) {
        log.info("\u83b7\u53d6\u5361\u8be6\u60c5\u5165\u53c2\uff1a{}", (Object)JsonUtil.convertObject((Object)reqVO));
        Optional cardOp = this.cardRepository.findByCardId(reqVO.getCardId());
        if (!cardOp.isPresent()) {
            log.warn("\u5c31\u8bca\u5361\u4e0d\u5b58\u5728,\u5c31\u8bca\u5361ID={}", (Object)reqVO.getCardId());
            String msg = MessageUtils.get((String)CardErrorEnum.CARD_NOT_EXIST.name());
            return BaseResponse.error((String)msg);
        }
        CardEntity card = (CardEntity)cardOp.get();
        CardDetailsInfoRespVO cardDetailsInfoRespVO = this.buildCardDetailsInfo(card);
        return BaseResponse.success((Object)cardDetailsInfoRespVO);
    }

    public BaseResponse<CardDetailsInfoRespVO> getHisCardDetails(CardDetailsInfoReqVO reqVO) {
        log.info("\u83b7\u53d6\u5361\u8be6\u60c5\u5165\u53c2\uff1a{}", (Object)JsonUtil.convertObject((Object)reqVO));
        CardEntity cardOp = this.cardRepository.findHisCardDetails(reqVO.getCardNo());
        if (Objects.isNull(cardOp)) {
            log.warn("\u5b9e\u4f53\u5c31\u8bca\u5361\u4e0d\u5b58\u5728,\u5c31\u8bca\u5361ID={}", (Object)reqVO.getCardId());
            String msg = MessageUtils.get((String)CardErrorEnum.CARD_NOT_EXIST.name());
            return BaseResponse.error((String)msg);
        }
        CardDetailsInfoRespVO cardDetailsInfoRespVO = this.buildCardDetailsInfo(cardOp);
        return BaseResponse.success((Object)cardDetailsInfoRespVO);
    }

    public BaseResponse<CardDetailsInfoRespVO> registerOrBindCard(RegisterCardReqVO reqVO) {
        log.info("\u6ce8\u518c\u6216\u7ed1\u5b9a\u5361\u5165\u53c2\uff1a{}", (Object)JsonUtil.convertObject((Object)reqVO));
        if (ID_CARD_CODE.equals(reqVO.getCredTypeCode()) && !IdCardUtil.validateIdCard18((String)reqVO.getCredNo())) {
            log.warn("\u8eab\u4efd\u8bc1\u9a8c\u8bc1\u5931\u8d25[{}],\u5361\u4fe1\u606f[{}]", (Object)JsonUtil.convertObject((Object)reqVO), (Object)reqVO.getCredNo());
            throw new CardRuntimeException(CardErrorEnum.PARAM_CHECK_FAILD, "\u60a8\u8f93\u5165\u7684\u8bc1\u4ef6\u53f7\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
        CardEntity card = new CardEntity();
        BeanUtils.copyProperties((Object)reqVO, (Object)card);
        card.setStatus(CardStatusEnums.NORMAL);
        if ("1702".equals(reqVO.getCardTypeCode())) {
            BaseResponse cardDetailsInfoRespVO = this.getAttendanceCardDetailsInfo(reqVO, card);
            if (cardDetailsInfoRespVO != null) {
                return cardDetailsInfoRespVO;
            }
        } else if ("1703".equals(reqVO.getCardTypeCode())) {
            BaseResponse cardDetailsInfoRespVO = this.getVirtualCardDetail(reqVO, card);
            if (cardDetailsInfoRespVO != null) {
                return cardDetailsInfoRespVO;
            }
        } else if ("1801".equals(reqVO.getCardTypeCode())) {
            BaseResponse cardDetailsInfoRespVO = this.getEhcCardDetailsInfo(reqVO, card);
            if (cardDetailsInfoRespVO != null) {
                return cardDetailsInfoRespVO;
            }
        } else {
            String msg = MessageUtils.get((String)CardErrorEnum.CARD_TYPE_NOT_EXIST.name());
            return BaseResponse.error((String)msg);
        }
        log.info("\u5f00\u59cb\u4fdd\u5b58\u60a3\u8005\u4fe1\u606f\uff1a==============================");
        return this.saveCard(card, reqVO.getAppCode(), reqVO.getChannelCode());
    }

    public BaseResponse<CardDetailsInfoRespVO> registerOrBindCardBD(RegisterCardReqVO reqVO) {
        log.info("\u6ce8\u518c\u6216\u7ed1\u5b9a\u5361\u5165\u53c2\uff1a{}", (Object)JsonUtil.convertObject((Object)reqVO));
        if (ID_CARD_CODE.equals(reqVO.getCredTypeCode()) && !IdCardUtil.validateIdCard18((String)reqVO.getCredNo())) {
            log.warn("\u8eab\u4efd\u8bc1\u9a8c\u8bc1\u5931\u8d25[{}],\u5361\u4fe1\u606f[{}]", (Object)JsonUtil.convertObject((Object)reqVO), (Object)reqVO.getCredNo());
            throw new CardRuntimeException(CardErrorEnum.PARAM_CHECK_FAILD, "\u60a8\u8f93\u5165\u7684\u8bc1\u4ef6\u53f7\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
        CardEntity card = new CardEntity();
        BeanUtils.copyProperties((Object)reqVO, (Object)card);
        card.setStatus(CardStatusEnums.NORMAL);
        BaseResponse cardDetailsInfoRespVO = this.getNewAttendanceCardDetailsInfo(reqVO, card);
        if (cardDetailsInfoRespVO != null) {
            return cardDetailsInfoRespVO;
        }
        log.info("\u5f00\u59cb\u4fdd\u5b58\u60a3\u8005\u4fe1\u606f\uff1a==============================");
        return this.saveCard(card, reqVO.getAppCode(), reqVO.getChannelCode());
    }

    private BaseResponse<CardDetailsInfoRespVO> getAttendanceCardDetailsInfo(RegisterCardReqVO reqVO, CardEntity card) {
        GatewayResponse hisCardInfoResp = this.queryHisCardInfo(reqVO.getAppCode(), reqVO.getOrganCode(), null, reqVO.getCredNo(), reqVO.getCardTypeCode(), reqVO.getCredTypeCode(), reqVO.getPatientName());
        if (hisCardInfoResp.isSuccess() && hisCardInfoResp.getData() != null) {
            BaseResponse cardDetailsInfoRespVO = this.getAttendanceCardDetailsInfoRespVO(reqVO, card, hisCardInfoResp);
            if (cardDetailsInfoRespVO != null) {
                return cardDetailsInfoRespVO;
            }
        } else {
            GatewayResponse hisRegisterResp = this.hisRegisterCard(reqVO);
            log.info("\u5c31\u8bca\u5361\u6ce8\u518c\u8fd4\u56de\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)hisCardInfoResp));
            if (!hisRegisterResp.isSuccess() || null == hisRegisterResp.getData()) {
                String msg = MessageUtils.get((String)CardErrorEnum.HIS_REGISTER_CARD_WRONG.name());
                return BaseResponse.error((String)msg);
            }
            card.setCardNo(((com.ebaiyihui.his.pojo.vo.card.RegisteredCardResVO)hisRegisterResp.getData()).getCardNo());
            card.setOrganPmi(((com.ebaiyihui.his.pojo.vo.card.RegisteredCardResVO)hisRegisterResp.getData()).getPatientId());
        }
        return null;
    }

    private BaseResponse<CardDetailsInfoRespVO> getNewAttendanceCardDetailsInfo(RegisterCardReqVO reqVO, CardEntity card) {
        BaseResponse hisCardInfoResp = this.queryCardInfoBD(reqVO, card);
        if (hisCardInfoResp.isSuccess() && hisCardInfoResp.getData() != null) {
            card.setCardNo(((QueryCardInfoResVO)hisCardInfoResp.getData()).getCardNo());
            card.setOrganPmi(((QueryCardInfoResVO)hisCardInfoResp.getData()).getPatientId());
            card.setHisAddress(((QueryCardInfoResVO)hisCardInfoResp.getData()).getAddress());
            BaseResponse cardDetails = this.getCardDetails(card);
            if (cardDetails != null) {
                return cardDetails;
            }
        } else {
            GatewayResponse hisRegisterResp = this.queryNewHisCardInfo(reqVO, card);
            log.info("\u5c31\u8bca\u5361\u6ce8\u518c\u8fd4\u56de\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)hisCardInfoResp));
            if (!hisRegisterResp.isSuccess() || null == hisRegisterResp.getData()) {
                String msg = MessageUtils.get((String)CardErrorEnum.HIS_REGISTER_CARD_WRONG.name());
                return BaseResponse.error((String)msg);
            }
            card.setCardNo(((QueryCardInfoResVO)hisRegisterResp.getData()).getCardNo());
            card.setOrganPmi(((QueryCardInfoResVO)hisRegisterResp.getData()).getPatientId());
        }
        return null;
    }

    private BaseResponse<QueryCardInfoResVO> queryCardInfoBD(RegisterCardReqVO reqVO, CardEntity card) {
        QueryCardInfoReqVO queryCardInfoReqVO = new QueryCardInfoReqVO();
        queryCardInfoReqVO.setCredNo(reqVO.getCredNo());
        FrontRequest cardQueryReq = new FrontRequest();
        cardQueryReq.setChannel("byh-card");
        cardQueryReq.setChannelName("\u4e2d\u536b\u4f70\u533b");
        cardQueryReq.setBody((Object)queryCardInfoReqVO);
        cardQueryReq.setOrganCode(reqVO.getOrganCode());
        cardQueryReq.setTransactionId(UUID.randomUUID().toString());
        GatewayResponse hisReturn = new GatewayResponse();
        ResponseEntity responseEntity = this.GetCardInfoBD(cardQueryReq);
        if (null == ((FrontResponse)responseEntity.getBody()).getBody()) {
            return hisReturn;
        }
        String result = JsonUtil.convertObject((Object)((FrontResponse)responseEntity.getBody()).getBody());
        RegisteredCardResVO registeredCardResVO = (RegisteredCardResVO)JsonUtil.convertObject((String)result, RegisteredCardResVO.class);
        QueryCardInfoResVO queryCardInfoResVO = new QueryCardInfoResVO();
        String birthStr = IdCardUtil.getBirthByIdCard2((String)reqVO.getCredNo());
        queryCardInfoResVO.setCardNo(registeredCardResVO.getCardNo());
        queryCardInfoResVO.setCardType("01");
        String genderStr = IdCardUtil.getGenderByIdCard((String)reqVO.getCredNo());
        queryCardInfoResVO.setSex(genderStr);
        queryCardInfoResVO.setName(reqVO.getPatientName());
        queryCardInfoResVO.setDob(birthStr);
        queryCardInfoResVO.setCredNo(reqVO.getCredNo());
        queryCardInfoResVO.setTelephone(reqVO.getTel());
        queryCardInfoResVO.setAddress(reqVO.getDetailAddress());
        queryCardInfoResVO.setPatientNo(registeredCardResVO.getCredNo());
        GatewayResponse response = new GatewayResponse();
        response.setData((Object)queryCardInfoResVO);
        response.setCode(((FrontResponse)responseEntity.getBody()).getCode());
        response.setTransactionId(((FrontResponse)responseEntity.getBody()).getTransactionId());
        response.setErrCode(((FrontResponse)responseEntity.getBody()).getErrCode());
        response.setMsg(((FrontResponse)responseEntity.getBody()).getMessage());
        hisReturn = response;
        log.info("HIS\u67e5\u8be2\u5c31\u8bca\u5361\uff0c\u8bf7\u6c42\u53c2\u6570={},\u54cd\u5e94={}", (Object)JsonUtil.convertObject((Object)cardQueryReq), (Object)JsonUtil.convertObject((Object)hisReturn));
        return hisReturn;
    }

    private BaseResponse<CardDetailsInfoRespVO> getAttendanceCardDetailsInfoRespVO(RegisterCardReqVO reqVO, CardEntity card, GatewayResponse<QueryCardInfoResVO> hisCardInfoResp) {
        this.checkHisCardInfoAndBindCardInfo((QueryCardInfoResVO)hisCardInfoResp.getData(), reqVO);
        card.setCardNo(((QueryCardInfoResVO)hisCardInfoResp.getData()).getCardNo());
        card.setOrganPmi(((QueryCardInfoResVO)hisCardInfoResp.getData()).getPatientId());
        card.setHisAddress(((QueryCardInfoResVO)hisCardInfoResp.getData()).getAddress());
        return this.getCardDetails(card);
    }

    private BaseResponse<CardDetailsInfoRespVO> getVirtualCardDetail(RegisterCardReqVO reqVO, CardEntity card) {
        card.setCardNo(reqVO.getCredNo());
        card.setOrganPmi(null);
        return this.getCardDetails(card);
    }

    private BaseResponse<CardDetailsInfoRespVO> getCardDetails(CardEntity card) {
        Optional cardOp = this.cardRepository.findOneByCardNoAndOrganCode(card.getCardNo(), card.getOrganCode());
        if (cardOp.isPresent()) {
            CardEntity cardEntity = (CardEntity)cardOp.get();
            cardEntity.setTel(card.getTel());
            this.cardRepository.save((Object)cardEntity);
            CardDetailsInfoRespVO cardDetailsInfoRespVO = this.buildCardDetailsInfo(cardEntity);
            return BaseResponse.success((Object)cardDetailsInfoRespVO);
        }
        return null;
    }

    private BaseResponse<CardDetailsInfoRespVO> getZrCardDetails(CardEntity card) {
        Optional cardOp = this.cardRepository.findOneByCardNoAndOrganCode(card.getCardNo(), card.getOrganCode());
        log.info("\u67e5\u8be2\u5361\u4fe1\u606f\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)card));
        if (cardOp.isPresent()) {
            CardEntity cardEntity = (CardEntity)cardOp.get();
            log.info("\u83b7\u53d6\u7684\u5361\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)cardEntity));
            CardDetailsInfoRespVO cardDetailsInfoRespVO = this.buildCardDetailsInfo(cardEntity);
            return BaseResponse.success((Object)cardDetailsInfoRespVO);
        }
        return null;
    }

    public BaseResponse<List<CardDetailsInfoRespVO>> getCardDetailByPmi(CardDetailsInfoReqVO reqVO) {
        log.info("\u6839\u636epmi\u83b7\u53d6\u5c31\u8bca\u5361\u8be6\u60c5\u5217\u8868\u5165\u53c2\uff1a{}", (Object)JsonUtil.convertObject((Object)reqVO));
        List byCodeAndOrganPmi = this.cardRepository.findByCodeAndOrganPmi(reqVO.getOrganCode(), reqVO.getOrganPmi());
        if (byCodeAndOrganPmi == null) {
            log.warn("\u5c31\u8bca\u5361\u4e0d\u5b58\u5728,\u5c31\u8bca\u5361ID={}", (Object)reqVO.getCardId());
            String msg = MessageUtils.get((String)CardErrorEnum.CARD_NOT_EXIST.name());
            return BaseResponse.error((String)msg);
        }
        ArrayList list = new ArrayList();
        byCodeAndOrganPmi.stream().forEach(e -> {
            CardDetailsInfoRespVO cardDetailsInfoRespVO = this.buildCardDetailsInfo(e);
            list.add(cardDetailsInfoRespVO);
        });
        return BaseResponse.success(list);
    }

    public BaseResponse<CardDetailsInfoRespVO> registerVirtualCard(RegisterVirtualCardReqVO reqVO) {
        log.info("\u4f1a\u8bca\u4f7f\u7528\u6ce8\u518c\u865a\u62df\u5361\u5165\u53c2\uff1a{}", (Object)JsonUtil.convertObject((Object)reqVO));
        if (ID_CARD_CODE.equals(reqVO.getCredTypeCode()) && !IdCardUtil.validateIdCard18((String)reqVO.getCredNo())) {
            log.warn("\u8eab\u4efd\u8bc1\u9a8c\u8bc1\u5931\u8d25[{}],\u5361\u4fe1\u606f[{}]", (Object)JsonUtil.convertObject((Object)reqVO), (Object)reqVO.getCredNo());
            throw new CardRuntimeException(CardErrorEnum.PARAM_CHECK_FAILD, "\u60a8\u8f93\u5165\u7684\u8bc1\u4ef6\u53f7\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
        CardEntity card = new CardEntity();
        card.setCardNo(reqVO.getCredNo());
        card.setCardTypeCode("1703");
        card.setCardTypeName("\u865a\u62df\u5c31\u8bca\u5361");
        card.setCredNo(reqVO.getCredNo());
        card.setRegisterResource("\u4f1a\u8bca\u521b\u5efa");
        card.setCredTypeCode(reqVO.getCredTypeCode());
        card.setCredTypeName(reqVO.getCredTypeName());
        card.setPatientName(reqVO.getPatientName());
        card.setOrganCode("10000000");
        card.setOrganName("\u4f70\u533b\u5e73\u53f0");
        card.setOccupationCode("09");
        card.setOccupationName("\u5176\u4ed6");
        card.setTel(reqVO.getTel());
        card.setStatus(CardStatusEnums.NORMAL);
        CardEntity byCardNoAndCardType = this.cardRepository.findByCardNoAndCardType(card.getCardNo(), card.getCardTypeCode());
        if (null != byCardNoAndCardType) {
            byCardNoAndCardType.setTel(card.getTel());
            this.cardRepository.save((Object)byCardNoAndCardType);
            CardDetailsInfoRespVO cardDetailsInfoRespVO = this.buildCardDetailsInfo(byCardNoAndCardType);
            return BaseResponse.success((Object)cardDetailsInfoRespVO);
        }
        return this.saveCard(card, reqVO.getAppCode(), reqVO.getChannelCode());
    }

    public BaseResponse<List<CardDetailsInfoRespVO>> bindListCard(RegisterCardReqVO reqVO) {
        log.info("\u4e2d\u65e5\u53cb\u597d\u5361\u670d\u52a1\u5165\u53c2\uff1a{}", (Object)JsonUtil.convertObject((Object)reqVO));
        String genderByIdCard = IdCardUtil.getGenderByIdCard((String)reqVO.getCredNo());
        if ("M".equals(genderByIdCard)) {
            reqVO.setGender(Short.valueOf(CommonEnums.GenderTypeEnum.MALE.getValue().shortValue()));
        } else if ("F".equals(genderByIdCard)) {
            reqVO.setGender(Short.valueOf(CommonEnums.GenderTypeEnum.FEMALE.getValue().shortValue()));
        } else {
            reqVO.setGender(Short.valueOf(CommonEnums.GenderTypeEnum.UNKNOWNGENDER.getValue().shortValue()));
        }
        ArrayList list = new ArrayList();
        FrontResponse patientNumQueryPatListRes = this.getPatientNumQueryPatListRes(reqVO);
        if ("0".equals(patientNumQueryPatListRes.getCode())) {
            return BaseResponse.error((String)patientNumQueryPatListRes.getMessage());
        }
        String result = JsonUtil.convertObject((Object)patientNumQueryPatListRes.getBody());
        List body = JSONArray.parseArray((String)result, PatientNumQueryPatRes.class);
        CardEntity card = new CardEntity();
        BeanUtils.copyProperties((Object)reqVO, (Object)card);
        String patientId = this.getPatientId(reqVO, card);
        for (PatientNumQueryPatRes pnqplr : body) {
            String firstPatCardNo;
            CardEntity temp = new CardEntity();
            String firstPatCardType = pnqplr.getPatCardType();
            FrontResponse frontResponse = this.getHisPatientId(reqVO, firstPatCardType, firstPatCardNo = pnqplr.getPatCardNo());
            if ("0".equals(frontResponse.getCode())) {
                return BaseResponse.error((String)frontResponse.getMessage());
            }
            String hisPatientId = frontResponse.getBody().toString();
            BeanUtils.copyProperties((Object)reqVO, (Object)temp);
            temp.setOrganPmi(hisPatientId);
            this.initAndSaveCard(reqVO, list, temp, patientId, pnqplr);
        }
        return BaseResponse.success(list);
    }

    private void initAndSaveCard(RegisterCardReqVO reqVO, List<CardDetailsInfoRespVO> list, CardEntity card, String patientId, PatientNumQueryPatRes pnqplr) {
        String patCardType = pnqplr.getPatCardType();
        String patCardNo = pnqplr.getPatCardNo();
        card.setCardNo(patCardNo);
        card.setGender(reqVO.getGender());
        card.setCardTypeCode(patCardType);
        card.setCredNo(reqVO.getCredNo());
        card.setCredTypeCode(reqVO.getCredTypeCode());
        card.setCredTypeName(reqVO.getCredTypeName());
        card.setOrganCode(reqVO.getOrganCode());
        card.setOrganName(reqVO.getOrganName());
        card.setRegisterResource("zryh");
        card.setStatus(CardStatusEnums.NORMAL);
        card.setTel(reqVO.getTel());
        if (SUCCESS_FLAG.equals(patCardType)) {
            card.setCardTypeName("\u81ea\u8d39\u5361");
        } else if ("2".equals(patCardType)) {
            card.setCardTypeName("\u793e\u4fdd\u5361");
        }
        card.setPatientId(patientId);
        card.setCardId(String.valueOf(this.uniqueID.nextId()));
        BaseResponse cardDetails = this.getZrCardDetails(card);
        if (cardDetails == null) {
            log.info("card info =" + JSONObject.toJSONString((Object)card));
            CardDetailsInfoRespVO cardDetailsInfoRespVO = this.buildCardDetailsInfo(card);
            list.add(cardDetailsInfoRespVO);
        } else {
            list.add((CardDetailsInfoRespVO)cardDetails.getData());
        }
    }

    private String getPatientId(RegisterCardReqVO reqVO, CardEntity card) {
        SavePatientInfoReqVo savePatientReq = this.getSavePatientInfoReqVo(card, reqVO.getAppCode(), reqVO.getChannelCode());
        BaseResponse savePatientResp = this.iPatienInfoService.savePatientInfo(savePatientReq);
        log.info("\u8bf7\u6c42\u60a3\u8005\u670d\u52a1\u83b7\u53d6\u60a3\u8005\u4fe1\u606f,\u8bf7\u6c42={},\u54cd\u5e94={}", (Object)JsonUtil.convertObject((Object)savePatientReq), (Object)JsonUtil.convertObject((Object)savePatientResp));
        return ((BasePatientRespVO)savePatientResp.getData()).getPatientId();
    }

    private FrontResponse getPatientNumQueryPatListRes(RegisterCardReqVO reqVO) {
        PatientNumQueryReq patientNumQueryReq = new PatientNumQueryReq();
        patientNumQueryReq.setIdCardType(reqVO.getCredTypeCode());
        patientNumQueryReq.setIdCardNo(reqVO.getCredNo());
        patientNumQueryReq.setPatName(reqVO.getPatientName());
        FrontRequest frontRequest = new FrontRequest();
        frontRequest.setBody((Object)patientNumQueryReq);
        String reqUrl = this.baseCloudUrl.concat("/zryh-his/api/v1/patient/getPatientNum");
        log.info("\u4e2d\u65e5\u8c03\u7528\u524d\u7f6e\u673a\u83b7\u53d6\u5361\u4fe1\u606f\u5165\u53c2\uff1a{}", (Object)JsonUtil.convertObject((Object)frontRequest));
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity response = restTemplate.postForEntity(reqUrl, (Object)frontRequest, FrontResponse.class, new Object[0]);
        log.info("\u4e2d\u65e5\u8c03\u7528\u524d\u7f6e\u673a\u83b7\u53d6\u5361\u4fe1\u606f\u8fd4\u53c2\uff1a{}", (Object)JsonUtil.convertObject((Object)response.getBody()));
        return (FrontResponse)response.getBody();
    }

    private FrontResponse getHisPatientId(RegisterCardReqVO reqVO, String firstPatCardType, String firstPatCardNo) {
        FrontRequest frontRequest = this.initGetHisPatientIdParam(reqVO, firstPatCardType, firstPatCardNo);
        String reqUrl = this.baseCloudUrl.concat("/zryh-his/api/v1/patient/patientCardNoCheck");
        log.info("\u4e2d\u65e5\u8c03\u7528\u524d\u7f6e\u673a\u83b7\u53d6\u60a3\u8005ID\u5165\u53c2\uff1a{}", (Object)JsonUtil.convertObject((Object)frontRequest));
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity response = restTemplate.postForEntity(reqUrl, (Object)frontRequest, FrontResponse.class, new Object[0]);
        log.info("\u4e2d\u65e5\u8c03\u7528\u524d\u7f6e\u673a\u83b7\u53d6\u60a3\u8005ID\u8fd4\u53c2\uff1a{}", (Object)JsonUtil.convertObject((Object)response.getBody()));
        return (FrontResponse)response.getBody();
    }

    private FrontRequest initGetHisPatientIdParam(RegisterCardReqVO reqVO, String firstPatCardType, String firstPatCardNo) {
        PatientCardNoCheckReqVo patientCardNoCheckReqV = new PatientCardNoCheckReqVo();
        patientCardNoCheckReqV.setPatCardNo(firstPatCardNo);
        patientCardNoCheckReqV.setIdCardType(reqVO.getCredTypeCode());
        patientCardNoCheckReqV.setIdCardNo(reqVO.getCredNo());
        patientCardNoCheckReqV.setPatCardType(firstPatCardType);
        patientCardNoCheckReqV.setPatName(reqVO.getPatientName());
        patientCardNoCheckReqV.setPhoneNo(reqVO.getTel());
        FrontRequest frontRequest = new FrontRequest();
        frontRequest.setChannel(reqVO.getChannelCode());
        frontRequest.setBody((Object)patientCardNoCheckReqV);
        frontRequest.setChannelName(reqVO.getChannelName());
        frontRequest.setOrganCode(reqVO.getOrganCode());
        frontRequest.setTransactionId(String.valueOf(Instant.now().toEpochMilli()));
        return frontRequest;
    }

    private void updateCardInfo(UpdateCardInfoReqVO reqVO, CardEntity card) {
        card.setCityAreaCode(reqVO.getCityAreaCode());
        card.setCityAreaName(reqVO.getCityAreaName());
        card.setCityCode(reqVO.getCityCode());
        card.setCityName(reqVO.getCityName());
        card.setDetailAddress(reqVO.getDetailAddress());
        card.setOccupationCode(reqVO.getOccupationCode());
        card.setOccupationName(reqVO.getOccupationName());
        card.setProvinceCode(reqVO.getProvinceCode());
        card.setProvinceName(reqVO.getProvinceName());
        card.setTel(reqVO.getTel());
        card.setNationCode(reqVO.getNationCode());
        card.setNationName(reqVO.getNationName());
        card.setGender(reqVO.getGender());
        card.setBirth(reqVO.getBirthStr());
        this.cardRepository.save((Object)card);
    }

    private CardDetailsInfoRespVO buildCardDetailsInfo(CardEntity card) {
        String birth;
        CardDetailsInfoRespVO cardDetailsInfoRespVO = new CardDetailsInfoRespVO();
        BeanUtils.copyProperties((Object)card, (Object)cardDetailsInfoRespVO);
        cardDetailsInfoRespVO.setCardStatus(Short.valueOf((short)card.getStatus().ordinal()));
        cardDetailsInfoRespVO.setCardStatusDesc(card.getStatus().getDesc());
        if (IdCardUtil.validateIdCard18((String)card.getCredNo())) {
            cardDetailsInfoRespVO.setBirth(IdCardUtil.getBirthByIdCard2((String)card.getCredNo()));
        }
        if ((birth = card.getBirth()) != null && !"".equals(birth)) {
            cardDetailsInfoRespVO.setBirth(birth);
        }
        return cardDetailsInfoRespVO;
    }

    private BaseResponse<CardDetailsInfoRespVO> saveCard(CardEntity card, String appCode, String channelCode) {
        SavePatientInfoReqVo savePatientReq = this.getSavePatientInfoReqVo(card, appCode, channelCode);
        BaseResponse savePatientResp = this.iPatienInfoService.savePatientInfo(savePatientReq);
        log.info("\u8bf7\u6c42\u60a3\u8005\u670d\u52a1\u83b7\u53d6\u60a3\u8005\u4fe1\u606f,\u8bf7\u6c42={},\u54cd\u5e94={}", (Object)JsonUtil.convertObject((Object)savePatientReq), (Object)JsonUtil.convertObject((Object)savePatientResp));
        if (savePatientResp.isSuccess()) {
            BasePatientRespVO patientInfo = (BasePatientRespVO)savePatientResp.getData();
            card.setPatientId(patientInfo.getPatientId());
            card.setCardId(String.valueOf(this.uniqueID.nextId()));
            this.cardRepository.save((Object)card);
            log.info("\u5c31\u8bca\u5361\u4fdd\u5b58\u6210\u529f,,\u5c31\u8bca\u5361\u4fe1\u606f={}", (Object)JsonUtil.convertObject((Object)card));
            CardDetailsInfoRespVO cardDetailsInfoRespVO = this.buildCardDetailsInfo(card);
            return BaseResponse.success((Object)cardDetailsInfoRespVO);
        }
        return BaseResponse.error((IError)IError.FEIGN_FAIL, (String)savePatientResp.getMsg());
    }

    private SavePatientInfoReqVo getSavePatientInfoReqVo(CardEntity card, String appCode, String channelCode) {
        String genderStr;
        SavePatientInfoReqVo savePatientReq = new SavePatientInfoReqVo();
        savePatientReq.setAppCode(appCode);
        savePatientReq.setChannelCode(channelCode);
        savePatientReq.setName(card.getPatientName());
        savePatientReq.setCredNo(card.getCredNo());
        savePatientReq.setCredTypeCode(card.getCredTypeCode());
        savePatientReq.setContactMobile(card.getTel());
        savePatientReq.setProvinceCode(card.getProvinceCode());
        savePatientReq.setCityCode(card.getCityCode());
        savePatientReq.setCityAreaCode(card.getCityAreaCode());
        savePatientReq.setHospitalId(card.getOrganCode());
        String birthStr = IdCardUtil.getBirthByIdCard2((String)card.getCredNo());
        if (birthStr != null) {
            try {
                Date dob = DateUtils.formatDate((String)birthStr);
                savePatientReq.setBirthdate(dob);
            }
            catch (ParseException e) {
                log.warn("\u8bc1\u4ef6\u53f7\u89e3\u6790\u51fa\u751f\u65e5\u671f\u5931\u8d25,e={}", (Throwable)e);
            }
        }
        if (!StringUtils.isEmpty((Object)(genderStr = IdCardUtil.getGenderByIdCard((String)card.getCredNo())))) {
            if ("M".equals(genderStr)) {
                card.setGender(Short.valueOf(CommonEnums.GenderTypeEnum.MALE.getValue().shortValue()));
            } else {
                card.setGender(Short.valueOf(CommonEnums.GenderTypeEnum.FEMALE.getValue().shortValue()));
            }
            savePatientReq.setGender(card.getGender());
        }
        return savePatientReq;
    }

    private Boolean checkHisCardInfoAndBindCardInfo(QueryCardInfoResVO hisCardInfo, RegisterCardReqVO bindCardInfo) {
        if (!hisCardInfo.getName().equals(bindCardInfo.getPatientName())) {
            throw new CardRuntimeException(CardErrorEnum.BIND_CARD_PATIENT_NAME_WRONG);
        }
        return Boolean.TRUE;
    }

    private GatewayResponse<QueryCardInfoResVO> queryHisCardInfo(String appCode, String organCode, String cardNo, String credNo, String cardType, String credType, String name) {
        QueryCardInfoReqVO cardQueryBody = new QueryCardInfoReqVO();
        cardQueryBody.setCardNo(cardNo);
        cardQueryBody.setCardType(cardType);
        cardQueryBody.setName(name);
        cardQueryBody.setCredType(credType);
        cardQueryBody.setCredNo(credNo);
        GatewayRequest cardQueryReq = new GatewayRequest();
        cardQueryReq.setChannel("byh-card");
        cardQueryReq.setChannelName("\u4e2d\u536b\u4f70\u533b");
        cardQueryReq.setBody((Object)cardQueryBody);
        cardQueryReq.setOrganCode(organCode);
        cardQueryReq.setTransactionId(UUID.randomUUID().toString());
        GatewayResponse hisReturn = new GatewayResponse();
        if (AppCodeEnum.NCEFYENUM.getCode().equals(appCode)) {
            FrontRequest frontRequest = new FrontRequest();
            QueryCardReqVo queryCardReqVo = new QueryCardReqVo();
            BeanUtils.copyProperties((Object)cardQueryBody, (Object)queryCardReqVo);
            frontRequest.setBody((Object)queryCardReqVo);
            frontRequest.setOrganCode(organCode);
            frontRequest.setChannel("byh-card");
            frontRequest.setChannelName("\u4e2d\u536b\u4f70\u533b");
            frontRequest.setTransactionId(UUID.randomUUID().toString());
            ResponseEntity responseEntity = this.NCEFYGetCardInfo(frontRequest);
            if (null == ((FrontResponse)responseEntity.getBody()).getBody()) {
                return hisReturn;
            }
            String result = JsonUtil.convertObject((Object)((FrontResponse)responseEntity.getBody()).getBody());
            NCEFYCardInfoResVo ncefyCardInfoResVo = (NCEFYCardInfoResVo)JsonUtil.convertObject((String)result, NCEFYCardInfoResVo.class);
            QueryCardInfoResVO queryCardInfoResVO = new QueryCardInfoResVO();
            BeanUtils.copyProperties((Object)ncefyCardInfoResVo, (Object)queryCardInfoResVO);
            GatewayResponse response = new GatewayResponse();
            response.setData((Object)queryCardInfoResVO);
            response.setCode(((FrontResponse)responseEntity.getBody()).getCode());
            response.setTransactionId(((FrontResponse)responseEntity.getBody()).getTransactionId());
            response.setErrCode(((FrontResponse)responseEntity.getBody()).getErrCode());
            response.setMsg(((FrontResponse)responseEntity.getBody()).getMessage());
            hisReturn = response;
        } else {
            hisReturn = this.hisServiceFeginClient.queryCardInfo(cardQueryReq);
            log.info("HIS\u67e5\u8be2\u5c31\u8bca\u5361\uff0c\u8bf7\u6c42\u53c2\u6570={},\u54cd\u5e94={}", (Object)JsonUtil.convertObject((Object)cardQueryReq), (Object)JsonUtil.convertObject((Object)hisReturn));
        }
        log.info("HIS\u67e5\u8be2\u5c31\u8bca\u5361\uff0c\u8bf7\u6c42\u53c2\u6570={},\u54cd\u5e94={}", (Object)JsonUtil.convertObject((Object)cardQueryReq), (Object)JsonUtil.convertObject((Object)hisReturn));
        return hisReturn;
    }

    private GatewayResponse<QueryCardInfoResVO> queryNewHisCardInfo(RegisterCardReqVO reqVO, CardEntity card) {
        RegisteredCardReqVO cardQueryBody = new RegisteredCardReqVO();
        cardQueryBody.setCardNo(card.getCardNo());
        cardQueryBody.setName(reqVO.getPatientName());
        cardQueryBody.setCredType("4");
        cardQueryBody.setCredNo(reqVO.getCredNo());
        cardQueryBody.setTelephone(reqVO.getTel());
        cardQueryBody.setAddress(reqVO.getDetailAddress());
        String genderStr = IdCardUtil.getGenderByIdCard((String)reqVO.getCredNo());
        cardQueryBody.setSex(genderStr);
        cardQueryBody.setCredNo(reqVO.getCredNo());
        String birthStr = IdCardUtil.getBirthByIdCard2((String)reqVO.getCredNo());
        FrontRequest cardQueryReq = new FrontRequest();
        cardQueryReq.setChannel("byh-card");
        cardQueryReq.setChannelName("\u4e2d\u536b\u4f70\u533b");
        cardQueryReq.setBody((Object)cardQueryBody);
        cardQueryReq.setOrganCode(reqVO.getOrganCode());
        cardQueryReq.setTransactionId(UUID.randomUUID().toString());
        GatewayResponse hisReturn = new GatewayResponse();
        ResponseEntity responseEntity = this.insertCardInfoBD(cardQueryReq);
        if (null == ((FrontResponse)responseEntity.getBody()).getBody()) {
            return hisReturn;
        }
        String result = JsonUtil.convertObject((Object)((FrontResponse)responseEntity.getBody()).getBody());
        com.ebaiyihui.his.pojo.vo.card.RegisteredCardResVO registeredCardResVO = (com.ebaiyihui.his.pojo.vo.card.RegisteredCardResVO)JsonUtil.convertObject((String)result, com.ebaiyihui.his.pojo.vo.card.RegisteredCardResVO.class);
        QueryCardInfoResVO queryCardInfoResVO = new QueryCardInfoResVO();
        queryCardInfoResVO.setCardNo(registeredCardResVO.getCardNo());
        queryCardInfoResVO.setCardType("01");
        queryCardInfoResVO.setSex(genderStr);
        queryCardInfoResVO.setName(reqVO.getPatientName());
        queryCardInfoResVO.setDob(birthStr);
        queryCardInfoResVO.setCredNo(reqVO.getCredNo());
        queryCardInfoResVO.setTelephone(reqVO.getTel());
        queryCardInfoResVO.setAddress(reqVO.getDetailAddress());
        queryCardInfoResVO.setPatientNo(registeredCardResVO.getCredNo());
        GatewayResponse response = new GatewayResponse();
        response.setData((Object)queryCardInfoResVO);
        response.setCode(((FrontResponse)responseEntity.getBody()).getCode());
        response.setTransactionId(((FrontResponse)responseEntity.getBody()).getTransactionId());
        response.setErrCode(((FrontResponse)responseEntity.getBody()).getErrCode());
        response.setMsg(((FrontResponse)responseEntity.getBody()).getMessage());
        hisReturn = response;
        log.info("HIS\u67e5\u8be2\u5c31\u8bca\u5361\uff0c\u8bf7\u6c42\u53c2\u6570={},\u54cd\u5e94={}", (Object)JsonUtil.convertObject((Object)cardQueryReq), (Object)JsonUtil.convertObject((Object)hisReturn));
        return hisReturn;
    }

    private GatewayResponse<com.ebaiyihui.his.pojo.vo.card.RegisteredCardResVO> hisRegisterCard(RegisterCardReqVO reqVO) {
        if (!IdCardUtil.validateIdCard18((String)reqVO.getCredNo())) {
            throw new CardRuntimeException(CardErrorEnum.PARAM_CHECK_FAILD, "\u60a8\u8f93\u5165\u7684\u8bc1\u4ef6\u53f7\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
        RegisteredCardReqVO registeredCardBody = new RegisteredCardReqVO();
        String birthStr = IdCardUtil.getBirthByIdCard2((String)reqVO.getCredNo());
        if (StringUtils.isEmpty((Object)birthStr)) {
            throw new CardRuntimeException(CardErrorEnum.PARAM_CHECK_FAILD, "\u60a8\u8f93\u5165\u7684\u8bc1\u4ef6\u53f7\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
        String genderStr = IdCardUtil.getGenderByIdCard((String)reqVO.getCredNo());
        if (StringUtils.isEmpty((Object)genderStr)) {
            throw new CardRuntimeException(CardErrorEnum.PARAM_CHECK_FAILD, "\u60a8\u8f93\u5165\u7684\u8bc1\u4ef6\u53f7\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
        registeredCardBody.setAddress(reqVO.getProvinceName() + reqVO.getCityName() + reqVO.getCityAreaName() + reqVO.getDetailAddress());
        if (MZJH.equalsIgnoreCase(reqVO.getAppCode()) || YYHT.equalsIgnoreCase(reqVO.getAppCode())) {
            registeredCardBody.setCardNo(String.valueOf(System.currentTimeMillis()).substring(2));
        } else {
            registeredCardBody.setCardNo(reqVO.getCredNo());
        }
        registeredCardBody.setCardType(reqVO.getCardTypeCode());
        registeredCardBody.setCredNo(reqVO.getCredNo());
        registeredCardBody.setCredType(reqVO.getCredTypeCode());
        registeredCardBody.setDob(birthStr);
        registeredCardBody.setName(reqVO.getPatientName());
        registeredCardBody.setNation(reqVO.getNationCode());
        registeredCardBody.setOccupation(reqVO.getOccupationCode());
        registeredCardBody.setRegisterType(reqVO.getCredTypeCode());
        registeredCardBody.setSex(genderStr);
        registeredCardBody.setTelephone(reqVO.getTel());
        GatewayResponse hisReturn = new GatewayResponse();
        if (AppCodeEnum.NCEFYENUM.getCode().equals(reqVO.getAppCode())) {
            FrontRequest frontRequest = new FrontRequest();
            frontRequest.setBody((Object)registeredCardBody);
            frontRequest.setOrganCode(reqVO.getOrganCode());
            frontRequest.setChannel("byh-card");
            frontRequest.setChannelName("\u4e2d\u536b\u4f70\u533b");
            frontRequest.setTransactionId(UUID.randomUUID().toString());
            ResponseEntity responseEntity = this.NCEFYRegisterCarInfo(frontRequest);
            if (((FrontResponse)responseEntity.getBody()).getCode().equals("0")) {
                hisReturn.setMsg(((FrontResponse)responseEntity.getBody()).getMessage());
                log.info("hisrReturn = {}", (Object)JSON.toJSONString((Object)hisReturn));
                return hisReturn;
            }
            String result = JsonUtil.convertObject((Object)((FrontResponse)responseEntity.getBody()).getBody());
            NCEFYCardInfoResVo ncefyCardInfoResVo = (NCEFYCardInfoResVo)JsonUtil.convertObject((String)result, NCEFYCardInfoResVo.class);
            GatewayResponse response = new GatewayResponse();
            com.ebaiyihui.his.pojo.vo.card.RegisteredCardResVO registeredCardResVO = new com.ebaiyihui.his.pojo.vo.card.RegisteredCardResVO();
            BeanUtils.copyProperties((Object)ncefyCardInfoResVo, (Object)registeredCardResVO);
            response.setData((Object)registeredCardResVO);
            response.setCode(((FrontResponse)responseEntity.getBody()).getCode());
            response.setTransactionId(((FrontResponse)responseEntity.getBody()).getTransactionId());
            response.setErrCode(((FrontResponse)responseEntity.getBody()).getErrCode());
            response.setMsg(((FrontResponse)responseEntity.getBody()).getMessage());
            hisReturn = response;
            log.info("\u5357\u5927\u4e8c\u9644\u9662\u6ce8\u518c\u5c31\u8bca\u5361\uff0c\u8bf7\u6c42\u53c2\u6570={},\u54cd\u5e94={}", (Object)JsonUtil.convertObject((Object)frontRequest), (Object)JsonUtil.convertObject((Object)hisReturn));
        } else {
            GatewayRequest registerCardReq = new GatewayRequest();
            registerCardReq.setOrganCode(reqVO.getOrganCode());
            registerCardReq.setBody((Object)registeredCardBody);
            registerCardReq.setChannel("byh-card");
            registerCardReq.setChannelName("\u4e2d\u536b\u4f70\u533b");
            registerCardReq.setTransactionId(UUID.randomUUID().toString());
            hisReturn = this.hisServiceFeginClient.registerCardInfo(registerCardReq);
            log.info("HIS\u65e0\u5361\u6ce8\u518c\uff0c\u8bf7\u6c42\u53c2\u6570={},\u54cd\u5e94={}", (Object)JsonUtil.convertObject((Object)registerCardReq), (Object)JsonUtil.convertObject((Object)hisReturn));
        }
        return hisReturn;
    }

    public BaseResponse<HytRegisterResVO> hytRegisterCard(RegisterCardReqVO reqVO) {
        log.info("\u822a\u5929\u6ce8\u518c\u5c31\u8bca\u5361\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqVO));
        HytRegisterCardReqVO hytRegisterCardReqVO = new HytRegisterCardReqVO();
        PersonInfoVO personInfoVO = this.getBirthdayAndGender(reqVO);
        hytRegisterCardReqVO.setBirthday(personInfoVO.getBirth());
        hytRegisterCardReqVO.setSex(SexEnum.getcodeEnumByValue((String)personInfoVO.getGender()));
        hytRegisterCardReqVO.setAdress(reqVO.getDetailAddress());
        hytRegisterCardReqVO.setCardNo(reqVO.getCredNo());
        hytRegisterCardReqVO.setIdCardNo(reqVO.getCredNo());
        hytRegisterCardReqVO.setName(reqVO.getPatientName());
        hytRegisterCardReqVO.setPhone(reqVO.getTel());
        hytRegisterCardReqVO.setIdCardType(reqVO.getCredTypeCode());
        hytRegisterCardReqVO.setCardType(reqVO.getCardTypeCode());
        FrontRequest frontRequest = new FrontRequest();
        frontRequest.setBody((Object)hytRegisterCardReqVO);
        frontRequest.setTransactionId(UUID.randomUUID().toString());
        frontRequest.setChannel(HYTCHANNEL);
        frontRequest.setChannelName(HYTCHANNELNAME);
        frontRequest.setOrganCode(reqVO.getOrganCode());
        log.info("\u822a\u533b\u901a\u5728\u7ebf\u5efa\u6863\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)frontRequest));
        ResponseEntity responseEntity = this.HytRegisterCardOnLine(frontRequest);
        log.info("\u822a\u533b\u901a\u5728\u7ebf\u5efa\u6863\u7ed3\u679c\u8fd4\u56de\uff1a{}", (Object)JSON.toJSONString((Object)responseEntity));
        if (((FrontResponse)responseEntity.getBody()).getCode().equals(HYTFAILCODE)) {
            return BaseResponse.error((String)((FrontResponse)responseEntity.getBody()).getMessage());
        }
        String result = JsonUtil.convertObject((Object)((FrontResponse)responseEntity.getBody()).getBody());
        HytRegisterResVO hytRegisterResVO = (HytRegisterResVO)JsonUtil.convertObject((String)result, HytRegisterResVO.class);
        log.info("\u5efa\u6863\u8fd4\u56de\u5b9e\u4f53\uff1a{}", (Object)JSON.toJSONString((Object)hytRegisterResVO));
        return BaseResponse.success((Object)hytRegisterResVO);
    }

    public BaseResponse<CardDetailsInfoRespVO> registerOrBindCardByPassport(RegisterCardReqVONew registerCardReqVO) {
        CardEntity card = new CardEntity();
        BeanUtils.copyProperties((Object)registerCardReqVO, (Object)card);
        card.setStatus(CardStatusEnums.NORMAL);
        if ("1702".equals(registerCardReqVO.getCardTypeCode())) {
            BaseResponse cardDetailsInfoRespVO = this.getAttendanceCardDetailsInfoNew(registerCardReqVO, card);
            if (cardDetailsInfoRespVO != null) {
                return cardDetailsInfoRespVO;
            }
        } else if ("1703".equals(registerCardReqVO.getCardTypeCode())) {
            BaseResponse cardDetailsInfoRespVO = this.getVirtualCardDetailNew(registerCardReqVO, card);
            if (cardDetailsInfoRespVO != null) {
                return cardDetailsInfoRespVO;
            }
        } else if ("1801".equals(registerCardReqVO.getCardTypeCode())) {
            BaseResponse cardDetailsInfoRespVO = this.getEhcCardDetailsInfoNew(registerCardReqVO, card);
            if (cardDetailsInfoRespVO != null) {
                return cardDetailsInfoRespVO;
            }
        } else {
            String msg = MessageUtils.get((String)CardErrorEnum.CARD_TYPE_NOT_EXIST.name());
            return BaseResponse.error((String)msg);
        }
        log.info("\u5f00\u59cb\u4fdd\u5b58\u60a3\u8005\u4fe1\u606f\uff1a==============================");
        return this.saveCardNew(card, registerCardReqVO.getAppCode(), registerCardReqVO.getChannelCode(), registerCardReqVO);
    }

    private BaseResponse<CardDetailsInfoRespVO> saveCardNew(CardEntity card, String appCode, String channelCode, RegisterCardReqVONew registerCardReqVO) {
        SavePatientInfoReqVo savePatientReq = this.getSavePatientInfoReqVoNew(card, appCode, channelCode, registerCardReqVO.getGender(), registerCardReqVO.getBirthStr());
        BaseResponse savePatientResp = this.iPatienInfoService.savePatientInfo(savePatientReq);
        log.info("\u8bf7\u6c42\u60a3\u8005\u670d\u52a1\u83b7\u53d6\u60a3\u8005\u4fe1\u606f,\u8bf7\u6c42={},\u54cd\u5e94={}", (Object)JsonUtil.convertObject((Object)savePatientReq), (Object)JsonUtil.convertObject((Object)savePatientResp));
        if (savePatientResp.isSuccess()) {
            BasePatientRespVO patientInfo = (BasePatientRespVO)savePatientResp.getData();
            card.setPatientId(patientInfo.getPatientId());
            card.setCardId(String.valueOf(this.uniqueID.nextId()));
            card.setBirth(registerCardReqVO.getBirthStr());
            this.cardRepository.save((Object)card);
            log.info("\u5c31\u8bca\u5361\u4fdd\u5b58\u6210\u529f,,\u5c31\u8bca\u5361\u4fe1\u606f={}", (Object)JsonUtil.convertObject((Object)card));
            CardDetailsInfoRespVO cardDetailsInfoRespVO = this.buildCardDetailsInfoNew(card);
            return BaseResponse.success((Object)cardDetailsInfoRespVO);
        }
        return BaseResponse.error((IError)IError.FEIGN_FAIL, (String)savePatientResp.getMsg());
    }

    private SavePatientInfoReqVo getSavePatientInfoReqVoNew(CardEntity card, String appCode, String channelCode, Short gender, String birthStr) {
        SavePatientInfoReqVo savePatientReq = new SavePatientInfoReqVo();
        savePatientReq.setAppCode(appCode);
        savePatientReq.setChannelCode(channelCode);
        savePatientReq.setName(card.getPatientName());
        savePatientReq.setCredNo(card.getCredNo());
        savePatientReq.setCredTypeCode(card.getCredTypeCode());
        savePatientReq.setContactMobile(card.getTel());
        savePatientReq.setProvinceCode(card.getProvinceCode());
        savePatientReq.setCityCode(card.getCityCode());
        savePatientReq.setCityAreaCode(card.getCityAreaCode());
        savePatientReq.setHospitalId(card.getOrganCode());
        Date dob = null;
        try {
            dob = DateUtils.formatDate((String)birthStr);
        }
        catch (ParseException e) {
            log.error("\u60a3\u8005\u51fa\u751f\u65e5\u671f\u89e3\u6790\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException("\u60a3\u8005\u51fa\u751f\u65e5\u671f\u89e3\u6790\u5f02\u5e38");
        }
        savePatientReq.setBirthdate(dob);
        card.setGender(gender);
        return savePatientReq;
    }

    private BaseResponse<CardDetailsInfoRespVO> getEhcCardDetailsInfoNew(RegisterCardReqVONew registerCardReqVO, CardEntity card) {
        Map stringObjectMap = this.ehcQueryCard(registerCardReqVO.getCredNo());
        String ehealth_card_id = stringObjectMap.get("ehealth_card_id") + "";
        if (!StringUtils.isEmpty((Object)ehealth_card_id)) {
            card.setCardNo(ehealth_card_id);
            BaseResponse cardDetails = this.getCardDetailsNew(card);
            if (cardDetails != null) {
                return cardDetails;
            }
        } else {
            Map stringObjectMap1 = this.ehcRegisterCardNew(registerCardReqVO.getCredNo(), registerCardReqVO.getPatientName(), registerCardReqVO.getNationCode(), registerCardReqVO.getTel());
            String ehealth_card_id1 = stringObjectMap1.get("ehealth_card_id") + "";
            if (StringUtils.isEmpty((Object)ehealth_card_id1)) {
                return BaseResponse.error((String)CardErrorEnum.HIS_REGISTER_CARD_WRONG.getMsg());
            }
            card.setCardNo(ehealth_card_id1);
        }
        return null;
    }

    private Map<String, Object> ehcRegisterCardNew(String credNo, String patientName, String nationCode, String tel) {
        EhcRegisterCardVO ehcRegisterCardVO = new EhcRegisterCardVO();
        ehcRegisterCardVO.setRegister_no(UUID.randomUUID().toString().replace("-", ""));
        String dateStr2 = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
        ehcRegisterCardVO.setRegister_time(dateStr2);
        ehcRegisterCardVO.setApply_type(CommonEnums.ApplyTypeEnum.app.getValue() + "");
        ehcRegisterCardVO.setId_type(ID_CARD_CODE);
        ehcRegisterCardVO.setId_no(credNo);
        ehcRegisterCardVO.setName(patientName);
        String genderStr = IdCardUtil.getGenderByIdCard((String)credNo);
        if (!StringUtils.isEmpty((Object)genderStr)) {
            if ("M".equals(genderStr)) {
                ehcRegisterCardVO.setGender(CommonEnums.GenderTypeEnum.MALE.getValue() + "");
            } else {
                ehcRegisterCardVO.setGender(CommonEnums.GenderTypeEnum.FEMALE.getValue() + "");
            }
        }
        ehcRegisterCardVO.setQrcode_type(CommonEnums.QrcodeTypeEnum.DYNAMIC.getValue() + "");
        ehcRegisterCardVO.setNation(nationCode);
        ehcRegisterCardVO.setCellphone(tel);
        String s = JSONObject.toJSONString((Object)ehcRegisterCardVO);
        log.info("\u7535\u5b50\u5065\u5eb7\u5361\u6ce8\u518c\uff0c\u8bf7\u6c42\u5165\u53c2\uff1a{}", (Object)s);
        String ehcReturn = EhcmsUtil.sendMsg((String)this.appId, (String)this.termID, (String)EhcConstants.EHC_EHEALTHCARD_REGISTER, (String)s);
        log.info("\u7535\u5b50\u5065\u5eb7\u5361\u6ce8\u518c\uff0c\u8bf7\u6c42\u54cd\u5e94\uff1a{}", (Object)ehcReturn);
        JSONObject jsonToMap = JSONObject.parseObject((String)ehcReturn);
        return jsonToMap;
    }

    private BaseResponse<CardDetailsInfoRespVO> getVirtualCardDetailNew(RegisterCardReqVONew registerCardReqVO, CardEntity card) {
        card.setCardNo(registerCardReqVO.getCredNo());
        card.setOrganPmi(null);
        return this.getCardDetailsNew(card);
    }

    private BaseResponse<CardDetailsInfoRespVO> getAttendanceCardDetailsInfoNew(RegisterCardReqVONew registerCardReqVO, CardEntity card) {
        GatewayResponse hisCardInfoResp = this.queryHisCardInfo(registerCardReqVO.getAppCode(), registerCardReqVO.getOrganCode(), null, registerCardReqVO.getCredNo(), registerCardReqVO.getCardTypeCode(), registerCardReqVO.getCredTypeCode(), registerCardReqVO.getPatientName());
        if (hisCardInfoResp.isSuccess() && hisCardInfoResp.getData() != null) {
            BaseResponse cardDetailsInfoRespVO = this.getAttendanceCardDetailsInfoRespVONew(registerCardReqVO, card, hisCardInfoResp);
            if (cardDetailsInfoRespVO != null) {
                return cardDetailsInfoRespVO;
            }
        } else {
            GatewayResponse hisRegisterResp = this.hisRegisterCardNew(registerCardReqVO);
            log.info("\u5c31\u8bca\u5361\u6ce8\u518c\u8fd4\u56de\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)hisCardInfoResp));
            if (!hisRegisterResp.isSuccess() || null == hisRegisterResp.getData()) {
                String msg = MessageUtils.get((String)CardErrorEnum.HIS_REGISTER_CARD_WRONG.name());
                return BaseResponse.error((String)msg);
            }
            card.setCardNo(((com.ebaiyihui.his.pojo.vo.card.RegisteredCardResVO)hisRegisterResp.getData()).getCardNo());
            card.setOrganPmi(((com.ebaiyihui.his.pojo.vo.card.RegisteredCardResVO)hisRegisterResp.getData()).getPatientId());
        }
        return null;
    }

    private GatewayResponse<com.ebaiyihui.his.pojo.vo.card.RegisteredCardResVO> hisRegisterCardNew(RegisterCardReqVONew registerCardReqVO) {
        RegisteredCardReqVO registeredCardBody = new RegisteredCardReqVO();
        registeredCardBody.setAddress(registerCardReqVO.getProvinceName() + registerCardReqVO.getCityName() + registerCardReqVO.getCityAreaName() + registerCardReqVO.getDetailAddress());
        if (MZJH.equalsIgnoreCase(registerCardReqVO.getAppCode()) || YYHT.equalsIgnoreCase(registerCardReqVO.getAppCode())) {
            registeredCardBody.setCardNo(String.valueOf(System.currentTimeMillis()).substring(2));
        } else {
            registeredCardBody.setCardNo(registerCardReqVO.getCredNo());
        }
        registeredCardBody.setCardType(registerCardReqVO.getCardTypeCode());
        registeredCardBody.setCredNo(registerCardReqVO.getCredNo());
        registeredCardBody.setCredType(registerCardReqVO.getCredTypeCode());
        String birthStr = registerCardReqVO.getBirthStr();
        registeredCardBody.setDob(birthStr);
        registeredCardBody.setName(registerCardReqVO.getPatientName());
        registeredCardBody.setNation(registerCardReqVO.getNationCode());
        registeredCardBody.setOccupation(registerCardReqVO.getOccupationCode());
        registeredCardBody.setRegisterType(registerCardReqVO.getCredTypeCode());
        Short gender = registerCardReqVO.getGender();
        if (gender.equals((short)1)) {
            registeredCardBody.setSex("M");
        } else if (gender.equals((short)2)) {
            registeredCardBody.setSex("F");
        }
        registeredCardBody.setTelephone(registerCardReqVO.getTel());
        GatewayResponse hisReturn = new GatewayResponse();
        if (AppCodeEnum.NCEFYENUM.getCode().equals(registerCardReqVO.getAppCode())) {
            FrontRequest frontRequest = new FrontRequest();
            frontRequest.setBody((Object)registeredCardBody);
            frontRequest.setOrganCode(registerCardReqVO.getOrganCode());
            frontRequest.setChannel("byh-card");
            frontRequest.setChannelName("\u4e2d\u536b\u4f70\u533b");
            frontRequest.setTransactionId(UUID.randomUUID().toString());
            ResponseEntity responseEntity = this.NCEFYRegisterCarInfo(frontRequest);
            if (((FrontResponse)responseEntity.getBody()).getCode().equals("0")) {
                hisReturn.setMsg(((FrontResponse)responseEntity.getBody()).getMessage());
                log.info("hisrReturn = {}", (Object)JSON.toJSONString((Object)hisReturn));
                return hisReturn;
            }
            String result = JsonUtil.convertObject((Object)((FrontResponse)responseEntity.getBody()).getBody());
            NCEFYCardInfoResVo ncefyCardInfoResVo = (NCEFYCardInfoResVo)JsonUtil.convertObject((String)result, NCEFYCardInfoResVo.class);
            GatewayResponse response = new GatewayResponse();
            com.ebaiyihui.his.pojo.vo.card.RegisteredCardResVO registeredCardResVO = new com.ebaiyihui.his.pojo.vo.card.RegisteredCardResVO();
            BeanUtils.copyProperties((Object)ncefyCardInfoResVo, (Object)registeredCardResVO);
            response.setData((Object)registeredCardResVO);
            response.setCode(((FrontResponse)responseEntity.getBody()).getCode());
            response.setTransactionId(((FrontResponse)responseEntity.getBody()).getTransactionId());
            response.setErrCode(((FrontResponse)responseEntity.getBody()).getErrCode());
            response.setMsg(((FrontResponse)responseEntity.getBody()).getMessage());
            hisReturn = response;
            log.info("\u5357\u5927\u4e8c\u9644\u9662\u6ce8\u518c\u5c31\u8bca\u5361\uff0c\u8bf7\u6c42\u53c2\u6570={},\u54cd\u5e94={}", (Object)JsonUtil.convertObject((Object)frontRequest), (Object)JsonUtil.convertObject((Object)hisReturn));
        } else {
            GatewayRequest registerCardReq = new GatewayRequest();
            registerCardReq.setOrganCode(registerCardReqVO.getOrganCode());
            registerCardReq.setBody((Object)registeredCardBody);
            registerCardReq.setChannel("byh-card");
            registerCardReq.setChannelName("\u4e2d\u536b\u4f70\u533b");
            registerCardReq.setTransactionId(UUID.randomUUID().toString());
            hisReturn = this.hisServiceFeginClient.registerCardInfo(registerCardReq);
            log.info("HIS\u65e0\u5361\u6ce8\u518c\uff0c\u8bf7\u6c42\u53c2\u6570={},\u54cd\u5e94={}", (Object)JsonUtil.convertObject((Object)registerCardReq), (Object)JsonUtil.convertObject((Object)hisReturn));
        }
        return hisReturn;
    }

    private BaseResponse<CardDetailsInfoRespVO> getAttendanceCardDetailsInfoRespVONew(RegisterCardReqVONew registerCardReqVO, CardEntity card, GatewayResponse<QueryCardInfoResVO> hisCardInfoResp) {
        this.checkHisCardInfoAndBindCardInfoNew((QueryCardInfoResVO)hisCardInfoResp.getData(), registerCardReqVO);
        card.setCardNo(((QueryCardInfoResVO)hisCardInfoResp.getData()).getCardNo());
        card.setOrganPmi(((QueryCardInfoResVO)hisCardInfoResp.getData()).getPatientId());
        card.setHisAddress(((QueryCardInfoResVO)hisCardInfoResp.getData()).getAddress());
        return this.getCardDetailsNew(card);
    }

    private Boolean checkHisCardInfoAndBindCardInfoNew(QueryCardInfoResVO hisCardInfo, RegisterCardReqVONew bindCardInfo) {
        if (!hisCardInfo.getName().equals(bindCardInfo.getPatientName())) {
            throw new CardRuntimeException(CardErrorEnum.BIND_CARD_PATIENT_NAME_WRONG);
        }
        return Boolean.TRUE;
    }

    private BaseResponse<CardDetailsInfoRespVO> getCardDetailsNew(CardEntity card) {
        Optional cardOp = this.cardRepository.findOneByCardNoAndOrganCode(card.getCardNo(), card.getOrganCode());
        if (cardOp.isPresent()) {
            CardEntity cardEntity = (CardEntity)cardOp.get();
            cardEntity.setTel(card.getTel());
            this.cardRepository.save((Object)cardEntity);
            CardDetailsInfoRespVO cardDetailsInfoRespVO = this.buildCardDetailsInfoNew(cardEntity);
            return BaseResponse.success((Object)cardDetailsInfoRespVO);
        }
        return null;
    }

    private CardDetailsInfoRespVO buildCardDetailsInfoNew(CardEntity card) {
        CardDetailsInfoRespVO cardDetailsInfoRespVO = new CardDetailsInfoRespVO();
        BeanUtils.copyProperties((Object)card, (Object)cardDetailsInfoRespVO);
        cardDetailsInfoRespVO.setCardStatus(Short.valueOf((short)card.getStatus().ordinal()));
        cardDetailsInfoRespVO.setCardStatusDesc(card.getStatus().getDesc());
        return cardDetailsInfoRespVO;
    }

    private PersonInfoVO getBirthdayAndGender(RegisterCardReqVO registeredCardReqVO) {
        log.info("\u83b7\u53d6\u51fa\u751f\u65e5\u671f\u548c\u6027\u522b\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)registeredCardReqVO));
        PersonInfoVO personInfoVO = new PersonInfoVO();
        if (!IdCardUtil.validateIdCard18((String)registeredCardReqVO.getCredNo())) {
            throw new CardRuntimeException(CardErrorEnum.PARAM_CHECK_FAILD, "\u60a8\u8f93\u5165\u7684\u8bc1\u4ef6\u53f7\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
        String birthStr = IdCardUtil.getBirthByIdCard2((String)registeredCardReqVO.getCredNo());
        if (StringUtils.isEmpty((Object)birthStr)) {
            throw new CardRuntimeException(CardErrorEnum.PARAM_CHECK_FAILD, "\u60a8\u8f93\u5165\u7684\u8bc1\u4ef6\u53f7\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
        personInfoVO.setBirth(birthStr);
        String genderStr = IdCardUtil.getGenderByIdCard((String)registeredCardReqVO.getCredNo());
        if (StringUtils.isEmpty((Object)genderStr)) {
            throw new CardRuntimeException(CardErrorEnum.PARAM_CHECK_FAILD, "\u60a8\u8f93\u5165\u7684\u8bc1\u4ef6\u53f7\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
        personInfoVO.setGender(genderStr);
        log.info("\u822a\u5929\u83b7\u53d6\u51fa\u751f\u65e5\u671f\u548c\u6027\u522b\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)personInfoVO));
        return personInfoVO;
    }

    private BaseResponse<CardDetailsInfoRespVO> getEhcCardDetailsInfo(RegisterCardReqVO reqVO, CardEntity card) {
        Map stringObjectMap = this.ehcQueryCard(reqVO.getCredNo());
        String ehealth_card_id = stringObjectMap.get("ehealth_card_id") + "";
        if (!StringUtils.isEmpty((Object)ehealth_card_id)) {
            card.setCardNo(ehealth_card_id);
            BaseResponse cardDetails = this.getCardDetails(card);
            if (cardDetails != null) {
                return cardDetails;
            }
        } else {
            Map stringObjectMap1 = this.ehcRegisterCard(reqVO.getCredNo(), reqVO.getPatientName(), reqVO.getNationCode(), reqVO.getTel());
            String ehealth_card_id1 = stringObjectMap1.get("ehealth_card_id") + "";
            if (StringUtils.isEmpty((Object)ehealth_card_id1)) {
                return BaseResponse.error((String)CardErrorEnum.HIS_REGISTER_CARD_WRONG.getMsg());
            }
            card.setCardNo(ehealth_card_id1);
        }
        return null;
    }

    private Map<String, Object> ehcRegisterCard(String credNo, String name, String nation, String cellPhone) {
        EhcRegisterCardVO ehcRegisterCardVO = new EhcRegisterCardVO();
        ehcRegisterCardVO.setRegister_no(UUID.randomUUID().toString().replace("-", ""));
        String dateStr2 = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
        ehcRegisterCardVO.setRegister_time(dateStr2);
        ehcRegisterCardVO.setApply_type(CommonEnums.ApplyTypeEnum.app.getValue() + "");
        ehcRegisterCardVO.setId_type(ID_CARD_CODE);
        ehcRegisterCardVO.setId_no(credNo);
        ehcRegisterCardVO.setName(name);
        String genderStr = IdCardUtil.getGenderByIdCard((String)credNo);
        if (!StringUtils.isEmpty((Object)genderStr)) {
            if ("M".equals(genderStr)) {
                ehcRegisterCardVO.setGender(CommonEnums.GenderTypeEnum.MALE.getValue() + "");
            } else {
                ehcRegisterCardVO.setGender(CommonEnums.GenderTypeEnum.FEMALE.getValue() + "");
            }
        }
        ehcRegisterCardVO.setQrcode_type(CommonEnums.QrcodeTypeEnum.DYNAMIC.getValue() + "");
        ehcRegisterCardVO.setNation(nation);
        ehcRegisterCardVO.setCellphone(cellPhone);
        String s = JSONObject.toJSONString((Object)ehcRegisterCardVO);
        log.info("\u7535\u5b50\u5065\u5eb7\u5361\u6ce8\u518c\uff0c\u8bf7\u6c42\u5165\u53c2\uff1a{}", (Object)s);
        String ehcReturn = EhcmsUtil.sendMsg((String)this.appId, (String)this.termID, (String)EhcConstants.EHC_EHEALTHCARD_REGISTER, (String)s);
        log.info("\u7535\u5b50\u5065\u5eb7\u5361\u6ce8\u518c\uff0c\u8bf7\u6c42\u54cd\u5e94\uff1a{}", (Object)ehcReturn);
        JSONObject jsonToMap = JSONObject.parseObject((String)ehcReturn);
        return jsonToMap;
    }

    private Map<String, Object> ehcQueryCard(String credNo) {
        EhcFindCardVO ehcFindCard = new EhcFindCardVO();
        ehcFindCard.setId_no(credNo);
        ehcFindCard.setId_type(ID_CARD_CODE);
        String s = JSONObject.toJSONString((Object)ehcFindCard);
        log.info("\u7535\u5b50\u5065\u5eb7\u5361\u67e5\u8be2\uff0c\u8bf7\u6c42\u5165\u53c2\uff1a{}", (Object)s);
        String ehcReturn = EhcmsUtil.sendMsg((String)this.appId, (String)this.termID, (String)EhcConstants.EHC_EHEALTHCARD_QUERY, (String)s);
        log.info("\u7535\u5b50\u5065\u5eb7\u5361\u67e5\u8be2\uff0c\u8bf7\u6c42\u54cd\u5e94\uff1a{}", (Object)ehcReturn);
        JSONObject jsonToMap = JSONObject.parseObject((String)ehcReturn);
        return jsonToMap;
    }

    public BaseResponse<?> ehcRegister() {
        EhcRegisterCardVO ehcRegisterCardVO = new EhcRegisterCardVO();
        ehcRegisterCardVO.setRegister_no(UUID.randomUUID().toString().replace("-", ""));
        String dateStr2 = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
        ehcRegisterCardVO.setRegister_time(dateStr2);
        ehcRegisterCardVO.setApply_type(SUCCESS_FLAG);
        ehcRegisterCardVO.setId_type("01");
        ehcRegisterCardVO.setId_no("610522199607162015");
        ehcRegisterCardVO.setName("\u6731\u5c0f\u78ca");
        ehcRegisterCardVO.setGender(SUCCESS_FLAG);
        ehcRegisterCardVO.setQrcode_type("0");
        ehcRegisterCardVO.setNation("01");
        ehcRegisterCardVO.setCellphone("17621472127");
        String s = JSONObject.toJSONString((Object)ehcRegisterCardVO);
        System.out.println(s);
        String s1 = EhcmsUtil.sendMsg((String)this.appId, (String)this.termID, (String)EhcConstants.EHC_EHEALTHCARD_REGISTER, (String)s);
        System.out.println(s1);
        return null;
    }

    public BaseResponse<?> saveOrEdit(List<CardDetailsInfoRespVO> reqVO) {
        for (CardDetailsInfoRespVO cardDetailsInfoRespVO : reqVO) {
            Optional cardOp = this.cardRepository.findByCardId(cardDetailsInfoRespVO.getCardId());
            if (cardOp.isPresent()) {
                CardEntity cardEntityOld = (CardEntity)cardOp.get();
                cardEntityOld.setTel(cardDetailsInfoRespVO.getTel());
                log.info("update cardInfo=" + JSONObject.toJSONString((Object)cardEntityOld));
                this.cardRepository.save((Object)cardEntityOld);
                continue;
            }
            CardEntity cardEntity = new CardEntity();
            BeanUtils.copyProperties((Object)cardDetailsInfoRespVO, (Object)cardEntity);
            cardEntity.setStatus(CardStatusEnums.NORMAL);
            log.info("save cardInfo =" + JSONObject.toJSONString((Object)cardEntity));
            this.cardRepository.save((Object)cardEntity);
        }
        return BaseResponse.success();
    }

    @Transactional
    public BaseResponse<List<CardDetailsInfoRespVO>> hybindListCard(RegisterCardReqVO reqVO) {
        boolean b;
        log.info("\u822a\u5929\u4e2d\u5fc3\u533b\u9662\u5361\u670d\u52a1\u5165\u53c2\uff1a{}", (Object)JsonUtil.convertObject((Object)reqVO));
        if (!IdCardUtil.validateIdCard18((String)reqVO.getCredNo())) {
            log.warn("\u8eab\u4efd\u8bc1\u9a8c\u8bc1\u5931\u8d25[{}],\u5361\u4fe1\u606f[{}]", (Object)JsonUtil.convertObject((Object)reqVO), (Object)reqVO.getCredNo());
            throw new CardRuntimeException(CardErrorEnum.PARAM_CHECK_FAILD, "\u60a8\u8f93\u5165\u7684\u8bc1\u4ef6\u53f7\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
        String genderStr = "";
        String birthStr = IdCardUtil.getBirthByIdCard2((String)reqVO.getCredNo());
        String genderByIdCard = IdCardUtil.getGenderByIdCard((String)reqVO.getCredNo());
        if ("M".equals(genderByIdCard)) {
            genderStr = "\u7537";
            reqVO.setGender(Short.valueOf(CommonEnums.GenderTypeEnum.MALE.getValue().shortValue()));
        } else if ("F".equals(genderByIdCard)) {
            genderStr = "\u5973";
            reqVO.setGender(Short.valueOf(CommonEnums.GenderTypeEnum.FEMALE.getValue().shortValue()));
        } else {
            reqVO.setGender(Short.valueOf(CommonEnums.GenderTypeEnum.UNKNOWNGENDER.getValue().shortValue()));
        }
        HYCardVerificationResponse hyCardVerificationResponse = this.hyCheckCard(birthStr, reqVO.getCredNo(), reqVO.getCardNo(), reqVO.getCardTypeCode(), reqVO.getPatientName(), genderStr);
        boolean bl = b = null == hyCardVerificationResponse || !SUCCESS_FLAG.equals(hyCardVerificationResponse.getResult()) && !"-2".equals(hyCardVerificationResponse.getResult());
        if (b) {
            return BaseResponse.error((String)"\u672a\u67e5\u8be2\u5230\u5361\u4fe1\u606f\u6216\u6821\u9a8c\u5931\u8d25");
        }
        ArrayList list = new ArrayList();
        List hyCardInfoResVos = this.hyGetCardMsg(reqVO, birthStr, genderStr, hyCardVerificationResponse.getFundType());
        if (null != hyCardInfoResVos && hyCardInfoResVos.size() > 0) {
            CardEntity card = new CardEntity();
            BeanUtils.copyProperties((Object)reqVO, (Object)card);
            String patientId = this.getPatientId(reqVO, card);
            for (HYCardInfoResVo hyCardInfoResVo : hyCardInfoResVos) {
                this.checkHyCardMsg(hyCardInfoResVo, reqVO);
                String cardNO = hyCardInfoResVo.getCardNO();
                String address = hyCardInfoResVo.getAddress();
                String cardTypeCode = reqVO.getCardTypeCode();
                this.hyInitCard(reqVO, list, patientId, cardNO, cardTypeCode, address);
            }
        } else {
            return BaseResponse.error((String)"\u672a\u67e5\u8be2\u5230\u5361\u4fe1\u606f\u6216\u6821\u9a8c\u5931\u8d25");
        }
        return BaseResponse.success(list);
    }

    public BaseResponse<List<CardDetailsInfoRespVO>> hyNewbindListCard(RegisterCardReqVO reqVO) {
        log.info("\u65b0\u822a\u5929\u4e2d\u5fc3\u533b\u9662\u5361\u670d\u52a1\u5165\u53c2\uff1a{}", (Object)JsonUtil.convertObject((Object)reqVO));
        if (!IdCardUtil.validateIdCard18((String)reqVO.getCredNo())) {
            log.warn("\u65b0\u8eab\u4efd\u8bc1\u9a8c\u8bc1\u5931\u8d25[{}],\u5361\u4fe1\u606f[{}]", (Object)JsonUtil.convertObject((Object)reqVO), (Object)reqVO.getCredNo());
            throw new CardRuntimeException(CardErrorEnum.PARAM_CHECK_FAILD, "\u60a8\u8f93\u5165\u7684\u8bc1\u4ef6\u53f7\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
        String genderStr = "";
        String birthStr = IdCardUtil.getBirthByIdCard2((String)reqVO.getCredNo());
        String genderByIdCard = IdCardUtil.getGenderByIdCard((String)reqVO.getCredNo());
        if ("M".equals(genderByIdCard)) {
            genderStr = "\u7537";
            reqVO.setGender(Short.valueOf(CommonEnums.GenderTypeEnum.MALE.getValue().shortValue()));
        } else if ("F".equals(genderByIdCard)) {
            genderStr = "\u5973";
            reqVO.setGender(Short.valueOf(CommonEnums.GenderTypeEnum.FEMALE.getValue().shortValue()));
        } else {
            reqVO.setGender(Short.valueOf(CommonEnums.GenderTypeEnum.UNKNOWNGENDER.getValue().shortValue()));
        }
        ArrayList<CardDetailsInfoRespVO> list = new ArrayList<CardDetailsInfoRespVO>();
        ResponseEntity response = this.getInfo(reqVO, birthStr, genderStr);
        if (Objects.isNull(response) || !SUCCESS_FLAG.equals(((FrontResponse)response.getBody()).getCode())) {
            return BaseResponse.error((String)"\u6dfb\u52a0\u5c31\u8bca\u5361\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        String result = JsonUtil.convertObject((Object)((FrontResponse)response.getBody()).getBody());
        HYCardInfoResVo hyCardInfoResVo = (HYCardInfoResVo)JsonUtil.convertObject((String)result, HYCardInfoResVo.class);
        log.info("newhyCardInfoResVo:{}", (Object)JsonUtil.convertObject((Object)hyCardInfoResVo));
        if (Objects.isNull(hyCardInfoResVo)) {
            return BaseResponse.error((String)"\u6dfb\u52a0\u5c31\u8bca\u5361\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        log.info("findByCardNoAndCardTypeAndOrganCode:{}-----{}", (Object)reqVO.getCredNo(), (Object)reqVO.getOrganCode());
        String markType = hyCardInfoResVo.getMarkType();
        CardEntity cardEntity = this.cardRepository.findByCardNoAndCardTypeAndOrganCode(hyCardInfoResVo.getIdNO(), reqVO.getOrganCode(), markType);
        String cardNO = hyCardInfoResVo.getCardNO();
        String markNo = hyCardInfoResVo.getMarkNo();
        log.info("newcardEntity:{}", (Object)JsonUtil.convertObject((Object)cardEntity));
        log.info("newmarkType:{}", (Object)markType);
        if (Objects.isNull(cardEntity)) {
            log.info("cardEntityboolean:{}", (Object)Objects.isNull(cardEntity));
            cardEntity = new CardEntity();
            BeanUtils.copyProperties((Object)reqVO, (Object)cardEntity);
            cardEntity.setStatus(CardStatusEnums.NORMAL);
            if ("0".equals(markType)) {
                cardEntity.setCardTypeName("\u95e8\u8bca\u5361");
                cardEntity.setCardNo(cardNO);
                cardEntity.setCardTypeCode("0");
            } else if ("3".equals(markType)) {
                cardEntity.setCardTypeName("\u533b\u4fdd\u5361");
                cardEntity.setCardNo(markNo);
                cardEntity.setCardTypeCode("3");
            }
            cardEntity.setOrganPmi(cardNO);
            cardEntity.setBirth(hyCardInfoResVo.getBirthDay());
            log.info("hyNewbindListCardcardEntity{}", (Object)JsonUtil.convertObject((Object)cardEntity));
            this.saveCard(cardEntity, reqVO.getAppCode(), reqVO.getChannelCode());
        } else {
            log.info("cardEntityboolean:{}", (Object)Objects.isNull(cardEntity));
            if ("0".equals(markType)) {
                cardEntity.setCardTypeName("\u95e8\u8bca\u5361");
                cardEntity.setCardNo(cardNO);
                cardEntity.setCardTypeCode("0");
            } else if ("3".equals(markType)) {
                cardEntity.setCardTypeCode("3");
                cardEntity.setCardTypeName("\u533b\u4fdd\u5361");
                cardEntity.setCardNo(markNo);
            }
            cardEntity.setPatientName(reqVO.getPatientName());
            cardEntity.setProvinceName(reqVO.getProvinceName());
            cardEntity.setCityAreaName(reqVO.getCityAreaName());
            cardEntity.setCityName(reqVO.getCityName());
            cardEntity.setDetailAddress(reqVO.getDetailAddress());
            cardEntity.setTel(reqVO.getTel());
            cardEntity.setBirth(hyCardInfoResVo.getBirthDay());
            cardEntity.setOrganPmi(cardNO);
            log.info("hyNewbindListCardcardEntity{}", (Object)JsonUtil.convertObject((Object)cardEntity));
            this.cardRepository.save((Object)cardEntity);
        }
        String patientId = this.getPatientId(reqVO, cardEntity);
        CardDetailsInfoRespVO cardDetailsInfoRespVO = CardDetailsInfoRespVO.builder().cardId(cardEntity.getCardId()).tel(reqVO.getTel()).provinceCode(reqVO.getProvinceCode()).provinceName(reqVO.getProvinceName()).cityCode(reqVO.getCityCode()).cityName(reqVO.getCityName()).cityAreaCode(reqVO.getCityAreaCode()).cityAreaName(reqVO.getCityAreaName()).detailAddress(reqVO.getDetailAddress()).nationName(reqVO.getNationName()).nationCode(reqVO.getNationCode()).occupationName(reqVO.getOccupationName()).occupationCode(reqVO.getOccupationCode()).cardNo(hyCardInfoResVo.getCardNO()).cardTypeCode(cardEntity.getCardTypeCode()).cardTypeName(cardEntity.getCardTypeName()).patientId(patientId).credNo(reqVO.getCredNo()).credTypeCode(reqVO.getCredTypeCode()).credTypeName(reqVO.getCredTypeName()).patientName(reqVO.getPatientName()).gender(reqVO.getGender()).organPmi(cardEntity.getOrganPmi()).organCode(reqVO.getOrganCode()).organName(reqVO.getOrganName()).birth(birthStr).build();
        list.add(cardDetailsInfoRespVO);
        log.info("newcardDetailsInfoRespVO{}", (Object)JsonUtil.convertObject((Object)cardDetailsInfoRespVO));
        return BaseResponse.success(list);
    }

    private Boolean checkHyCardMsg(HYCardInfoResVo hyCardInfoResVos, RegisterCardReqVO reqVO) {
        if (!reqVO.getCredNo().equals(hyCardInfoResVos.getIdNO())) {
            throw new CardRuntimeException(CardErrorEnum.BIND_CARD_CRED_WRONG);
        }
        if (!reqVO.getPatientName().equals(hyCardInfoResVos.getName())) {
            throw new CardRuntimeException(CardErrorEnum.BIND_CARD_PATIENT_NAME_WRONG);
        }
        return Boolean.TRUE;
    }

    private List<HYCardInfoResVo> hyGetCardMsg(RegisterCardReqVO reqVO, String birthStr, String genderStr, String fundType) {
        HYCardInfoReqVo hyCardInfoReqVo = new HYCardInfoReqVo();
        hyCardInfoReqVo.setBirthDay(birthStr);
        hyCardInfoReqVo.setHospFlag("0");
        hyCardInfoReqVo.setIdCard(reqVO.getCredNo());
        hyCardInfoReqVo.setMarkNO(reqVO.getCardNo());
        hyCardInfoReqVo.setMarkType(reqVO.getCardTypeCode());
        hyCardInfoReqVo.setFundType(fundType);
        hyCardInfoReqVo.setName(reqVO.getPatientName());
        hyCardInfoReqVo.setSex(genderStr);
        FrontRequest frontRequest = new FrontRequest();
        frontRequest.setBody((Object)hyCardInfoReqVo);
        String reqUrl = this.htzxBaseCloudUrl.concat("/hyt-his/api/v1/card/getCardInfo");
        log.info("\u822a\u5929\u4e2d\u5fc3\u533b\u9662\u8c03\u7528\u524d\u7f6e\u673a\u83b7\u53d6\u5361\u4fe1\u606furl:{},\u5165\u53c2\uff1a{}", (Object)reqUrl, (Object)JsonUtil.convertObject((Object)frontRequest));
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity response = restTemplate.postForEntity(reqUrl, (Object)frontRequest, FrontResponse.class, new Object[0]);
        log.info("\u822a\u5929\u4e2d\u5fc3\u533b\u9662\u8c03\u7528\u524d\u7f6e\u673a\u83b7\u53d6\u5361\u4fe1\u606f\u8fd4\u53c2\uff1a{}", (Object)JsonUtil.convertObject((Object)response.getBody()));
        String result = JsonUtil.convertObject((Object)((FrontResponse)response.getBody()).getBody());
        HYCardInfoResVo hyCardInfoResVo = (HYCardInfoResVo)JsonUtil.convertObject((String)result, HYCardInfoResVo.class);
        ArrayList<HYCardInfoResVo> list = new ArrayList<HYCardInfoResVo>();
        if (null != hyCardInfoResVo) {
            list.add(hyCardInfoResVo);
        }
        return list;
    }

    private ResponseEntity<FrontResponse> getInfo(RegisterCardReqVO reqVO, String birthStr, String genderStr) {
        QueryCardInfoReqVo hyCardInfoReqVo = new QueryCardInfoReqVo();
        hyCardInfoReqVo.setBirthday(birthStr);
        hyCardInfoReqVo.setHospFlag("0");
        hyCardInfoReqVo.setIdCard(reqVO.getCredNo());
        hyCardInfoReqVo.setMarkNO(reqVO.getCardNo());
        hyCardInfoReqVo.setMarkType(reqVO.getCardTypeCode());
        hyCardInfoReqVo.setName(reqVO.getPatientName());
        hyCardInfoReqVo.setSex(genderStr);
        hyCardInfoReqVo.setTelephone(reqVO.getTel());
        hyCardInfoReqVo.setDetailAddress(reqVO.getDetailAddress());
        hyCardInfoReqVo.setCredNo(reqVO.getCredNo());
        hyCardInfoReqVo.setCredTypeCode(reqVO.getCredTypeCode());
        hyCardInfoReqVo.setCardTypeCode(reqVO.getCardTypeCode());
        hyCardInfoReqVo.setPactCode(reqVO.getPactCode());
        hyCardInfoReqVo.setIdCard(reqVO.getCredNo());
        FrontRequest frontRequest = new FrontRequest();
        frontRequest.setBody((Object)hyCardInfoReqVo);
        String reqUrl = this.htzxBaseCloudUrl.concat("/hyt-his/api/v1/card/queryCardInfo");
        log.info("\u822a\u5929\u4e2d\u5fc3\u533b\u9662\u8c03\u7528\u524d\u7f6e\u673a\u83b7\u53d6\u5361\u4fe1\u606fgetInfourl:{},\u5165\u53c2\uff1a{}", (Object)reqUrl, (Object)JsonUtil.convertObject((Object)frontRequest));
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity response = restTemplate.postForEntity(reqUrl, (Object)frontRequest, FrontResponse.class, new Object[0]);
        log.info("\u822a\u5929\u4e2d\u5fc3\u533b\u9662\u8c03\u7528\u524d\u7f6e\u673a\u83b7\u53d6\u5361\u4fe1\u606fgetInfo\u8fd4\u53c2\uff1a{}", (Object)JsonUtil.convertObject((Object)response.getBody()));
        return response;
    }

    private HYCardVerificationResponse hyCheckCard(String birthday, String idCard, String MarkNo, String MarkType, String name, String sex) {
        HYCardVerificationRequest hyCardVerificationRequest = new HYCardVerificationRequest();
        hyCardVerificationRequest.setBirthday(birthday);
        hyCardVerificationRequest.setHospFlag("0");
        hyCardVerificationRequest.setIdCard(idCard);
        hyCardVerificationRequest.setMarkNO(MarkNo);
        hyCardVerificationRequest.setMarkType(MarkType);
        hyCardVerificationRequest.setName(name);
        hyCardVerificationRequest.setSex(sex);
        FrontRequest frontRequest = new FrontRequest();
        frontRequest.setBody((Object)hyCardVerificationRequest);
        String reqUrl = this.htzxBaseCloudUrl.concat("/hyt-his/api/v1/card/cardVerification");
        log.info("\u822a\u5929\u4e2d\u5fc3\u533b\u9662\u8c03\u7528\u524d\u7f6e\u673a\u6821\u9a8c\u5361\u4fe1\u606furl:{},\u5165\u53c2\uff1a{}", (Object)reqUrl, (Object)JsonUtil.convertObject((Object)frontRequest));
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity response = restTemplate.postForEntity(reqUrl, (Object)frontRequest, FrontResponse.class, new Object[0]);
        log.info("\u822a\u5929\u4e2d\u5fc3\u533b\u9662\u8c03\u7528\u524d\u7f6e\u673a\u6821\u9a8c\u5361\u4fe1\u606f\u8fd4\u53c2\uff1a{}", (Object)JsonUtil.convertObject((Object)response.getBody()));
        String result = JsonUtil.convertObject((Object)((FrontResponse)response.getBody()).getBody());
        HYCardVerificationResponse HYCardVerificationResponse2 = (HYCardVerificationResponse)JsonUtil.convertObject((String)result, HYCardVerificationResponse.class);
        return HYCardVerificationResponse2;
    }

    private void hyInitCard(RegisterCardReqVO reqVO, List<CardDetailsInfoRespVO> list, String patientId, String cardNO, String cardTypeCode, String address) {
        CardEntity card = new CardEntity();
        BeanUtils.copyProperties((Object)reqVO, (Object)card);
        card.setDetailAddress(address);
        card.setCardTypeCode(cardTypeCode);
        card.setRegisterResource("htzx");
        card.setGender(reqVO.getGender());
        card.setStatus(CardStatusEnums.NORMAL);
        if ("0".equals(cardTypeCode)) {
            card.setCardTypeName("\u95e8\u8bca\u5361");
            card.setCardNo(cardNO);
            card.setOrganPmi(cardNO);
        } else if ("3".equals(cardTypeCode)) {
            card.setCardTypeName("\u533b\u4fdd\u5361");
            card.setCardNo(reqVO.getCardNo());
            card.setOrganPmi(cardNO);
        }
        card.setPatientId(patientId);
        card.setCardId(String.valueOf(this.uniqueID.nextId()));
        BaseResponse cardDetails = this.getZrCardDetails(card);
        if (null == cardDetails) {
            CardDetailsInfoRespVO cardDetailsInfoRespVO = this.buildCardDetailsInfo(card);
            list.add(cardDetailsInfoRespVO);
        } else {
            list.add((CardDetailsInfoRespVO)cardDetails.getData());
        }
        log.info("card info ={}", (Object)JSONObject.toJSONString(list));
    }

    private ResponseEntity<FrontResponse> NCEFYGetCardInfo(FrontRequest<QueryCardReqVo> queryCardReqVo) {
        RestTemplate template = new RestTemplate();
        String url = this.ncefyBaseCloudUrl + "/card/query";
        ResponseEntity responseEntity = template.postForEntity(url, queryCardReqVo, FrontResponse.class, new Object[0]);
        log.info("\u5357\u5927\u4e8c\u9644\u9662\u8fd4\u56de\u7684\u5361\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)responseEntity));
        return responseEntity;
    }

    private ResponseEntity<FrontResponse> insertCardInfoBD(FrontRequest<RegisteredCardReqVO> queryCardReqVo) {
        RestTemplate template = new RestTemplate();
        String url = this.bdUrl + "/card/registerCardInfo";
        ResponseEntity responseEntity = template.postForEntity(url, queryCardReqVo, FrontResponse.class, new Object[0]);
        log.info("\u4fdd\u5b9a\u8fd4\u56de\u7684\u5361\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)responseEntity));
        return responseEntity;
    }

    private ResponseEntity<FrontResponse> GetCardInfoBD(FrontRequest<QueryCardInfoReqVO> cardQueryReq) {
        RestTemplate template = new RestTemplate();
        String url = this.bdUrl + "/card/queryCardInfo";
        ResponseEntity responseEntity = template.postForEntity(url, cardQueryReq, FrontResponse.class, new Object[0]);
        log.info("\u4fdd\u5b9a\u8fd4\u56de\u7684\u5361\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)responseEntity));
        return responseEntity;
    }

    private ResponseEntity<FrontResponse> NCEFYRegisterCarInfo(FrontRequest<RegisteredCardReqVO> registeredCardReqVO) {
        RestTemplate template = new RestTemplate();
        String url = this.ncefyBaseCloudUrl + "/card/register";
        ResponseEntity responseEntity = template.postForEntity(url, registeredCardReqVO, FrontResponse.class, new Object[0]);
        log.info("\u5357\u5927\u4e8c\u9644\u9662\u6ce8\u518c\u5c31\u8bca\u5361\u8fd4\u56de\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)responseEntity));
        return responseEntity;
    }

    private ResponseEntity<FrontResponse> HytRegisterCardOnLine(FrontRequest<HytRegisterCardReqVO> hytRegisterCardReq) {
        RestTemplate template = new RestTemplate();
        String url = this.htzxBaseCloudUrl + "/hyt-his/api/v1/card/register";
        log.info("\u822a\u5929\u6ce8\u518c\u5c31\u8bca\u5361URL\uff1a{},\u5165\u53c2:{}", (Object)url, JSON.toJSON(hytRegisterCardReq));
        ResponseEntity responseEntity = template.postForEntity(url, hytRegisterCardReq, FrontResponse.class, new Object[0]);
        log.info("\u822a\u5929\u6ce8\u518c\u5c31\u8bca\u5361\u8fd4\u56de\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)responseEntity));
        return responseEntity;
    }
}

