/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.card.server.controller;

import com.ebaiyihui.card.common.api.PatientBlacklistApi;
import com.ebaiyihui.card.common.vo.AddBlacklistBusinessReqVO;
import com.ebaiyihui.card.common.vo.PatientBlacklistPageReqVO;
import com.ebaiyihui.card.common.vo.PatientBlacklistRespVO;
import com.ebaiyihui.card.common.vo.RemoveBlacklistBusinessReqVO;
import com.ebaiyihui.card.common.vo.SaveBlacklistReqVO;
import com.ebaiyihui.card.server.pojo.entity.PatientBlacklist;
import com.ebaiyihui.card.server.service.PatientBlacklistService;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import io.swagger.annotations.Api;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/patient/blacklist"})
@Api(description="\u60a3\u8005\u9ed1\u540d\u5355")
public class PatientBlacklistController
implements PatientBlacklistApi {
    @Autowired
    private PatientBlacklistService patientBlacklistService;

    public BaseResponse saveBlacklist(@Validated @RequestBody SaveBlacklistReqVO saveBlacklistReqVO) {
        String patientCardNo = saveBlacklistReqVO.getPatientCardNo();
        PatientBlacklist patientBlacklist = this.patientBlacklistService.getByPatientCardNo(patientCardNo);
        if (patientBlacklist != null) {
            return BaseResponse.error((String)"\u6dfb\u52a0\u5931\u8d25\uff0c\u8be5\u60a3\u8005\u5df2\u7ecf\u6dfb\u52a0\u9ed1\u540d\u5355\uff01");
        }
        this.patientBlacklistService.saveBlacklist(saveBlacklistReqVO);
        return BaseResponse.success();
    }

    public BaseResponse removeBlacklist(@RequestParam(value="patientBlacklistId") Long patientBlacklistId) {
        this.patientBlacklistService.removeBlacklist(patientBlacklistId);
        return BaseResponse.success();
    }

    public BaseResponse<PatientBlacklistRespVO> getByPatientCardNoAndBusinessCode(String patientCardNo, String businessCode) {
        if (patientCardNo == null || businessCode == null) {
            return BaseResponse.success(null);
        }
        PatientBlacklist patientBlacklist = this.patientBlacklistService.getByPatientCardNoAndBusinessCode(patientCardNo, businessCode);
        if (patientBlacklist == null) {
            return BaseResponse.success(null);
        }
        PatientBlacklistRespVO patientBlacklistRespVO = new PatientBlacklistRespVO();
        BeanUtils.copyProperties((Object)patientBlacklist, (Object)patientBlacklistRespVO);
        return BaseResponse.success((Object)patientBlacklistRespVO);
    }

    public BaseResponse<PageResult<PatientBlacklistRespVO>> findPage(@Validated @RequestBody PatientBlacklistPageReqVO patientBlacklistPageReqVO) {
        PageResult pageResult = this.patientBlacklistService.findPage(patientBlacklistPageReqVO);
        return BaseResponse.success((Object)pageResult);
    }

    public BaseResponse addBlacklistBusiness(@Validated @RequestBody AddBlacklistBusinessReqVO addBlacklistBusinessReqVO) {
        this.patientBlacklistService.addBlacklistBusiness(addBlacklistBusinessReqVO);
        return BaseResponse.success();
    }

    public BaseResponse removeBlacklistBusiness(@Validated @RequestBody RemoveBlacklistBusinessReqVO removeBlacklistBusinessReqVO) {
        this.patientBlacklistService.removeBlacklistBusiness(removeBlacklistBusinessReqVO);
        return BaseResponse.success();
    }
}

