/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.cbs.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.doctor.basedata.api.utils.ValidateResult;
import com.doctoruser.api.pojo.base.bo.DoctorWorkingServiceReq;
import com.doctoruser.api.pojo.base.vo.BaseDoctorInfoVo;
import com.ebaiyihui.cbs.enums.DocServiceEnum;
import com.ebaiyihui.cbs.factory.DocServiceFactory;
import com.ebaiyihui.cbs.factory.DoctorServerFactory;
import com.ebaiyihui.cbs.model.InDoServiceStatus;
import com.ebaiyihui.cbs.model.doctor.BatchServiceConfigReqVo;
import com.ebaiyihui.cbs.model.doctor.DocChildServiceVo;
import com.ebaiyihui.cbs.model.doctor.DocServiceConfigParam;
import com.ebaiyihui.cbs.model.doctor.DocServiceManageReqVo;
import com.ebaiyihui.cbs.model.doctor.DocServiceSetParam;
import com.ebaiyihui.cbs.model.doctor.DoctorServerReqVo;
import com.ebaiyihui.cbs.model.doctor.OrganProfessionDoctorReqVo;
import com.ebaiyihui.cbs.service.DocServiceManageService;
import com.ebaiyihui.cbs.service.DoctorServer;
import com.ebaiyihui.cbs.service.handler.DocServiceHandler;
import com.ebaiyihui.cbs.util.HxHttpClient;
import com.ebaiyihui.forward.client.feignclient.DoctorWorkServiceClient;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.response.IError;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class DocServiceManageServiceImpl
implements DocServiceManageService {
    private static final Logger log = LoggerFactory.getLogger(DocServiceManageServiceImpl.class);
    @Autowired
    private DoctorServerFactory doctorServerFactory;
    @Autowired
    private DocServiceFactory docServiceFactory;
    @Autowired
    private DoctorWorkServiceClient doctorWorkServiceClient;
    @Value(value="${cloud.domain}")
    private String domain;

    public BaseResponse setDoctorService(DoctorServerReqVo doctorServerReqVo) {
        DocServiceEnum docServiceEnum = DocServiceEnum.getEnumByValue((String)doctorServerReqVo.getDoctorServerEnum());
        if (Objects.isNull(docServiceEnum)) {
            return BaseResponse.error((IError)IError.PARAM_CHECK_FAILD);
        }
        List docServiceSetParamList = this.convertServiceSetParam(doctorServerReqVo);
        DoctorServer doctorServer = this.doctorServerFactory.getDoctorServer(docServiceEnum);
        for (DocServiceSetParam docServiceSetParam : docServiceSetParamList) {
            log.info("\u8c03\u7528\u7ba1\u7406\u7aef\u5f00\u901a\u670d\u52a1,\u63a5\u53e3\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)doctorServerReqVo));
            doctorServer.openServer(docServiceSetParam);
            log.info("\u8c03\u7528\u5404\u670d\u52a1\u8bbe\u7f6e\u5b8c\u6210,\u5f00\u59cb\u540c\u6b65\u5230\u533b\u751f\u670d\u52a1");
            this.setDoctorServerAccess(docServiceSetParam);
            log.info("=====\u5f00\u59cb\u8c03\u7528\u4e91\u4e0a\u533b\u751f\u540c\u6b65\u670d\u52a1\u4fe1\u606f======");
            InDoServiceStatus inDoServiceStatus = doctorServer.synchronizeService(docServiceSetParam);
            log.info("=====\u8c03\u7528\u4e91\u4e0a\u533b\u751f\u540c\u6b65\u670d\u52a1\u4fe1\u606f\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)doctorServerReqVo));
            String synchronizeServiceUrl = this.domain + "cloud/doctorbasedata/doctor/service/synchronous";
            BaseResponse response = DocServiceManageServiceImpl.doJsonPost((Object)inDoServiceStatus, (String)synchronizeServiceUrl);
            log.info("\u8c03\u7528\u4e91\u4e0a\u533b\u751f\u540c\u6b65\u670d\u52a1\u4fe1\u606f\u8fd4\u56de\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)response));
            if (response != null && response.getCode().equals("1")) continue;
            log.error("\u8c03\u7528\u4e91\u4e0a\u533b\u751f\u540c\u6b65\u670d\u52a1\u4fe1\u606f\u5931\u8d25,\u5165\u53c2:{},\u9519\u8bef\u4ee3\u7801:{}", (Object)JSON.toJSONString((Object)inDoServiceStatus), (Object)JSON.toJSONString((Object)response));
            throw new RuntimeException("\u8c03\u7528\u4e91\u4e0a\u533b\u751f\u540c\u6b65\u670d\u52a1\u4fe1\u606f\u5931\u8d25");
        }
        return BaseResponse.success();
    }

    public BaseResponse updateDoctorService(DoctorServerReqVo doctorServerReqVo) {
        DocServiceEnum docServiceEnum = DocServiceEnum.getEnumByValue((String)doctorServerReqVo.getDoctorServerEnum());
        if (Objects.isNull(docServiceEnum)) {
            return BaseResponse.error((IError)IError.PARAM_CHECK_FAILD);
        }
        List docServiceSetParamList = this.convertServiceSetParam(doctorServerReqVo);
        DoctorServer doctorServer = this.doctorServerFactory.getDoctorServer(docServiceEnum);
        for (DocServiceSetParam docServiceSetParam : docServiceSetParamList) {
            doctorServer.openServer(docServiceSetParam);
            log.info("\u8c03\u7528\u5404\u670d\u52a1\u8bbe\u7f6e\u5b8c\u6210,\u5f00\u59cb\u540c\u6b65\u5230\u533b\u751f\u670d\u52a1");
            this.saveDoctorWorkService(docServiceSetParam);
            log.info("=====\u5f00\u59cb\u8c03\u7528\u4e91\u4e0a\u533b\u751f\u540c\u6b65\u670d\u52a1\u4fe1\u606f======");
            InDoServiceStatus inDoServiceStatus = doctorServer.synchronizeService(docServiceSetParam);
            log.info("=====\u8c03\u7528\u4e91\u4e0a\u533b\u751f\u540c\u6b65\u670d\u52a1\u4fe1\u606f\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)doctorServerReqVo));
            String synchronizeServiceUrl = this.domain + "cloud/doctorbasedata/doctor/service/synchronous";
            BaseResponse response = DocServiceManageServiceImpl.doJsonPost((Object)inDoServiceStatus, (String)synchronizeServiceUrl);
            log.info("\u8c03\u7528\u4e91\u4e0a\u533b\u751f\u540c\u6b65\u670d\u52a1\u4fe1\u606f\u8fd4\u56de\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)response));
            if (response != null && response.getCode().equals("1")) continue;
            log.error("\u8c03\u7528\u4e91\u4e0a\u533b\u751f\u540c\u6b65\u670d\u52a1\u4fe1\u606f\u5931\u8d25,\u5165\u53c2:{},\u9519\u8bef\u4ee3\u7801:{}", (Object)JSON.toJSONString((Object)inDoServiceStatus), (Object)JSON.toJSONString((Object)response));
            throw new RuntimeException("\u8c03\u7528\u4e91\u4e0a\u533b\u751f\u540c\u6b65\u670d\u52a1\u4fe1\u606f\u5931\u8d25");
        }
        return BaseResponse.success();
    }

    public static BaseResponse doJsonPost(Object param, String url) {
        try {
            log.info("\u8fdc\u7a0b\u8c03\u7528\u8def\u5f84:{},\u8c03\u7528\u5165\u53c2[{}]", (Object)url, (Object)JSON.toJSONString((Object)param));
            String response = HxHttpClient.post((String)url, (String)JSON.toJSONString((Object)param));
            log.info("\u8fdc\u7a0b\u8c03\u7528\u8def\u5f84\u8fd4\u56de[{}]", (Object)response);
            return (BaseResponse)JSON.parseObject((String)response, BaseResponse.class);
        }
        catch (Exception e) {
            log.error("\u8fdc\u7a0b\u8c03\u7528\u51fa\u9519", (Throwable)e);
            return null;
        }
    }

    public BaseResponse batchSetDoctorService(BatchServiceConfigReqVo batchServiceConfigReqVo) {
        OrganProfessionDoctorReqVo organProfessionDoctorReqVo = new OrganProfessionDoctorReqVo();
        ArrayList<Long> ids = new ArrayList<Long>();
        Long organId = batchServiceConfigReqVo.getOrganId();
        ids.add(organId);
        organProfessionDoctorReqVo.setOrganIds(ids);
        organProfessionDoctorReqVo.setProfessionCode(batchServiceConfigReqVo.getProfessionCode());
        BaseResponse baseResponse = DocServiceManageServiceImpl.doJsonPost((Object)organProfessionDoctorReqVo, (String)(this.domain + "cloud/doctorbasedata/doctor/getOrganProfessionDoctor"));
        int count = 0;
        if (Objects.nonNull(baseResponse)) {
            JSONArray jsonArray = (JSONArray)baseResponse.getData();
            List baseDoctorInfoVos = JSON.parseArray((String)jsonArray.toJSONString(), BaseDoctorInfoVo.class);
            log.info("\u5904\u7406\u540e\u7684\u533b\u751f\u57fa\u672c\u4fe1\u606f[{}]", (Object)JSON.toJSONString((Object)baseDoctorInfoVos));
            for (BaseDoctorInfoVo baseDoctorInfoVo : baseDoctorInfoVos) {
                DoctorServerReqVo doctorServerReqVo = new DoctorServerReqVo();
                doctorServerReqVo.setAppCode(batchServiceConfigReqVo.getAppCode());
                doctorServerReqVo.setAuthStatus(batchServiceConfigReqVo.getAuthStatus());
                doctorServerReqVo.setDoctorId(baseDoctorInfoVo.getDoctorId());
                doctorServerReqVo.setDoctorServerEnum(batchServiceConfigReqVo.getDoctorServerEnum());
                doctorServerReqVo.setOrganId(baseDoctorInfoVo.getOrganId());
                doctorServerReqVo.setServerConfig(batchServiceConfigReqVo.getServerConfig());
                this.setDoctorService(doctorServerReqVo);
                ++count;
            }
            return BaseResponse.success((Object)count);
        }
        return BaseResponse.success();
    }

    private void setDoctorServerAccess(DocServiceSetParam docServiceSetParam) {
        DoctorWorkingServiceReq doctorWorkingServiceReq = new DoctorWorkingServiceReq();
        BeanUtils.copyProperties((Object)docServiceSetParam, (Object)doctorWorkingServiceReq);
        log.info("\u533b\u751f\u7aef\u8bbe\u7f6e\u670d\u52a1\u4fe1\u606f\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)doctorWorkingServiceReq));
        BaseResponse baseResponse = this.doctorWorkServiceClient.saveDoctorServiceAccess(doctorWorkingServiceReq);
        log.info("\u533b\u751f\u7aef\u8bbe\u7f6e\u670d\u52a1\u8fd4\u56de\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)baseResponse));
        if (!"1".equals(baseResponse.getCode())) {
            throw new RuntimeException("\u8c03\u7528\u533b\u751f\u7aef\u8272\u8bbe\u7f6e\u670d\u52a1\u4fe1\u606f\u5931\u8d25");
        }
    }

    private void saveDoctorWorkService(DocServiceSetParam docServiceSetParam) {
        DoctorWorkingServiceReq doctorWorkingServiceReq = new DoctorWorkingServiceReq();
        BeanUtils.copyProperties((Object)docServiceSetParam, (Object)doctorWorkingServiceReq);
        log.info("\u533b\u751f\u7aef\u8bbe\u7f6e\u670d\u52a1\u4fe1\u606f\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)doctorWorkingServiceReq));
        BaseResponse baseResponse = this.doctorWorkServiceClient.saveDoctorWorkService(doctorWorkingServiceReq);
        log.info("\u533b\u751f\u7aef\u8bbe\u7f6e\u670d\u52a1\u8fd4\u56de\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)baseResponse));
        if (!baseResponse.getCode().equals("1")) {
            log.error("\u533b\u751f\u7aef\u8bbe\u7f6e\u533b\u751f\u670d\u52a1\u5931\u8d25:{}", (Object)JSON.toJSONString((Object)doctorWorkingServiceReq));
            throw new RuntimeException("\u8c03\u7528\u533b\u751f\u7aef\u8272\u8bbe\u7f6e\u670d\u52a1\u4fe1\u606f\u5931\u8d25");
        }
    }

    private List<DocServiceSetParam> convertServiceSetParam(DoctorServerReqVo doctorServerReqVo) {
        ArrayList<DocServiceSetParam> docServiceSetParamList = new ArrayList<DocServiceSetParam>();
        DocServiceSetParam docServiceSetParam = new DocServiceSetParam();
        docServiceSetParam.setDoctorId(doctorServerReqVo.getDoctorId());
        docServiceSetParam.setOrganId(doctorServerReqVo.getOrganId());
        docServiceSetParam.setRemark("");
        docServiceSetParam.setServiceCode(doctorServerReqVo.getDoctorServerEnum());
        docServiceSetParam.setServiceInfo(doctorServerReqVo.getServerConfig());
        docServiceSetParam.setAppCode(doctorServerReqVo.getAppCode());
        docServiceSetParam.setStatus(doctorServerReqVo.getAuthStatus().intValue());
        docServiceSetParamList.add(docServiceSetParam);
        if (Objects.nonNull(doctorServerReqVo.getChildService())) {
            for (DocChildServiceVo docChildService : doctorServerReqVo.getChildService()) {
                DocServiceSetParam serviceSetParam = new DocServiceSetParam();
                serviceSetParam.setDoctorId(doctorServerReqVo.getDoctorId());
                serviceSetParam.setOrganId(doctorServerReqVo.getOrganId());
                serviceSetParam.setRemark(docChildService.getProperty());
                serviceSetParam.setServiceCode(docChildService.getServiceCode());
                serviceSetParam.setServiceInfo(docChildService.getServerConfig());
                serviceSetParam.setAppCode(doctorServerReqVo.getAppCode());
                serviceSetParam.setStatus(docChildService.getAuthStatus().intValue());
                docServiceSetParamList.add(serviceSetParam);
            }
        }
        return docServiceSetParamList;
    }

    public BaseResponse manageDocService(DocServiceManageReqVo docServiceManageReqVo) {
        ValidateResult validateResult;
        DocServiceEnum docServiceEnum = DocServiceEnum.getEnumByValue((String)docServiceManageReqVo.getServiceCode());
        if (docServiceEnum == null) {
            return BaseResponse.error((IError)IError.PARAM_CHECK_FAILD);
        }
        DocServiceConfigParam docServiceConfigParam = new DocServiceConfigParam();
        BeanUtils.copyProperties((Object)docServiceManageReqVo, (Object)docServiceConfigParam);
        docServiceConfigParam.setDeptId(docServiceManageReqVo.getDeptIds());
        DocServiceHandler docServiceHandler = this.docServiceFactory.getDocServiceHandler(docServiceEnum);
        if (1 == docServiceManageReqVo.getStatus() && !(validateResult = docServiceHandler.validateServiceConfig(docServiceConfigParam)).isSuccess()) {
            return BaseResponse.error((String)validateResult.getMessage());
        }
        log.info("\u7ba1\u7406\u7aef\u5f00\u901a\u670d\u52a1,\u63a5\u53e3\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)docServiceConfigParam));
        BaseResponse baseResponse = docServiceHandler.executeManageSynchroniseCloud(docServiceConfigParam);
        if ("0".equals(baseResponse.getCode())) {
            return BaseResponse.error((String)baseResponse.getMsg());
        }
        if (1 == docServiceManageReqVo.getStatus()) {
            log.info("=====\u5f00\u59cb\u8c03\u7528\u5404\u670d\u52a1\u8bbe\u7f6e====");
            BaseResponse synResponse = docServiceHandler.executeSynchroniseService(docServiceConfigParam);
            log.info("\u8c03\u7528\u5404\u670d\u52a1\u8bbe\u7f6e\u5b8c\u6210:{}", (Object)JSON.toJSONString((Object)synResponse));
        }
        return BaseResponse.success();
    }

    public BaseResponse editDocService(DocServiceManageReqVo docServiceManageReqVo) {
        DocServiceEnum docServiceEnum = DocServiceEnum.getEnumByValue((String)docServiceManageReqVo.getServiceCode());
        if (docServiceEnum == null) {
            return BaseResponse.error((IError)IError.PARAM_CHECK_FAILD);
        }
        DocServiceConfigParam docServiceConfigParam = new DocServiceConfigParam();
        BeanUtils.copyProperties((Object)docServiceManageReqVo, (Object)docServiceConfigParam);
        docServiceConfigParam.setDeptId(docServiceManageReqVo.getDeptIds());
        DocServiceHandler docServiceHandler = this.docServiceFactory.getDocServiceHandler(docServiceEnum);
        ValidateResult validateResult = docServiceHandler.validateServiceConfig(docServiceConfigParam);
        if (!validateResult.isSuccess()) {
            return BaseResponse.error((String)validateResult.getMessage());
        }
        log.info("\u7ba1\u7406\u7aef\u5f00\u901a\u670d\u52a1,\u63a5\u53e3\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)docServiceConfigParam));
        BaseResponse baseResponse = docServiceHandler.executeDoctorSynchroniseCloud(docServiceConfigParam);
        if (!"1".equals(baseResponse.getCode())) {
            return BaseResponse.error((String)baseResponse.getMsg());
        }
        log.info("=====\u5f00\u59cb\u8c03\u7528\u5404\u670d\u52a1\u8bbe\u7f6e====");
        BaseResponse synResponse = docServiceHandler.executeSynchroniseService(docServiceConfigParam);
        log.info("\u8c03\u7528\u5404\u670d\u52a1\u8bbe\u7f6e\u5b8c\u6210:{}", (Object)JSON.toJSONString((Object)synResponse));
        return BaseResponse.success();
    }

    public BaseResponse batchOpenService(List<DocServiceManageReqVo> docServiceManageReqVos) {
        log.info("\u5f00\u901a\u670d\u52a1\u7684\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString(docServiceManageReqVos));
        if (docServiceManageReqVos == null || docServiceManageReqVos.isEmpty()) {
            return BaseResponse.error((String)"\u8bf7\u9009\u62e9\u8981\u5f00\u901a\u7684\u670d\u52a1");
        }
        for (DocServiceManageReqVo docServiceManageReqVo : docServiceManageReqVos) {
            this.manageDocService(docServiceManageReqVo);
        }
        return BaseResponse.success();
    }
}

