/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.cbs.factory;

import com.ebaiyihui.cbs.enums.DocServiceEnum;
import com.ebaiyihui.cbs.service.handler.DocServiceHandler;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DocServiceFactory {
    @Autowired
    private Map<String, DocServiceHandler> doctorServerMap = new ConcurrentHashMap(14);

    public DocServiceHandler getDocServiceHandler(DocServiceEnum serviceEnum) {
        DocServiceHandler docServiceHandler = (DocServiceHandler)this.doctorServerMap.get(serviceEnum.getHandlerName());
        if (Objects.isNull(docServiceHandler)) {
            return (DocServiceHandler)this.doctorServerMap.get("common_handler");
        }
        return docServiceHandler;
    }
}

