/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.data.business.upload.immediate;

import com.alibaba.otter.canal.protocol.CanalEntry;
import com.ebaiyihui.data.business.upload.reservation.IUpload;
import com.ebaiyihui.data.canal.ITableChangeHandler;
import com.ebaiyihui.data.factroy.InitDataServiceFactory;
import com.ebaiyihui.data.service.beijing.BeijingInitDataService;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeijingTableChangeHandler
implements ITableChangeHandler {
    private static final Logger log = LoggerFactory.getLogger(BeijingTableChangeHandler.class);
    private static final String DB_NAME_ONLINE_OUTPATIENT = "ht_byh-online-outpatient-new";
    private static final String TB_NAME_ADMISSION = "inquiry_admission";
    public static List<String> admFinishStatus = new ArrayList();
    private static final String MEDICAL_CLOUD_DB_NAME = "byh_medicalcloud_service";
    private static final String TB_NAME_DRUG_MAIN = "mos_drug_main";
    private static final String PRES_FINISH_STATUS = "120";

    public void delete(List<CanalEntry.Column> beforeList, String db, String table) {
    }

    public void insert(List<CanalEntry.Column> afterList, String db, String table) {
    }

    public void update(List<CanalEntry.Column> beforeList, List<CanalEntry.Column> afterList, String db, String table) {
        if (DB_NAME_ONLINE_OUTPATIENT.equals(db) && TB_NAME_ADMISSION.equals(table)) {
            this.uploadAdmissionInfoByAdmInfo(afterList);
        }
    }

    private void uploadAdmissionInfoByPresInfo(List<CanalEntry.Column> afterList) {
        String value;
        String name;
        String mainId = null;
        String hospitalId = "";
        for (CanalEntry.Column column : afterList) {
            name = column.getName();
            if ("x_id".equals(name)) {
                mainId = value = column.getValue();
                continue;
            }
            if (!"organ_id".equals(name)) continue;
            hospitalId = value = column.getValue();
            break;
        }
        for (CanalEntry.Column column : afterList) {
            BeijingInitDataService beijingInitDataService;
            name = column.getName();
            value = column.getValue();
            boolean isUpdated = column.getUpdated();
            logger.info((Object)("beijing data update :" + name + " value :" + value + "is updated" + isUpdated));
            if (!isUpdated || !"itemStatus".equals(name) || !PRES_FINISH_STATUS.equals(value) || !Objects.nonNull(beijingInitDataService = InitDataServiceFactory.getBeijingInitDataService((String)hospitalId))) continue;
            IUpload iUpload = beijingInitDataService.getClinicInfoByMainIdAndHosId(mainId, hospitalId);
            this.uploadHandler(iUpload);
        }
    }

    private void uploadAdmissionInfoByAdmInfo(List<CanalEntry.Column> afterList) {
        String value;
        String name;
        String admId = null;
        String hospitalId = "";
        for (CanalEntry.Column column : afterList) {
            name = column.getName();
            if ("x_id".equals(name)) {
                admId = value = column.getValue();
                continue;
            }
            if (!"organ_id".equals(name)) continue;
            hospitalId = value = column.getValue();
            break;
        }
        for (CanalEntry.Column column : afterList) {
            BeijingInitDataService beijingInitDataService;
            name = column.getName();
            value = column.getValue();
            boolean isUpdated = column.getUpdated();
            logger.info((Object)("beijing data update :" + name + " value :" + value + "is updated" + isUpdated));
            if (!isUpdated || !"status".equals(name) || !admFinishStatus.contains(value) || !Objects.nonNull(beijingInitDataService = InitDataServiceFactory.getBeijingInitDataService((String)hospitalId))) continue;
            IUpload iUpload = beijingInitDataService.getClinicInfoByAdmIdAndHosId(admId, hospitalId);
            this.uploadHandler(iUpload);
        }
    }

    private boolean uploadHandler(IUpload iUpload) {
        if (Objects.isNull(iUpload)) {
            log.info("\u672a\u67e5\u5230\u4e1a\u52a1\u6570\u636e\uff0c\u4e0a\u4f20\u5931\u8d25");
            return false;
        }
        boolean flag = iUpload.dataStorage();
        if (flag) {
            iUpload.dataUpload();
        }
        return false;
    }

    static {
        admFinishStatus.add("7");
        admFinishStatus.add("8");
        admFinishStatus.add("9");
    }
}

