/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.data.business.upload.immediate;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.otter.canal.protocol.CanalEntry;
import com.ebaiyihui.data.business.upload.reservation.IUpload;
import com.ebaiyihui.data.business.upload.reservation.ScUpload;
import com.ebaiyihui.data.canal.ITableChangeHandler;
import com.ebaiyihui.data.config.NodeConfig;
import com.ebaiyihui.data.dao.AdmissionSCMapper;
import com.ebaiyihui.data.pojo.vo.sc.UploadConsultReq;
import com.ebaiyihui.data.pojo.vo.sc.UploadFurtherConsultReq;
import com.ebaiyihui.data.utils.HttpsApiUtil;
import com.ebaiyihui.data.utils.RedisUtil;
import com.ebaiyihui.data.utils.SnowflakeIdWorker;
import com.ebaiyihui.framework.utils.IdCardUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CDFYTableChangeHandler
implements ITableChangeHandler {
    private static final Logger log = LoggerFactory.getLogger(CDFYTableChangeHandler.class);
    @Resource
    AdmissionSCMapper admissionSCMapper;
    private static final String CARD_DB_NAME = "h_card_service";
    private static final String TB_NAME_CS_CARD = "cs_card";
    private static final String ONLINE_OUTPATIENT_DB_NAME = "byh-online-outpatient-new";
    private static final String TB_NAME_ADMISSION = "inquiry_admission";
    private static final String STATUS_ONE = "7";
    private static final String STATUS_TWO = "8";
    private static final String STATUS_THREE = "9";
    private static final String STATUS_FOUR = "1";
    private static final String SERVTYPE_ZX = "2";
    private static final String SERVTYPE_FZ = "3";
    private static final String TB_NAME_EVALUSTION = "uc_user_evaluation";
    @Autowired
    private NodeConfig nodeConfig;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    private static List<String> statusList = new ArrayList();

    public void delete(List<CanalEntry.Column> beforeList, String db, String table) {
    }

    public void insert(List<CanalEntry.Column> afterList, String db, String table) {
        if (ONLINE_OUTPATIENT_DB_NAME.equals(db) && TB_NAME_EVALUSTION.equals(table)) {
            this.uploadEvaluationNews(afterList);
        }
    }

    public void update(List<CanalEntry.Column> beforeList, List<CanalEntry.Column> afterList, String db, String table) {
        if (ONLINE_OUTPATIENT_DB_NAME.equals(db) && TB_NAME_ADMISSION.equals(table)) {
            log.info(table);
            this.uploadTreatmentInfo(afterList);
        }
    }

    private void uploadEvaluationNews(List<CanalEntry.Column> afterList) {
        String admId = null;
        for (CanalEntry.Column column : afterList) {
            String value;
            String name = column.getName();
            if (!"adm_id".equals(name)) continue;
            admId = value = column.getValue();
            break;
        }
    }

    private void uploadTreatmentInfo(List<CanalEntry.Column> afterList) {
        String value;
        String name;
        String admId = null;
        String servType = null;
        for (CanalEntry.Column column : afterList) {
            name = column.getName();
            if ("x_id".equals(name)) {
                admId = value = column.getValue();
            }
            if (!"serv_type".equals(name)) continue;
            servType = value = column.getValue();
        }
        log.info(admId);
        log.info(servType);
        for (CanalEntry.Column column : afterList) {
            String acccessToken;
            Object obj;
            ScUpload scUpload;
            name = column.getName();
            value = column.getValue();
            boolean isUpdated = column.getUpdated();
            if (!isUpdated || !"status".equals(name) || !statusList.contains(value)) continue;
            log.info(STATUS_FOUR);
            if (servType.equals(2)) {
                scUpload = new ScUpload();
                log.info(SERVTYPE_ZX);
                UploadConsultReq syncInquiryReqDTO = this.admissionSCMapper.getConsult(admId);
                log.info("\uff0csyncInquiryReqDTO{}", (Object)JSON.toJSONString((Object)syncInquiryReqDTO));
                syncInquiryReqDTO.setThirdUniqueid(String.valueOf(this.snowflakeIdWorker.nextId()));
                obj = this.redisUtil.get("scAccessToken");
                acccessToken = "";
                acccessToken = Objects.isNull(obj) ? this.getAccessToken() : obj.toString();
                syncInquiryReqDTO.setAccessToken(acccessToken);
                syncInquiryReqDTO.setClientId(this.nodeConfig.getClientId());
                syncInquiryReqDTO.setPatientAge(Integer.valueOf(IdCardUtil.getAgeByIdCard((String)syncInquiryReqDTO.getPatientIdcardNum())));
                scUpload.setData(JSON.toJSONStringWithDateFormat((Object)syncInquiryReqDTO, (String)"yyyy-MM-dd HH:mm:ss", (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat}));
                scUpload.setSuffix("/wjw/upload/uploadConsult");
                this.uploadHandler((IUpload)scUpload);
                continue;
            }
            if (!servType.equals(SERVTYPE_FZ)) continue;
            log.info(SERVTYPE_FZ);
            scUpload = new ScUpload();
            UploadFurtherConsultReq uploadFurtherConsultReq = this.admissionSCMapper.getFurtherConsultInfoSC(admId);
            log.info("\uff0csyncInquiryReqDTO{}", (Object)JSON.toJSONString((Object)uploadFurtherConsultReq));
            uploadFurtherConsultReq.setThirdUniqueid(String.valueOf(this.snowflakeIdWorker.nextId()));
            obj = this.redisUtil.get("scAccessToken");
            acccessToken = "";
            acccessToken = Objects.isNull(obj) ? this.getAccessToken() : obj.toString();
            uploadFurtherConsultReq.setAccessToken(acccessToken);
            uploadFurtherConsultReq.setClientId(this.nodeConfig.getClientId());
            uploadFurtherConsultReq.setPatientAge(Integer.valueOf(IdCardUtil.getAgeByIdCard((String)uploadFurtherConsultReq.getPatientIdcardNum())));
            scUpload.setData(JSON.toJSONStringWithDateFormat((Object)uploadFurtherConsultReq, (String)"yyyy-MM-dd HH:mm:ss", (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat}));
            scUpload.setSuffix("/wjw/upload/uploadFurtherConsult");
            this.uploadHandler((IUpload)scUpload);
        }
    }

    private boolean uploadHandler(IUpload iUpload) {
        if (Objects.isNull(iUpload)) {
            log.info("\u672a\u67e5\u5230\u4e1a\u52a1\u6570\u636e\uff0c\u4e0a\u4f20\u5931\u8d25");
            return false;
        }
        boolean flag = iUpload.dataStorage();
        if (flag) {
            iUpload.dataUpload();
        }
        return false;
    }

    private String getAccessToken() {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("clientId", this.nodeConfig.getClientId());
        m.put("appSecret", this.nodeConfig.getAppSecret());
        byte[] bytes = new byte[]{};
        try {
            bytes = HttpsApiUtil.sendJsonToHttpsPost((String)"https://202.61.88.184:19200/wjw/third/oauth/getAccessToken", (String)JSONObject.toJSONString(m), (String)"UTF-8");
        }
        catch (Exception e) {
            log.info("\u8bf7\u6c42\u83b7\u53d6accessToken\u5f02\u5e38");
            return "";
        }
        String s1 = new String(bytes);
        log.info("\u8bf7\u6c42\u83b7\u53d6accessToken\u8fd4\u56de" + s1);
        if (Objects.isNull(s1) || "".equals(s1)) {
            return "";
        }
        JSONObject jSONObject = JSONObject.parseObject((String)s1);
        String data = jSONObject.getString("data");
        JSONObject dataStrObj = JSONObject.parseObject((String)data);
        String accessToken = dataStrObj.getString("accessToken");
        this.redisUtil.set("scAccessToken", (Object)accessToken, 86400L);
        return accessToken;
    }

    static {
        statusList.add(STATUS_ONE);
        statusList.add(STATUS_TWO);
        statusList.add(STATUS_THREE);
        statusList.add(STATUS_FOUR);
    }
}

