/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.data.business.upload.immediate;

import com.alibaba.otter.canal.protocol.CanalEntry;
import com.ebaiyihui.data.business.upload.reservation.IUpload;
import com.ebaiyihui.data.canal.ITableChangeHandler;
import com.ebaiyihui.data.factroy.InitDataServiceFactory;
import com.ebaiyihui.data.service.hebei.HeBeiInitDataService;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeBeiTableChangeHandler
implements ITableChangeHandler {
    private static final Logger log = LoggerFactory.getLogger(HeBeiTableChangeHandler.class);
    private static final String DB_NAME_ONLINE_OUTPATIENT = "hbbd_byh-online-outpatient";
    private static final String TB_NAME_ADMISSION = "inquiry_admission";
    private static final String TB_NAME_EVA = "uc_user_evaluation";
    public static List<String> admFinishStatus = new ArrayList();
    private static final String PRES_FINISH_STATUS = "120";

    public void delete(List<CanalEntry.Column> beforeList, String db, String table) {
    }

    public void insert(List<CanalEntry.Column> afterList, String db, String table) {
        if (DB_NAME_ONLINE_OUTPATIENT.equals(db) && TB_NAME_EVA.equals(table)) {
            this.evaluation(afterList);
        }
    }

    public void update(List<CanalEntry.Column> beforeList, List<CanalEntry.Column> afterList, String db, String table) {
        if (DB_NAME_ONLINE_OUTPATIENT.equals(db) && TB_NAME_ADMISSION.equals(table)) {
            this.uploadAdmissionInfoByAdmInfo(afterList);
        }
    }

    private void uploadAdmissionInfoByAdmInfo(List<CanalEntry.Column> afterList) {
        String value;
        String name;
        String admId = null;
        String hospitalId = "";
        String patientId = "";
        for (CanalEntry.Column column : afterList) {
            name = column.getName();
            if ("x_id".equals(name)) {
                admId = value = column.getValue();
                continue;
            }
            if ("organ_id".equals(name)) {
                hospitalId = value = column.getValue();
                continue;
            }
            if (!"patient_id".equals(name)) continue;
            patientId = value = column.getValue();
        }
        for (CanalEntry.Column column : afterList) {
            HeBeiInitDataService heBeiInitDataService;
            name = column.getName();
            value = column.getValue();
            boolean isUpdated = column.getUpdated();
            logger.info((Object)("hebei data update :" + name + " value :" + value + "is updated" + isUpdated));
            if (!isUpdated || !"status".equals(name) || !admFinishStatus.contains(value) || !Objects.nonNull(heBeiInitDataService = InitDataServiceFactory.getHeBeiInitDataService((String)hospitalId))) continue;
            IUpload registerIUpload = heBeiInitDataService.getRegister(admId, hospitalId);
            this.uploadHandler(registerIUpload);
            IUpload patientIUpload = heBeiInitDataService.getPatient(patientId, admId, hospitalId);
            this.uploadHandler(patientIUpload);
            IUpload medicalIUpload = heBeiInitDataService.getMedical(admId, hospitalId);
            this.uploadHandler(medicalIUpload);
            IUpload userAgreement = heBeiInitDataService.getUserAgreement(patientId, admId, hospitalId);
            this.uploadHandler(userAgreement);
        }
    }

    private boolean uploadHandler(IUpload iUpload) {
        if (Objects.isNull(iUpload)) {
            log.info("\u672a\u67e5\u5230\u4e1a\u52a1\u6570\u636e\uff0c\u4e0a\u4f20\u5931\u8d25");
            return false;
        }
        boolean flag = iUpload.dataStorage();
        if (flag) {
            iUpload.dataUpload();
        }
        return false;
    }

    private void evaluation(List<CanalEntry.Column> afterList) {
        String admId = null;
        String hospitalId = "";
        for (CanalEntry.Column column : afterList) {
            String value;
            String name = column.getName();
            if ("adm_id".equals(name)) {
                admId = value = column.getValue();
                continue;
            }
            if ("organ_id".equals(name)) {
                hospitalId = value = column.getValue();
                continue;
            }
            HeBeiInitDataService heBeiInitDataService = InitDataServiceFactory.getHeBeiInitDataService((String)hospitalId);
            IUpload evaluationIUpload = heBeiInitDataService.getEvaluation(admId, hospitalId);
            this.uploadHandler(evaluationIUpload);
        }
    }

    static {
        admFinishStatus.add("7");
        admFinishStatus.add("8");
        admFinishStatus.add("9");
    }
}

