/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.data.business.upload.immediate;

import com.alibaba.otter.canal.protocol.CanalEntry;
import com.ebaiyihui.data.business.upload.reservation.IUpload;
import com.ebaiyihui.data.canal.ITableChangeHandler;
import com.ebaiyihui.data.service.hunan.HuNanInitDataService;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class HuNanTableChangeHandler
implements ITableChangeHandler {
    private static final Logger log = LoggerFactory.getLogger(HuNanTableChangeHandler.class);
    private static final String CARD_DB_NAME = "hnht_ih_card_service";
    private static final String TB_NAME_CS_CARD = "cs_card";
    private static final String ONLINE_OUTPATIENT_DB_NAME = "hnht_byh-online-outpatient-new";
    private static final String TB_NAME_ADMISSION = "inquiry_admission";
    private static final String TB_NAME_ANOMALOUS_EVENT = "inquiry_anomalous_event";
    private static final String STATUS_ONE = "7";
    private static final String STATUS_TWO = "8";
    private static final String STATUS_THREE = "9";
    private static final String SERVTYPE_ZX = "2";
    private static final String SERVTYPE_FZ = "3";
    private static final String MEDICAL_CLOUD_DB_NAME = "byh_medicalcloud_service";
    private static final String TB_NAME_DRUG_MAIN = "mos_drug_main";
    private static final String PRES_PAY_STATUS = "70";
    private static final String PRES_FINISH_STATUS = "120";
    private static final String CONSULTATION_DB_NAME = "consultation";
    private static final String TB_NAME_CONSULTATION = "consultation";
    private static final String CONSULTATION_FINISH_STATUS = "40";
    private static final String REFERRAL_DB_NAME = "byh-referral-service";
    private static final String TB_NAME_REFERRAL_ORDER = "referral_order";
    private static final String REFERRAL_FINISH_STATUS = "5";
    private static final String DOCTORUSER_DB_NAME = "cloud_doctoruser";
    private static final String TB_NAME_EVALUSTION = "uc_user_evaluation";
    private static List<String> statusList = new ArrayList();
    @Autowired
    private HuNanInitDataService huNanInitDataService;

    public void delete(List<CanalEntry.Column> beforeList, String db, String table) {
    }

    public void insert(List<CanalEntry.Column> afterList, String db, String table) {
        if (CARD_DB_NAME.equals(db) && TB_NAME_CS_CARD.equals(table)) {
            this.uploadPatientInfo(afterList);
        }
        if (ONLINE_OUTPATIENT_DB_NAME.equals(db) && TB_NAME_ANOMALOUS_EVENT.equals(table)) {
            this.uploadAnomalousEvent(afterList);
            return;
        }
    }

    public void update(List<CanalEntry.Column> beforeList, List<CanalEntry.Column> afterList, String db, String table) {
        if (CARD_DB_NAME.equals(db) && TB_NAME_CS_CARD.equals(table)) {
            this.uploadUpdatePatientInfo(afterList);
        }
        if (ONLINE_OUTPATIENT_DB_NAME.equals(db) && TB_NAME_ADMISSION.equals(table)) {
            this.uploadTreatmentInfo(beforeList, afterList);
            return;
        }
        if ("consultation".equals(db) && "consultation".equals(table)) {
            this.uploadRemoteConsultationInfo(beforeList, afterList);
            return;
        }
        if (REFERRAL_DB_NAME.equals(db) && TB_NAME_REFERRAL_ORDER.equals(table)) {
            this.uploadRemoteReferralInfo(beforeList, afterList);
            return;
        }
        if (DOCTORUSER_DB_NAME.equals(db) && TB_NAME_EVALUSTION.equals(table)) {
            this.uploadEvaluationNews(afterList);
        }
    }

    private void uploadUpdatePatientInfo(List<CanalEntry.Column> afterList) {
        String value;
        String name;
        String cardId = null;
        for (CanalEntry.Column column : afterList) {
            name = column.getName();
            if (!"card_id".equals(name)) continue;
            cardId = value = column.getValue();
            break;
        }
        for (CanalEntry.Column column : afterList) {
            name = column.getName();
            value = column.getValue();
            boolean isUpdated = column.getUpdated();
            logger.info((Object)("hu nan data update :" + name + " value :" + value + "is updated" + isUpdated));
            if (!isUpdated || !"status".equals(name) || !"1".equals(value)) continue;
            log.info("\u76d1\u63a7\u5230\u7684\u65b0\u6dfb\u52a0\u7684cardId \uff1a{}", (Object)cardId);
            IUpload iUpload = this.huNanInitDataService.getPatientInfo(cardId);
            this.uploadHandler(iUpload);
            break;
        }
    }

    private void uploadRemoteReferralInfo(List<CanalEntry.Column> beforeList, List<CanalEntry.Column> afterList) {
        String value;
        String name;
        String id = null;
        for (CanalEntry.Column column : afterList) {
            name = column.getName();
            if (!"order_seq".equals(name)) continue;
            id = value = column.getValue();
            break;
        }
        for (CanalEntry.Column column : afterList) {
            name = column.getName();
            value = column.getValue();
            boolean isUpdated = column.getUpdated();
            logger.info((Object)("hu nan data update :" + name + " value :" + value + "is updated" + isUpdated));
            if (!isUpdated || !"referral_status".equals(name) || !REFERRAL_FINISH_STATUS.equals(value)) continue;
            IUpload iUpload = this.huNanInitDataService.getRemoteReferralInfo(id);
            this.uploadHandler(iUpload);
            break;
        }
    }

    private void uploadRemoteConsultationInfo(List<CanalEntry.Column> beforeList, List<CanalEntry.Column> afterList) {
        String value;
        String name;
        String id = null;
        for (CanalEntry.Column column : afterList) {
            name = column.getName();
            if (!"view_id".equals(name)) continue;
            id = value = column.getValue();
            break;
        }
        for (CanalEntry.Column column : afterList) {
            name = column.getName();
            value = column.getValue();
            boolean isUpdated = column.getUpdated();
            logger.info((Object)("hu nan data update :" + name + " value :" + value + "is updated" + isUpdated));
            if (!isUpdated || !"status".equals(name) || !CONSULTATION_FINISH_STATUS.equals(value)) continue;
            IUpload iUpload = this.huNanInitDataService.getRemoteConsultationInfo(id);
            this.uploadHandler(iUpload);
            break;
        }
    }

    private void uploadPresInfo(List<CanalEntry.Column> beforeList, List<CanalEntry.Column> afterList) {
        String value;
        String name;
        String mainId = null;
        for (CanalEntry.Column column : afterList) {
            name = column.getName();
            if (!"x_id".equals(name)) continue;
            mainId = value = column.getValue();
            break;
        }
        for (CanalEntry.Column column : afterList) {
            name = column.getName();
            value = column.getValue();
            boolean isUpdated = column.getUpdated();
            logger.info((Object)("hu nan data update :" + name + " value :" + value + "is updated" + isUpdated));
            if (isUpdated && "item_status".equals(name) && PRES_PAY_STATUS.equals(value)) {
                IUpload iUpload = this.huNanInitDataService.getRecipeIndicatorsInfo(mainId);
                this.uploadHandler(iUpload);
                IUpload presChargeInfoUpload = this.huNanInitDataService.getPresChargeInfo(mainId);
                this.uploadHandler(presChargeInfoUpload);
                break;
            }
            if (!isUpdated || !"item_status".equals(name) || !PRES_FINISH_STATUS.equals(value)) continue;
            IUpload iUpload = this.huNanInitDataService.getRecipeVerification(mainId);
            this.uploadHandler(iUpload);
            break;
        }
    }

    private void uploadTreatmentInfo(List<CanalEntry.Column> beforeList, List<CanalEntry.Column> afterList) {
        String value;
        String name;
        String admId = null;
        String patientId = null;
        String servType = null;
        String status = null;
        for (CanalEntry.Column column : afterList) {
            name = column.getName();
            if ("x_id".equals(name)) {
                admId = value = column.getValue();
            }
            if ("patient_id".equals(name)) {
                patientId = value = column.getValue();
            }
            if ("serv_type".equals(name)) {
                servType = value = column.getValue();
            }
            if (!"status".equals(name)) continue;
            status = value = column.getValue();
        }
        for (CanalEntry.Column column : afterList) {
            name = column.getName();
            value = column.getValue();
            boolean isUpdated = column.getUpdated();
            logger.info((Object)("hu nan data update :" + name + " value :" + value + "is updated" + isUpdated));
            if (isUpdated && "status".equals(name) && statusList.contains(status)) {
                IUpload iUpload = this.huNanInitDataService.getAppointInfo(admId);
                this.uploadHandler(iUpload);
            }
            if (SERVTYPE_ZX.equals(servType) && isUpdated && "status".equals(name) && statusList.contains(status)) {
                IUpload consultInfoUpload = this.huNanInitDataService.getConsultInfo(admId);
                this.uploadHandler(consultInfoUpload);
            }
            if (SERVTYPE_FZ.equals(servType) && isUpdated && "status".equals(name) && statusList.contains(status)) {
                IUpload revisitInfo = this.huNanInitDataService.getRevisitInfo(admId, patientId);
                this.uploadHandler(revisitInfo);
            }
            if (!isUpdated || !"status".equals(name) || !statusList.contains(status)) continue;
            IUpload chargeInfoHistoryUpload = this.huNanInitDataService.getChargeInfo(admId);
            this.uploadHandler(chargeInfoHistoryUpload);
        }
    }

    private void uploadEvaluationNews(List<CanalEntry.Column> afterList) {
        String isHaveEva;
        String admId = null;
        for (CanalEntry.Column column : afterList) {
            String value;
            String name = column.getName();
            if (!"adm_id".equals(name)) continue;
            admId = value = column.getValue();
            break;
        }
        if (StringUtils.isNotEmpty((String)(isHaveEva = this.huNanInitDataService.getIsHaveEva(admId)))) {
            IUpload evaluationNewsUpload = this.huNanInitDataService.getEvaluationNews(admId);
            this.uploadHandler(evaluationNewsUpload);
        }
    }

    private void uploadAnomalousEvent(List<CanalEntry.Column> afterList) {
        String xId = null;
        for (CanalEntry.Column column : afterList) {
            String name = column.getName();
            if (!"x_id".equals(name)) continue;
            xId = column.getValue();
            break;
        }
        IUpload anomalousUpload = this.huNanInitDataService.getAnomalousEvent(xId);
        this.uploadHandler(anomalousUpload);
    }

    private void uploadPatientInfo(List<CanalEntry.Column> afterList) {
        String cardId = null;
        for (CanalEntry.Column column : afterList) {
            String value;
            String name = column.getName();
            if (!"card_id".equals(name)) continue;
            cardId = value = column.getValue();
            break;
        }
        log.info("\u76d1\u63a7\u5230\u7684\u65b0\u6dfb\u52a0\u7684cardId \uff1a{}", cardId);
        IUpload iUpload = this.huNanInitDataService.getPatientInfo(cardId);
        this.uploadHandler(iUpload);
    }

    private boolean uploadHandler(IUpload iUpload) {
        if (Objects.isNull(iUpload)) {
            log.info("\u672a\u67e5\u5230\u4e1a\u52a1\u6570\u636e\uff0c\u4e0a\u4f20\u5931\u8d25");
            return false;
        }
        boolean flag = iUpload.dataStorage();
        if (flag) {
            iUpload.dataUpload();
        }
        return false;
    }

    static {
        statusList.add(STATUS_ONE);
        statusList.add(STATUS_TWO);
        statusList.add(STATUS_THREE);
    }
}

