/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.data.business.upload.immediate;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.otter.canal.protocol.CanalEntry;
import com.ebaiyihui.data.business.upload.reservation.HeBeiUpload;
import com.ebaiyihui.data.business.upload.reservation.IUpload;
import com.ebaiyihui.data.business.upload.reservation.ScUpload;
import com.ebaiyihui.data.canal.ITableChangeHandler;
import com.ebaiyihui.data.config.NodeConfig;
import com.ebaiyihui.data.dao.AdmissionSCMapper;
import com.ebaiyihui.data.factroy.InitDataServiceFactory;
import com.ebaiyihui.data.pojo.vo.sc.DrugReq;
import com.ebaiyihui.data.pojo.vo.sc.UploadRecipeReq;
import com.ebaiyihui.data.service.beijing.BeijingInitDataService;
import com.ebaiyihui.data.service.hunan.HuNanInitDataService;
import com.ebaiyihui.data.utils.HttpsApiUtil;
import com.ebaiyihui.data.utils.RedisUtil;
import com.ebaiyihui.data.utils.SnowflakeIdWorker;
import com.ebaiyihui.framework.utils.IdCardUtil;
import com.google.gson.Gson;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MedicalCloudTableChangeHandler
implements ITableChangeHandler {
    private static final Logger log = LoggerFactory.getLogger(MedicalCloudTableChangeHandler.class);
    private static final String MEDICAL_CLOUD_DB_NAME = "byh_medicalcloud_service";
    private static final String TB_NAME_DRUG_MAIN = "mos_drug_order";
    private static final String PRES_PAY_STATUS = "70";
    private static final String PRES_FINISH_STATUS = "120";
    private static final String HB_PRES_FINISH_STATUS = "105";
    @Autowired
    private NodeConfig nodeConfig;
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    @Autowired
    private AdmissionSCMapper admissionSCMapper;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private HuNanInitDataService huNanInitDataService;

    public void delete(List<CanalEntry.Column> beforeList, String db, String table) {
    }

    public void insert(List<CanalEntry.Column> afterList, String db, String table) {
    }

    public void update(List<CanalEntry.Column> beforeList, List<CanalEntry.Column> afterList, String db, String table) {
        if (MEDICAL_CLOUD_DB_NAME.equals(db) && TB_NAME_DRUG_MAIN.equals(table)) {
            this.uploadPresInfo(beforeList, afterList);
            return;
        }
    }

    private void uploadPresInfo(List<CanalEntry.Column> beforeList, List<CanalEntry.Column> afterList) {
        String mainId = null;
        String hospitalId = null;
        for (CanalEntry.Column column : afterList) {
            String value;
            String name = column.getName();
            if (!"main_id".equals(name)) continue;
            mainId = value = column.getValue();
            break;
        }
        this.uploadHeBeiPresInfo(afterList, mainId, hospitalId);
    }

    private void uploadHeBeiPresInfo(List<CanalEntry.Column> afterList, String mainId, String hospitalId) {
        for (CanalEntry.Column column : afterList) {
            String name = column.getName();
            String value = column.getValue();
            boolean isUpdated = column.getUpdated();
            logger.info((Object)("hebei data update :" + name + " value :" + value + "is updated" + isUpdated));
            if (!isUpdated || !"status".equals(name) || !"2".equals(value)) continue;
            UploadRecipeReq recipeInfoSC = this.admissionSCMapper.getRecipeInfoSC(mainId);
            ScUpload scUpload = new ScUpload();
            recipeInfoSC.setThirdUniqueid(String.valueOf(this.snowflakeIdWorker.nextId()));
            String acccessToken = "";
            Object obj = this.redisUtil.get("scAccessToken");
            acccessToken = Objects.isNull(obj) ? this.getAccessToken() : obj.toString();
            recipeInfoSC.setAccessToken(acccessToken);
            recipeInfoSC.setClientId(this.nodeConfig.getClientId());
            recipeInfoSC.setPatientAge(Integer.valueOf(IdCardUtil.getAgeByIdCard((String)recipeInfoSC.getPatientIdcardNum())));
            List drugInfoSC = this.admissionSCMapper.getDrugCInfoSC(recipeInfoSC.getRecipeNo());
            StringJoiner recipeUnitPrice = new StringJoiner("|");
            StringJoiner drugName = new StringJoiner("|");
            StringJoiner drugCode = new StringJoiner("|");
            StringJoiner drugCommonName = new StringJoiner("|");
            StringJoiner specification = new StringJoiner("|");
            StringJoiner frequency = new StringJoiner("|");
            StringJoiner usage = new StringJoiner("|");
            StringJoiner doseUnit = new StringJoiner("|");
            StringJoiner doseEachTime = new StringJoiner("|");
            StringJoiner medicationDays = new StringJoiner("|");
            StringJoiner packetNum = new StringJoiner("|");
            StringJoiner quantity = new StringJoiner("|");
            StringJoiner drugPackage = new StringJoiner("|");
            for (DrugReq s : drugInfoSC) {
                recipeUnitPrice.add(recipeInfoSC.getRecipeUnitPrice());
                drugName.add(s.getDrugName());
                drugCode.add(s.getDrugCode());
                drugCommonName.add(s.getDrugCommonName());
                specification.add(s.getSpecification());
                frequency.add(s.getFrequency());
                usage.add(s.getUsage());
                doseUnit.add(s.getDoseUnit());
                doseEachTime.add(s.getDoseEachTime());
                medicationDays.add(s.getMedicationDays());
                quantity.add(s.getQuantity());
                drugPackage.add(s.getDrugPackage());
            }
            recipeInfoSC.setRecipeUnitPrice(recipeUnitPrice.toString());
            recipeInfoSC.setDrugName(drugName.toString());
            recipeInfoSC.setDrugCode(drugCode.toString());
            recipeInfoSC.setDrugCommonName(drugCommonName.toString());
            recipeInfoSC.setSpecification(specification.toString());
            recipeInfoSC.setFrequency(frequency.toString());
            recipeInfoSC.setUsage(usage.toString());
            recipeInfoSC.setDoseUnit(doseUnit.toString());
            recipeInfoSC.setDoseEachTime(doseEachTime.toString());
            recipeInfoSC.setMedicationDays(medicationDays.toString());
            recipeInfoSC.setQuantity(quantity.toString());
            recipeInfoSC.setDrugPackage(drugPackage.toString());
            log.info("=====>sc\u5904\u65b9\u836f\u54c1\u4fe1\u606f", (Object)JSONObject.toJSONString((Object)recipeInfoSC));
            scUpload.setData(JSON.toJSONStringWithDateFormat((Object)recipeInfoSC, (String)"yyyy-MM-dd HH:mm:ss", (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat}));
            scUpload.setHospitalId(hospitalId);
            scUpload.setSuffix("/wjw/upload/uploadRecipe");
            scUpload.dataUpload();
            this.uploadHandler((IUpload)scUpload);
        }
    }

    private String getAccessToken() {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("clientId", this.nodeConfig.getClientId());
        m.put("appSecret", this.nodeConfig.getAppSecret());
        byte[] bytes = new byte[]{};
        try {
            bytes = HttpsApiUtil.sendJsonToHttpsPost((String)"https://202.61.88.184:19200/wjw/third/oauth/getAccessToken", (String)JSONObject.toJSONString(m), (String)"UTF-8");
        }
        catch (Exception e) {
            log.info("\u8bf7\u6c42\u83b7\u53d6accessToken\u5f02\u5e38");
            return "";
        }
        String s1 = new String(bytes);
        log.info("\u8bf7\u6c42\u83b7\u53d6accessToken\u8fd4\u56de" + s1);
        if (Objects.isNull(s1) || "".equals(s1)) {
            return "";
        }
        JSONObject jSONObject = JSONObject.parseObject((String)s1);
        String data = jSONObject.getString("data");
        JSONObject dataStrObj = JSONObject.parseObject((String)data);
        String accessToken = dataStrObj.getString("accessToken");
        this.redisUtil.set("scAccessToken", (Object)accessToken, 518400L);
        return accessToken;
    }

    private void uploadBeijingPresInfo(List<CanalEntry.Column> afterList, String mainId, String hospitalId) {
        for (CanalEntry.Column column : afterList) {
            BeijingInitDataService beijingInitDataService;
            String name = column.getName();
            String value = column.getValue();
            boolean isUpdated = column.getUpdated();
            logger.info((Object)("beijing data update :" + name + " value :" + value + "is updated" + isUpdated));
            if (!isUpdated || !"item_status".equals(name) || !PRES_FINISH_STATUS.equals(value) || !Objects.nonNull(beijingInitDataService = InitDataServiceFactory.getBeijingInitDataService((String)hospitalId))) continue;
            IUpload iUpload = beijingInitDataService.getClinicInfoByMainIdAndHosId(mainId, hospitalId);
            this.uploadHandler(iUpload);
        }
    }

    private void uploadHuNanPresInfo(List<CanalEntry.Column> afterList, String mainId) {
        for (CanalEntry.Column column : afterList) {
            String name = column.getName();
            String value = column.getValue();
            boolean isUpdated = column.getUpdated();
            logger.info((Object)("hu nan data update :" + name + " value :" + value + "is updated" + isUpdated));
            if (isUpdated && "item_status".equals(name) && PRES_PAY_STATUS.equals(value)) {
                IUpload iUpload = this.huNanInitDataService.getRecipeIndicatorsInfo(mainId);
                this.uploadHandler(iUpload);
                IUpload presChargeInfoUpload = this.huNanInitDataService.getPresChargeInfo(mainId);
                this.uploadHandler(presChargeInfoUpload);
                break;
            }
            if (!isUpdated || !"item_status".equals(name) || !PRES_FINISH_STATUS.equals(value)) continue;
            IUpload iUpload = this.huNanInitDataService.getRecipeVerification(mainId);
            this.uploadHandler(iUpload);
            break;
        }
    }

    private boolean uploadHandler(IUpload iUpload) {
        if (Objects.isNull(iUpload)) {
            log.info("\u672a\u67e5\u5230\u4e1a\u52a1\u6570\u636e\uff0c\u4e0a\u4f20\u5931\u8d25");
            return false;
        }
        boolean flag = iUpload.dataStorage();
        if (flag) {
            iUpload.dataUpload();
        }
        return false;
    }

    private <T> boolean hebeiUploadHandler(T t, HeBeiUpload iUpload) {
        String deptInfos = iUpload.getData();
        Gson gson = new Gson();
        Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
        List list = (List)gson.fromJson(deptInfos, type);
        for (Object t1 : list) {
            Gson json = new Gson();
            String jsonData = json.toJson(t1);
            iUpload.setData(jsonData);
            boolean flag = iUpload.dataStorage();
            if (!flag) continue;
            iUpload.dataUpload();
        }
        if (Objects.isNull(iUpload)) {
            log.info("\u672a\u67e5\u5230\u4e1a\u52a1\u6570\u636e\uff0c\u4e0a\u4f20\u5931\u8d25");
            return false;
        }
        boolean flag = iUpload.dataStorage();
        if (flag) {
            iUpload.dataUpload();
        }
        return false;
    }
}

