/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.data.business.upload.reservation;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.data.business.upload.reservation.IStorage;
import com.ebaiyihui.data.business.upload.reservation.IUpload;
import com.ebaiyihui.data.business.upload.reservation.UploadFactory;
import com.ebaiyihui.data.business.upload.reservation.bo.HeNanHospitalInfo;
import com.ebaiyihui.data.business.upload.reservation.enums.DataFormatEnum;
import com.ebaiyihui.data.business.upload.reservation.enums.RegulatoryEnum;
import com.ebaiyihui.data.business.upload.reservation.enums.RequestMethodEnum;
import com.ebaiyihui.data.business.upload.reservation.enums.RequestModeEnum;
import com.ebaiyihui.data.business.upload.reservation.enums.StorageEnum;
import com.ebaiyihui.data.business.upload.reservation.enums.UploadStatusEnum;
import com.ebaiyihui.data.canal.SpringUtils;
import com.ebaiyihui.data.pojo.entity.UploadResultEntity;
import com.ebaiyihui.data.pojo.vo.hn.UploadResultVo;
import com.ebaiyihui.data.service.lyzx.HeNanResultService;
import com.ebaiyihui.data.service.lyzx.impl.HeNanResultServiceImpl;
import com.ebaiyihui.framework.response.BaseResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.http.MediaType;

public class HeNanUpload
implements IUpload {
    @Autowired
    private HeNanResultService heNanResultService;
    private MediaType mediaType = MediaType.TEXT_XML;
    private String modeEnum = RequestModeEnum.WEBSERVICE.toString();
    private String requestEnum = RequestMethodEnum.Front.toString();
    private String regulatoryEnum = RegulatoryEnum.HENAN.toString();
    private String storageEnum = StorageEnum.MONGO.toString();
    private String data;
    private String hosName;
    private String serviceMethod;
    private HeNanHospitalInfo hospitalInfo;
    private String uniqueId;
    private String COLLECTION_NAME = "henan_log";

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public String getModeEnum() {
        return this.modeEnum;
    }

    public String getRequestEnum() {
        return this.requestEnum;
    }

    public String getRegulatoryEnum() {
        return this.regulatoryEnum;
    }

    public String getStorageEnum() {
        return this.storageEnum;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getServiceMethod() {
        return this.serviceMethod;
    }

    public void setServiceMethod(String serviceMethod) {
        this.serviceMethod = serviceMethod;
    }

    public String getHosName() {
        return this.hosName;
    }

    public void setHosName(String hosName) {
        this.hosName = hosName;
    }

    public boolean dataStorage() {
        if (!StringUtils.isEmpty((String)this.data)) {
            this.uniqueId = UploadFactory.getStorageType((String)this.storageEnum).dataStorage(this.data, DataFormatEnum.xml.toString(), this.COLLECTION_NAME);
            return true;
        }
        return false;
    }

    public void dataUpload() {
        BaseResponse b = UploadFactory.getUploadType((String)this.requestEnum).dataUpload((IUpload)this);
        IStorage istorage = UploadFactory.getStorageType((String)this.storageEnum);
        List uploadResultVos = (List)b.getData();
        List userList = JSON.parseArray((String)JSON.toJSONString((Object)uploadResultVos), UploadResultVo.class);
        for (UploadResultVo uploadResultVo : userList) {
            UploadResultEntity uploadResultEntity = new UploadResultEntity();
            BeanUtils.copyProperties((Object)uploadResultVo, (Object)uploadResultEntity);
            ApplicationContext applicationContext = SpringUtils.getApplicationContext();
            HeNanResultService heNanResultService = (HeNanResultService)applicationContext.getBean(HeNanResultServiceImpl.class);
            heNanResultService.insert(uploadResultEntity);
        }
        if ("1".equals(b.getCode())) {
            istorage.dataUpdate(this.uniqueId, UploadStatusEnum.success.toString());
        }
        istorage.dataUpdate(this.uniqueId, UploadStatusEnum.error.toString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        sb.append(",\"modeEnum\":\"").append(this.modeEnum).append('\"');
        sb.append(",\"requestEnum\":\"").append(this.requestEnum).append('\"');
        sb.append(",\"regulatoryEnum\":\"").append(this.regulatoryEnum).append('\"');
        sb.append(",\"storageEnum\":\"").append(this.storageEnum).append('\"');
        sb.append(",\"hosName\":\"").append(this.hosName).append('\"');
        sb.append(",\"serviceMethod\":\"").append(this.serviceMethod).append('\"');
        sb.append(",\"username\":\"").append(this.hospitalInfo.getUsername()).append('\"');
        sb.append(",\"password\":\"").append(this.hospitalInfo.getPassword()).append('\"');
        sb.append(",\"hospitalUrl\":\"").append(this.hospitalInfo.getHospitalUrl()).append('\"');
        sb.append(",\"frontUrl\":\"").append(this.hospitalInfo.getFrontUrl()).append('\"');
        sb.append('}');
        return sb.toString();
    }

    public Map<String, Object> format() {
        this.hospitalInfo = new HeNanHospitalInfo(this.hosName);
        Map map = (Map)JSONObject.parseObject((String)this.toString(), Map.class);
        ArrayList<MediaType> mediaTypeList = new ArrayList<MediaType>();
        mediaTypeList.add(this.mediaType);
        map.put("mediaType", MediaType.toString(mediaTypeList));
        map.put("data", this.data);
        return map;
    }
}

