/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.data.business.upload.reservation;

import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.data.business.upload.reservation.IStorage;
import com.ebaiyihui.data.business.upload.reservation.IUpload;
import com.ebaiyihui.data.business.upload.reservation.UploadFactory;
import com.ebaiyihui.data.business.upload.reservation.bo.HuNanHospitalInfo;
import com.ebaiyihui.data.business.upload.reservation.enums.DataFormatEnum;
import com.ebaiyihui.data.business.upload.reservation.enums.RegulatoryEnum;
import com.ebaiyihui.data.business.upload.reservation.enums.RequestMethodEnum;
import com.ebaiyihui.data.business.upload.reservation.enums.RequestModeEnum;
import com.ebaiyihui.data.business.upload.reservation.enums.StorageEnum;
import com.ebaiyihui.data.business.upload.reservation.enums.UploadStatusEnum;
import com.ebaiyihui.framework.response.BaseResponse;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.http.MediaType;

public class HuNanUpload
implements IUpload {
    private MediaType mediaType = MediaType.APPLICATION_JSON;
    private String modeEnum = RequestModeEnum.HTTP.toString();
    private String requestEnum = RequestMethodEnum.Front.toString();
    private String regulatoryEnum = RegulatoryEnum.HUNAN.toString();
    private String storageEnum = StorageEnum.MONGO.toString();
    private String data;
    private String hosName;
    private String serviceMethod;
    private String serviceMethodSign;
    private HuNanHospitalInfo hospitalInfo;
    private String uniqueId;
    private String COLLECTION_NAME = "hunan_log";

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public String getModeEnum() {
        return this.modeEnum;
    }

    public String getRequestEnum() {
        return this.requestEnum;
    }

    public String getRegulatoryEnum() {
        return this.regulatoryEnum;
    }

    public String getStorageEnum() {
        return this.storageEnum;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getServiceMethodSign() {
        return this.serviceMethodSign;
    }

    public void setServiceMethodSign(String serviceMethodSign) {
        this.serviceMethodSign = serviceMethodSign;
    }

    public String getServiceMethod() {
        return this.serviceMethod;
    }

    public void setServiceMethod(String serviceMethod) {
        this.serviceMethod = serviceMethod;
    }

    public String getHosName() {
        return this.hosName;
    }

    public void setHosName(String hosName) {
        this.hosName = hosName;
    }

    public boolean dataStorage() {
        if (StringUtils.isNotBlank((String)this.data)) {
            this.uniqueId = UploadFactory.getStorageType((String)this.storageEnum).dataStorage(this.data, DataFormatEnum.json.toString(), this.COLLECTION_NAME);
            return true;
        }
        return false;
    }

    public void dataUpload() {
        BaseResponse b = UploadFactory.getUploadType((String)this.requestEnum).dataUpload((IUpload)this);
        IStorage istorage = UploadFactory.getStorageType((String)this.storageEnum);
        if ("1".equals(b.getCode())) {
            istorage.dataUpdate(this.uniqueId, UploadStatusEnum.success.toString());
        }
        istorage.dataUpdate(this.uniqueId, UploadStatusEnum.error.toString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        sb.append(",\"modeEnum\":\"").append(this.modeEnum).append('\"');
        sb.append(",\"requestEnum\":\"").append(this.requestEnum).append('\"');
        sb.append(",\"regulatoryEnum\":\"").append(this.regulatoryEnum).append('\"');
        sb.append(",\"storageEnum\":\"").append(this.storageEnum).append('\"');
        sb.append(",\"hosName\":\"").append(this.hosName).append('\"');
        sb.append(",\"serviceMethod\":\"").append(this.serviceMethod).append('\"');
        sb.append(",\"serviceMethodSign\":\"").append(this.serviceMethodSign).append('\"');
        sb.append(",\"appCode\":\"").append(this.hospitalInfo.getAppCode()).append('\"');
        sb.append(",\"digestUrl\":\"").append(this.hospitalInfo.getDigestUrl()).append('\"');
        sb.append(",\"hospitalUrl\":\"").append(this.hospitalInfo.getHospitalUrl()).append('\"');
        sb.append(",\"frontUrl\":\"").append(this.hospitalInfo.getFrontUrl()).append('\"');
        sb.append(",\"hlwyljgdm\":\"").append(this.hospitalInfo.getHlwyljgdm()).append('\"');
        sb.append(",\"requestId\":\"").append(this.hospitalInfo.getRequestId()).append('\"');
        sb.append(",\"timestamp\":\"").append(this.hospitalInfo.getTimestamp()).append('\"');
        sb.append(",\"key\":\"").append(this.hospitalInfo.getKey()).append('\"');
        sb.append('}');
        return sb.toString();
    }

    public Map<String, Object> format() {
        this.hospitalInfo = new HuNanHospitalInfo(this.hosName);
        Map map = (Map)JSONObject.parseObject((String)this.toString(), Map.class);
        ArrayList<MediaType> mediaTypeList = new ArrayList<MediaType>();
        mediaTypeList.add(this.mediaType);
        map.put("mediaType", MediaType.toString(mediaTypeList));
        map.put("data", this.data);
        return map;
    }

    public HuNanHospitalInfo getHospitalInfo() {
        return this.hospitalInfo;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public String getCOLLECTION_NAME() {
        return this.COLLECTION_NAME;
    }

    public void setMediaType(MediaType mediaType) {
        this.mediaType = mediaType;
    }

    public void setModeEnum(String modeEnum) {
        this.modeEnum = modeEnum;
    }

    public void setRequestEnum(String requestEnum) {
        this.requestEnum = requestEnum;
    }

    public void setRegulatoryEnum(String regulatoryEnum) {
        this.regulatoryEnum = regulatoryEnum;
    }

    public void setStorageEnum(String storageEnum) {
        this.storageEnum = storageEnum;
    }

    public void setHospitalInfo(HuNanHospitalInfo hospitalInfo) {
        this.hospitalInfo = hospitalInfo;
    }

    public void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    public void setCOLLECTION_NAME(String COLLECTION_NAME) {
        this.COLLECTION_NAME = COLLECTION_NAME;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HuNanUpload)) {
            return false;
        }
        HuNanUpload other = (HuNanUpload)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        MediaType this$mediaType = this.getMediaType();
        MediaType other$mediaType = other.getMediaType();
        if (this$mediaType == null ? other$mediaType != null : !this$mediaType.equals(other$mediaType)) {
            return false;
        }
        String this$modeEnum = this.getModeEnum();
        String other$modeEnum = other.getModeEnum();
        if (this$modeEnum == null ? other$modeEnum != null : !this$modeEnum.equals(other$modeEnum)) {
            return false;
        }
        String this$requestEnum = this.getRequestEnum();
        String other$requestEnum = other.getRequestEnum();
        if (this$requestEnum == null ? other$requestEnum != null : !this$requestEnum.equals(other$requestEnum)) {
            return false;
        }
        String this$regulatoryEnum = this.getRegulatoryEnum();
        String other$regulatoryEnum = other.getRegulatoryEnum();
        if (this$regulatoryEnum == null ? other$regulatoryEnum != null : !this$regulatoryEnum.equals(other$regulatoryEnum)) {
            return false;
        }
        String this$storageEnum = this.getStorageEnum();
        String other$storageEnum = other.getStorageEnum();
        if (this$storageEnum == null ? other$storageEnum != null : !this$storageEnum.equals(other$storageEnum)) {
            return false;
        }
        String this$data = this.getData();
        String other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        String this$hosName = this.getHosName();
        String other$hosName = other.getHosName();
        if (this$hosName == null ? other$hosName != null : !this$hosName.equals(other$hosName)) {
            return false;
        }
        String this$serviceMethod = this.getServiceMethod();
        String other$serviceMethod = other.getServiceMethod();
        if (this$serviceMethod == null ? other$serviceMethod != null : !this$serviceMethod.equals(other$serviceMethod)) {
            return false;
        }
        String this$serviceMethodSign = this.getServiceMethodSign();
        String other$serviceMethodSign = other.getServiceMethodSign();
        if (this$serviceMethodSign == null ? other$serviceMethodSign != null : !this$serviceMethodSign.equals(other$serviceMethodSign)) {
            return false;
        }
        HuNanHospitalInfo this$hospitalInfo = this.getHospitalInfo();
        HuNanHospitalInfo other$hospitalInfo = other.getHospitalInfo();
        if (this$hospitalInfo == null ? other$hospitalInfo != null : !this$hospitalInfo.equals(other$hospitalInfo)) {
            return false;
        }
        String this$uniqueId = this.getUniqueId();
        String other$uniqueId = other.getUniqueId();
        if (this$uniqueId == null ? other$uniqueId != null : !this$uniqueId.equals(other$uniqueId)) {
            return false;
        }
        String this$COLLECTION_NAME = this.getCOLLECTION_NAME();
        String other$COLLECTION_NAME = other.getCOLLECTION_NAME();
        return !(this$COLLECTION_NAME == null ? other$COLLECTION_NAME != null : !this$COLLECTION_NAME.equals(other$COLLECTION_NAME));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HuNanUpload;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MediaType $mediaType = this.getMediaType();
        result = result * 59 + ($mediaType == null ? 43 : $mediaType.hashCode());
        String $modeEnum = this.getModeEnum();
        result = result * 59 + ($modeEnum == null ? 43 : $modeEnum.hashCode());
        String $requestEnum = this.getRequestEnum();
        result = result * 59 + ($requestEnum == null ? 43 : $requestEnum.hashCode());
        String $regulatoryEnum = this.getRegulatoryEnum();
        result = result * 59 + ($regulatoryEnum == null ? 43 : $regulatoryEnum.hashCode());
        String $storageEnum = this.getStorageEnum();
        result = result * 59 + ($storageEnum == null ? 43 : $storageEnum.hashCode());
        String $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        String $hosName = this.getHosName();
        result = result * 59 + ($hosName == null ? 43 : $hosName.hashCode());
        String $serviceMethod = this.getServiceMethod();
        result = result * 59 + ($serviceMethod == null ? 43 : $serviceMethod.hashCode());
        String $serviceMethodSign = this.getServiceMethodSign();
        result = result * 59 + ($serviceMethodSign == null ? 43 : $serviceMethodSign.hashCode());
        HuNanHospitalInfo $hospitalInfo = this.getHospitalInfo();
        result = result * 59 + ($hospitalInfo == null ? 43 : $hospitalInfo.hashCode());
        String $uniqueId = this.getUniqueId();
        result = result * 59 + ($uniqueId == null ? 43 : $uniqueId.hashCode());
        String $COLLECTION_NAME = this.getCOLLECTION_NAME();
        result = result * 59 + ($COLLECTION_NAME == null ? 43 : $COLLECTION_NAME.hashCode());
        return result;
    }
}

