/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.data.business.upload.reservation;

import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.data.business.upload.reservation.IStorage;
import com.ebaiyihui.data.business.upload.reservation.IUpload;
import com.ebaiyihui.data.business.upload.reservation.UploadFactory;
import com.ebaiyihui.data.business.upload.reservation.bo.JxHospitalInfo;
import com.ebaiyihui.data.business.upload.reservation.enums.DataFormatEnum;
import com.ebaiyihui.data.business.upload.reservation.enums.RegulatoryEnum;
import com.ebaiyihui.data.business.upload.reservation.enums.RequestMethodEnum;
import com.ebaiyihui.data.business.upload.reservation.enums.RequestModeEnum;
import com.ebaiyihui.data.business.upload.reservation.enums.StorageEnum;
import com.ebaiyihui.data.business.upload.reservation.enums.UploadStatusEnum;
import com.ebaiyihui.framework.response.BaseResponse;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.http.MediaType;

public class JxUpload
implements IUpload {
    private MediaType mediaType = MediaType.APPLICATION_JSON;
    private String modeEnum = RequestModeEnum.HTTP.toString();
    private String requestEnum = RequestMethodEnum.Front.toString();
    private String regulatoryEnum = RegulatoryEnum.JIANGXI.toString();
    private String storageEnum = StorageEnum.MONGO.toString();
    private String data;
    private String hospitalId;
    private String serviceId;
    private String serviceMethod;
    private JxHospitalInfo hospitalInfo;
    private String uniqueId;
    private String COLLECTION_NAME = "jiangxi_log";

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public String getModeEnum() {
        return this.modeEnum;
    }

    public String getRequestEnum() {
        return this.requestEnum;
    }

    public String getRegulatoryEnum() {
        return this.regulatoryEnum;
    }

    public String getStorageEnum() {
        return this.storageEnum;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public String getServiceMethod() {
        return this.serviceMethod;
    }

    public void setServiceMethod(String serviceMethod) {
        this.serviceMethod = serviceMethod;
    }

    public String getHospitalId() {
        return this.hospitalId;
    }

    public void setHospitalId(String hospitalId) {
        this.hospitalId = hospitalId;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        sb.append(",\"modeEnum\":\"").append(this.modeEnum).append('\"');
        sb.append(",\"requestEnum\":\"").append(this.requestEnum).append('\"');
        sb.append(",\"regulatoryEnum\":\"").append(this.regulatoryEnum).append('\"');
        sb.append(",\"storageEnum\":\"").append(this.storageEnum).append('\"');
        sb.append(",\"hospitalId\":\"").append(this.hospitalId).append('\"');
        sb.append(",\"appKey\":\"").append(this.hospitalInfo.getAppKey()).append('\"');
        sb.append(",\"appSecret\":\"").append(this.hospitalInfo.getAppSecret()).append('\"');
        sb.append(",\"serviceId\":\"").append(this.serviceId).append('\"');
        sb.append(",\"serviceMethod\":\"").append(this.serviceMethod).append('\"');
        sb.append(",\"hospitalUrl\":\"").append(this.hospitalInfo.getHospitalUrl()).append('\"');
        sb.append(",\"frontUrl\":\"").append(this.hospitalInfo.getFrontUrl()).append('\"');
        sb.append(",\"tokenUrl\":\"").append(this.hospitalInfo.getTokenUrl()).append('\"');
        sb.append(",\"hos_id\":\"").append(this.hospitalInfo.getHos_id()).append('\"');
        sb.append(",\"notifyUrl\":\"").append(this.hospitalInfo.getNotifyUrl()).append('\"');
        sb.append('}');
        return sb.toString();
    }

    public boolean dataStorage() {
        if (!StringUtils.isEmpty((String)this.data)) {
            this.uniqueId = UploadFactory.getStorageType((String)this.storageEnum).dataStorage(this.data, DataFormatEnum.json.toString(), this.COLLECTION_NAME);
            return true;
        }
        return false;
    }

    public void dataUpload() {
        BaseResponse b = UploadFactory.getUploadType((String)this.requestEnum).dataUpload((IUpload)this);
        IStorage istorage = UploadFactory.getStorageType((String)this.storageEnum);
        if ("1".equals(b.getCode())) {
            istorage.dataUpdate(this.uniqueId, UploadStatusEnum.success.toString());
        } else {
            istorage.dataUpdate(this.uniqueId, UploadStatusEnum.error.toString());
        }
    }

    public Map<String, Object> format() {
        this.hospitalInfo = new JxHospitalInfo(this.hospitalId);
        Map map = (Map)JSONObject.parseObject((String)this.toString(), Map.class);
        ArrayList<MediaType> mediaTypeList = new ArrayList<MediaType>();
        mediaTypeList.add(this.mediaType);
        map.put("mediaType", MediaType.toString(mediaTypeList));
        map.put("data", this.data);
        return map;
    }
}

