/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.data.business.upload.reservation;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.data.business.upload.reservation.IStorage;
import com.ebaiyihui.data.business.upload.reservation.UploadFactory;
import com.ebaiyihui.data.business.upload.reservation.enums.DataFormatEnum;
import com.ebaiyihui.data.business.upload.reservation.enums.StorageEnum;
import com.ebaiyihui.data.business.upload.reservation.enums.UploadStatusEnum;
import com.ebaiyihui.data.business.upload.util.MongoDBFactory;
import com.ebaiyihui.data.business.upload.util.XmlUtil;
import com.ebaiyihui.data.dao.UploadRecordMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MongoStorage
implements IStorage,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(MongoStorage.class);
    @Autowired
    private UploadRecordMapper uploadRecordMapper;
    private String typeName = StorageEnum.MONGO.toString();
    private String MONGODB_NAME = "platform_upload_log";

    public void afterPropertiesSet() {
        UploadFactory.registerStorageType((String)this.typeName, (IStorage)this);
    }

    public String dataStorage(String data, String dataFormat, String collectionName) {
        String uniqueId = UUID.randomUUID().toString();
        try {
            List tempList = new ArrayList<String>();
            ArrayList<String> mongoList = new ArrayList<String>();
            if (dataFormat.equals(DataFormatEnum.xml.toString())) {
                tempList.add(JSONObject.toJSONString((Object)XmlUtil.convertStringXmlToMap((String)data)));
            } else if (data.startsWith("{")) {
                tempList.add(data);
            } else {
                tempList = JSONArray.parseArray((String)data, String.class);
            }
            MongoDBFactory mongoDBFactory = new MongoDBFactory(this.MONGODB_NAME);
            for (int i = 0; i < tempList.size(); ++i) {
                JSONObject jsonObject = JSONObject.parseObject((String)((String)tempList.get(i)));
                jsonObject.put("uniqueId", (Object)uniqueId);
                mongoList.add(jsonObject.toJSONString());
            }
            mongoDBFactory.insert(collectionName, mongoList);
            this.uploadRecordMapper.insertOne(uniqueId, UploadStatusEnum.uploading.toString());
        }
        catch (Exception e) {
            log.error("save upload data error,e=", (Throwable)e);
        }
        return uniqueId;
    }

    public void dataUpdate(String uniqueId, String status) {
        this.uploadRecordMapper.updateOne(uniqueId, status);
    }
}

