/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.data.business.upload.reservation.bo;

import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.data.business.upload.util.MongoDBFactory;
import java.util.HashMap;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HuNanHospitalInfo {
    private static final Logger log = LoggerFactory.getLogger(HuNanHospitalInfo.class);
    private String hospitalUrl;
    private String frontUrl;
    private String digestUrl;
    private String appCode;
    private String hlwyljgdm;
    private String requestId;
    private String timestamp;
    private String key;
    private String yljgdm;

    public HuNanHospitalInfo() {
    }

    public HuNanHospitalInfo(String hosName) {
        MongoDBFactory mongoDBFactory = new MongoDBFactory("hos_info_config");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("hos_name", hosName);
        String data = mongoDBFactory.findOne("config", map);
        log.info("get HuNanHospitalInfo data =" + data);
        HuNanHospitalInfo huNanHospitalInfo = (HuNanHospitalInfo)JSONObject.parseObject((String)data, HuNanHospitalInfo.class);
        this.hospitalUrl = huNanHospitalInfo.getHospitalUrl();
        this.frontUrl = huNanHospitalInfo.getFrontUrl();
        this.digestUrl = huNanHospitalInfo.getDigestUrl();
        this.appCode = huNanHospitalInfo.getAppCode();
        this.hlwyljgdm = huNanHospitalInfo.getHlwyljgdm();
        this.requestId = UUID.randomUUID().toString().replace("-", "");
        this.timestamp = String.valueOf(System.currentTimeMillis());
        this.key = huNanHospitalInfo.getKey();
    }

    public String getHospitalUrl() {
        return this.hospitalUrl;
    }

    public String getFrontUrl() {
        return this.frontUrl;
    }

    public String getDigestUrl() {
        return this.digestUrl;
    }

    public String getAppCode() {
        return this.appCode;
    }

    public String getHlwyljgdm() {
        return this.hlwyljgdm;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public String getKey() {
        return this.key;
    }

    public String getYljgdm() {
        return this.yljgdm;
    }

    public void setHospitalUrl(String hospitalUrl) {
        this.hospitalUrl = hospitalUrl;
    }

    public void setFrontUrl(String frontUrl) {
        this.frontUrl = frontUrl;
    }

    public void setDigestUrl(String digestUrl) {
        this.digestUrl = digestUrl;
    }

    public void setAppCode(String appCode) {
        this.appCode = appCode;
    }

    public void setHlwyljgdm(String hlwyljgdm) {
        this.hlwyljgdm = hlwyljgdm;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setYljgdm(String yljgdm) {
        this.yljgdm = yljgdm;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HuNanHospitalInfo)) {
            return false;
        }
        HuNanHospitalInfo other = (HuNanHospitalInfo)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$hospitalUrl = this.getHospitalUrl();
        String other$hospitalUrl = other.getHospitalUrl();
        if (this$hospitalUrl == null ? other$hospitalUrl != null : !this$hospitalUrl.equals(other$hospitalUrl)) {
            return false;
        }
        String this$frontUrl = this.getFrontUrl();
        String other$frontUrl = other.getFrontUrl();
        if (this$frontUrl == null ? other$frontUrl != null : !this$frontUrl.equals(other$frontUrl)) {
            return false;
        }
        String this$digestUrl = this.getDigestUrl();
        String other$digestUrl = other.getDigestUrl();
        if (this$digestUrl == null ? other$digestUrl != null : !this$digestUrl.equals(other$digestUrl)) {
            return false;
        }
        String this$appCode = this.getAppCode();
        String other$appCode = other.getAppCode();
        if (this$appCode == null ? other$appCode != null : !this$appCode.equals(other$appCode)) {
            return false;
        }
        String this$hlwyljgdm = this.getHlwyljgdm();
        String other$hlwyljgdm = other.getHlwyljgdm();
        if (this$hlwyljgdm == null ? other$hlwyljgdm != null : !this$hlwyljgdm.equals(other$hlwyljgdm)) {
            return false;
        }
        String this$requestId = this.getRequestId();
        String other$requestId = other.getRequestId();
        if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
            return false;
        }
        String this$timestamp = this.getTimestamp();
        String other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !this$timestamp.equals(other$timestamp)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$yljgdm = this.getYljgdm();
        String other$yljgdm = other.getYljgdm();
        return !(this$yljgdm == null ? other$yljgdm != null : !this$yljgdm.equals(other$yljgdm));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HuNanHospitalInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $hospitalUrl = this.getHospitalUrl();
        result = result * 59 + ($hospitalUrl == null ? 43 : $hospitalUrl.hashCode());
        String $frontUrl = this.getFrontUrl();
        result = result * 59 + ($frontUrl == null ? 43 : $frontUrl.hashCode());
        String $digestUrl = this.getDigestUrl();
        result = result * 59 + ($digestUrl == null ? 43 : $digestUrl.hashCode());
        String $appCode = this.getAppCode();
        result = result * 59 + ($appCode == null ? 43 : $appCode.hashCode());
        String $hlwyljgdm = this.getHlwyljgdm();
        result = result * 59 + ($hlwyljgdm == null ? 43 : $hlwyljgdm.hashCode());
        String $requestId = this.getRequestId();
        result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
        String $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : $timestamp.hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $yljgdm = this.getYljgdm();
        result = result * 59 + ($yljgdm == null ? 43 : $yljgdm.hashCode());
        return result;
    }

    public String toString() {
        return "HuNanHospitalInfo(hospitalUrl=" + this.getHospitalUrl() + ", frontUrl=" + this.getFrontUrl() + ", digestUrl=" + this.getDigestUrl() + ", appCode=" + this.getAppCode() + ", hlwyljgdm=" + this.getHlwyljgdm() + ", requestId=" + this.getRequestId() + ", timestamp=" + this.getTimestamp() + ", key=" + this.getKey() + ", yljgdm=" + this.getYljgdm() + ")";
    }
}

