/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.data.business.upload.util;

import com.ebaiyihui.data.business.upload.util.EnvironmentAlone;
import com.mongodb.BasicDBObject;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.util.JSON;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongoDBFactory {
    private static final String MONGODB_PREFIX = "mongodb://";
    private static Logger logger = Logger.getLogger(MongoDBFactory.class);
    private static MongoClient normalClient;
    private MongoClient client;
    private String dbName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void init() {
        if (this.client != null) {
            return;
        }
        Class<MongoDBFactory> clazz = MongoDBFactory.class;
        // MONITORENTER : com.ebaiyihui.data.business.upload.util.MongoDBFactory.class
        if (normalClient == null) {
            Class<MongoDBFactory> clazz2 = MongoDBFactory.class;
            // MONITORENTER : com.ebaiyihui.data.business.upload.util.MongoDBFactory.class
            String userName = EnvironmentAlone.getInstance().getEnvironmentParam("mongo.userName");
            String password = EnvironmentAlone.getInstance().getEnvironmentParam("mongo.password");
            String url = EnvironmentAlone.getInstance().getEnvironmentParam("mongo.url");
            String address = MONGODB_PREFIX + userName + ":" + password + "@" + url;
            logger.info((Object)("get mongo address =" + address));
            normalClient = MongoClients.create((String)address);
            // MONITOREXIT : clazz2
        }
        this.client = normalClient;
        // MONITOREXIT : clazz
    }

    public MongoDBFactory(String dbName) {
        this.dbName = dbName;
        this.init();
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public void insert(String collectionName, String value) {
        MongoCollection collection = this.client.getDatabase(this.dbName).getCollection(collectionName);
        collection.insertOne((Object)Document.parse((String)value));
    }

    public void insert(String collectionName, List<String> values) {
        MongoCollection collection = this.client.getDatabase(this.dbName).getCollection(collectionName);
        ArrayList<Document> documents = new ArrayList<Document>(values.size());
        for (String value : values) {
            documents.add(Document.parse((String)value));
        }
        collection.insertMany(documents);
    }

    public void update(String collectionName, String wheredoc, String updatedoc) {
        MongoCollection collection = this.client.getDatabase(this.dbName).getCollection(collectionName);
        collection.updateOne((Bson)JSON.parse((String)wheredoc), (Bson)new Document("$set", JSON.parse((String)updatedoc)));
    }

    public void delete(String collectionName, Map<String, Object> pattern) {
        MongoCollection collection = this.client.getDatabase(this.dbName).getCollection(collectionName);
        Document document = new Document();
        for (String key : pattern.keySet()) {
            document.put(key, pattern.get(key));
        }
        collection.deleteMany((Bson)document);
    }

    public List<String> findList(String collectionName, Map<String, Object> pattern) {
        MongoCollection collection = this.client.getDatabase(this.dbName).getCollection(collectionName);
        BasicDBObject physics = new BasicDBObject(pattern);
        FindIterable documents = collection.find((Bson)physics);
        LinkedList<String> result = new LinkedList<String>();
        for (Document document : documents) {
            result.add(document.toJson());
        }
        return result;
    }

    public String findOne(String collectionName, Map<String, Object> pattern) {
        BasicDBObject physics;
        MongoCollection collection = this.client.getDatabase(this.dbName).getCollection(collectionName);
        FindIterable documents = collection.find((Bson)(physics = new BasicDBObject(pattern)));
        MongoCursor mongoCursor = documents.iterator();
        if (mongoCursor.hasNext()) {
            Document doc = (Document)mongoCursor.next();
            return doc.toJson();
        }
        return null;
    }

    public List<String> findAllByColumns(String collectionName, String column1, String column2) {
        MongoCollection collection = this.client.getDatabase(this.dbName).getCollection(collectionName);
        FindIterable documents = collection.find().projection((Bson)new BasicDBObject().append(column1, (Object)1).append(column2, (Object)1));
        LinkedList<String> result = new LinkedList<String>();
        for (Document document : documents) {
            result.add(document.toJson());
        }
        return result;
    }

    public boolean getCollection(String collectionName) {
        return ((ArrayList)this.client.getDatabase(this.dbName).listCollectionNames().into(new ArrayList())).contains(collectionName);
    }
}

