/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.data.canal;

import com.alibaba.otter.canal.client.CanalConnector;
import com.alibaba.otter.canal.client.CanalConnectors;
import com.alibaba.otter.canal.protocol.CanalEntry;
import com.alibaba.otter.canal.protocol.Message;
import com.ebaiyihui.data.canal.IChangeHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class CanalUtils {
    private static final Logger log = LoggerFactory.getLogger(CanalUtils.class);
    private static List<IChangeHandler> changeHandlers;
    private static volatile CanalUtils instance;

    public CanalUtils attachChangeHandler(List<IChangeHandler> handlers) {
        changeHandlers = handlers;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CanalUtils getInstance() {
        if (instance != null) return instance;
        Class<CanalUtils> clazz = CanalUtils.class;
        synchronized (CanalUtils.class) {
            if (instance != null) return instance;
            instance = new CanalUtils();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connServer(String dataBaseIp, String tables, String canalName) {
        CanalConnector connector = CanalConnectors.newSingleConnector((SocketAddress)new InetSocketAddress(dataBaseIp, 11111), (String)canalName, (String)"", (String)"");
        int batchSize = 1000;
        try {
            try {
                connector.connect();
                connector.subscribe(tables);
                connector.rollback();
                while (true) {
                    Long batchId = null;
                    try {
                        Message message = connector.getWithoutAck(batchSize);
                        batchId = message.getId();
                        if (batchId != -1L && message.getEntries().size() != 0) {
                            this.doSync(message.getEntries());
                        }
                        connector.ack(batchId.longValue());
                    }
                    catch (Exception e) {
                        connector.ack(batchId.longValue());
                        log.info("\u5904\u7406\u6570\u636e\u53d1\u9001\u5f02\u5e38", (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                log.info("\u8fde\u63a5canal\u53d1\u9001\u5f02\u5e38\uff1a", (Throwable)e);
                connector.disconnect();
            }
        }
        catch (Throwable throwable) {
            connector.disconnect();
            throw throwable;
        }
    }

    private void doSync(@NotNull List<CanalEntry.Entry> entries) {
        if (!CollectionUtils.isEmpty((Collection)changeHandlers)) {
            for (IChangeHandler changeHandler : changeHandlers) {
                changeHandler.handleChange(entries);
            }
        }
    }
}

