/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.data.canal;

import com.alibaba.otter.canal.protocol.CanalEntry;
import com.ebaiyihui.data.canal.IChangeHandler;
import com.google.protobuf.ByteString;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.apache.log4j.Logger;

public interface ITableChangeHandler
extends IChangeHandler {
    public static final Logger logger = Logger.getLogger(ITableChangeHandler.class);

    default public void handleChange(@NotNull List<CanalEntry.Entry> entryList) {
        for (CanalEntry.Entry entry : entryList) {
            if (entry.getEntryType() == CanalEntry.EntryType.TRANSACTIONBEGIN || entry.getEntryType() == CanalEntry.EntryType.TRANSACTIONEND) continue;
            CanalEntry.RowChange rowChange = null;
            try {
                rowChange = CanalEntry.RowChange.parseFrom((ByteString)entry.getStoreValue());
            }
            catch (Exception e) {
                logger.error((Object)("## ERROR ##, data : " + entry.toString()), (Throwable)e);
            }
            CanalEntry.EventType eventType = rowChange.getEventType();
            logger.info((Object)String.format("================> binlog[%s:%s] , name[%s,%s] , eventType : %s", entry.getHeader().getLogfileName(), entry.getHeader().getLogfileOffset(), entry.getHeader().getSchemaName(), entry.getHeader().getTableName(), eventType));
            for (CanalEntry.RowData rowData : rowChange.getRowDatasList()) {
                if (eventType == CanalEntry.EventType.DELETE) {
                    this.delete(rowData.getBeforeColumnsList(), entry.getHeader().getSchemaName(), entry.getHeader().getTableName());
                    continue;
                }
                if (eventType == CanalEntry.EventType.INSERT) {
                    this.insert(rowData.getAfterColumnsList(), entry.getHeader().getSchemaName(), entry.getHeader().getTableName());
                    continue;
                }
                if (eventType != CanalEntry.EventType.UPDATE) continue;
                this.update(rowData.getBeforeColumnsList(), rowData.getAfterColumnsList(), entry.getHeader().getSchemaName(), entry.getHeader().getTableName());
            }
        }
    }

    public void delete(List<CanalEntry.Column> var1, String var2, String var3);

    public void insert(List<CanalEntry.Column> var1, String var2, String var3);

    public void update(List<CanalEntry.Column> var1, List<CanalEntry.Column> var2, String var3, String var4);
}

