/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.data.controller.beijing;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.data.business.upload.reservation.bo.JxHospitalInfo;
import com.ebaiyihui.data.business.upload.util.MongoDBFactory;
import com.ebaiyihui.data.dao.AdverseRecordMapper;
import com.ebaiyihui.data.dao.JxReceiveInfoMapper;
import com.ebaiyihui.data.pojo.entity.AdverseRecordEntity;
import com.ebaiyihui.data.utils.AesUtils;
import com.ebaiyihui.data.utils.Md5Utils;
import com.ebaiyihui.framework.response.BaseResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/jx"})
public class JxCommonController {
    private static final Logger log = LoggerFactory.getLogger(JxCommonController.class);
    @Autowired
    private JxReceiveInfoMapper jxReceiveInfoMapper;
    @Autowired
    private AdverseRecordMapper adverseRecordMapper;

    @PostMapping(value={"/get_sign"})
    public BaseResponse<String> getSign(@RequestBody JSONObject jsonObject) {
        MongoDBFactory mongoDBFactory = new MongoDBFactory("hos_info_config");
        HashMap<String, String> map = new HashMap<String, String>();
        String hosName = jsonObject.getString("hos_name");
        map.put("hos_name", hosName);
        String data = mongoDBFactory.findOne("config", map);
        JxHospitalInfo jxHospitalInfo = (JxHospitalInfo)JSONObject.parseObject((String)data, JxHospitalInfo.class);
        String appKey = jxHospitalInfo.getAppKey();
        String appSecret = jxHospitalInfo.getAppSecret();
        String dataString = jsonObject.getString("data");
        String resultString = dataString.concat("&secret" + appSecret);
        String aesString = AesUtils.AESEncode((String)resultString, (String)appKey);
        String sign = Md5Utils.encryption((String)aesString).toUpperCase();
        log.info("get jx sign =" + sign);
        return BaseResponse.success((Object)sign);
    }

    @PostMapping(value={"/platform_info/save"})
    public BaseResponse<String> savePlatformInfo(@RequestBody String param) {
        JSONObject jsonObject = JSON.parseObject((String)param);
        JSONArray jsonArray = jsonObject.getJSONArray("data");
        List list = JSONArray.parseArray((String)jsonArray.toJSONString(), Map.class);
        String hospitalId = jsonObject.get((Object)"hos_id").toString();
        log.info("hos_id{}", (Object)hospitalId);
        log.info("jsonObject:{}", (Object)JSON.toJSONString((Object)jsonObject));
        log.info("data:{}", (Object)JSON.toJSONString((Object)jsonArray));
        if (Objects.nonNull(list)) {
            this.jxReceiveInfoMapper.insertList(list, hospitalId);
        }
        return BaseResponse.success();
    }

    @PostMapping(value={"/platform_info/get"})
    public BaseResponse<?> getPlatformInfo(@RequestBody String param) {
        List listMap = JSONArray.parseArray((String)param, Map.class);
        ArrayList<String> paramList = new ArrayList<String>();
        String type = null;
        Iterator iterator = listMap.iterator();
        if (iterator.hasNext()) {
            Map map = (Map)iterator.next();
            type = map.containsKey("cardNumber") ? "cardNumber" : "treNo";
        }
        for (Map map : listMap) {
            paramList.add(map.get(type).toString());
        }
        List listResult = this.jxReceiveInfoMapper.selectList(paramList, type);
        List result = JSONArray.parseArray((String)JSONArray.toJSONString((Object)listResult), String.class);
        return BaseResponse.success((Object)result);
    }

    @PostMapping(value={"/adverse_record/save"})
    public BaseResponse<String> uploadAdverseRecord(@RequestBody String param) {
        AdverseRecordEntity adverseRecordEntity = (AdverseRecordEntity)JSONObject.parseObject((String)param, AdverseRecordEntity.class);
        adverseRecordEntity.setEventId(UUID.randomUUID().toString());
        this.adverseRecordMapper.insertOne(adverseRecordEntity);
        return BaseResponse.success();
    }
}

