/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.data.pojo.vo.sc.base;

import com.ebaiyihui.framework.response.IError;

public class FrontResponse<T> {
    private String transactionId;
    private String code;
    private String errCode;
    private String message;
    private T body;
    public static final String SUCCESS_CODE = "1";
    public static final String FAILED_CODE = "0";

    public static <T> FrontResponse<T> success(String transactionId, T body) {
        FrontResponse response = new FrontResponse();
        response.setTransactionId(transactionId);
        response.setCode(SUCCESS_CODE);
        response.setBody(body);
        return response;
    }

    public static <T> FrontResponse<T> success(String transactionId, T body, String message) {
        FrontResponse response = new FrontResponse();
        response.setTransactionId(transactionId);
        response.setCode(SUCCESS_CODE);
        response.setMessage(message);
        response.setBody(body);
        return response;
    }

    public static <T> FrontResponse<T> error(String transactionId, String errCode, String message) {
        FrontResponse response = new FrontResponse();
        response.setTransactionId(transactionId);
        response.setCode(FAILED_CODE);
        response.setErrCode(errCode);
        response.setMessage(message);
        return response;
    }

    public static <T> FrontResponse<T> error(String transactionId, IError error) {
        FrontResponse response = new FrontResponse();
        response.setTransactionId(transactionId);
        response.setCode(FAILED_CODE);
        response.setErrCode(error.getErrCode());
        response.setMessage(error.getMsg());
        return response;
    }

    public static <T> FrontResponse<T> error(String message) {
        FrontResponse response = new FrontResponse();
        response.setTransactionId("");
        response.setCode(FAILED_CODE);
        response.setErrCode(FAILED_CODE);
        response.setMessage(message);
        return response;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getErrCode() {
        return this.errCode;
    }

    public void setErrCode(String errCode) {
        this.errCode = errCode;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public T getBody() {
        return (T)this.body;
    }

    public void setBody(T body) {
        this.body = body;
    }

    public String toString() {
        return "FrontResponse{transactionId='" + this.transactionId + '\'' + ", code='" + this.code + '\'' + ", errCode='" + this.errCode + '\'' + ", message='" + this.message + '\'' + ", body=" + this.body + '}';
    }
}

