/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.data.schedule;

import com.ebaiyihui.data.business.upload.reservation.IUpload;
import com.ebaiyihui.data.business.upload.reservation.JiangXiIInit;
import com.ebaiyihui.data.business.upload.reservation.SiChuanIInit;
import com.ebaiyihui.data.canal.SpringUtils;
import com.ebaiyihui.data.utils.DateUtils;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;

public class UploadTask {
    private static final Logger log = LoggerFactory.getLogger(UploadTask.class);
    private long oneDay = 86400000L;
    private int hour = 16;
    private int minute = 15;
    private int second = 0;
    private long initDelay = DateUtils.getTime((int)this.hour, (int)this.minute, (int)this.second) - Instant.now().toEpochMilli();
    @Value(value="${config.hospitalId}")
    public String hospitalId;
    @Autowired
    private ScheduledExecutorService scheduledExecutorService;

    public void setHospitalId(String hospitalId) {
        this.hospitalId = hospitalId;
    }

    @PostConstruct
    public void SiChuanUpload() {
        try {
            this.initDelay = this.initDelay > 0L ? this.initDelay : this.oneDay + this.initDelay;
            log.info("task begin times =" + this.initDelay);
            this.scheduledExecutorService.scheduleAtFixedRate(() -> {
                log.info("\u56db\u5ddd\u76d1\u7ba1\u5e73\u53f0hospitalId\uff1a{} UploadReport schedule begin", (Object)this.hospitalId);
                Map map = SpringUtils.getApplicationContext().getBeansOfType(SiChuanIInit.class);
                ArrayList initList = new ArrayList();
                map.forEach((key, value) -> initList.add(value));
                initList.sort(AnnotationAwareOrderComparator.INSTANCE);
                initList.forEach(value -> {
                    IUpload iUpload = value.scDataInit(this.hospitalId);
                    iUpload.dataUpload();
                });
                log.info("\u56db\u5ddd\u76d1\u7ba1\u5e73\u53f0hospitalId\uff1a{} UploadReport schedule end!", (Object)this.hospitalId);
            }, this.initDelay, this.oneDay, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            log.error("\u56db\u5ddd\u76d1\u7ba1\u5e73\u53f0hospitalId\uff1a{},\u5b9a\u65f6\u4efb\u52a1\u62a5\u9519:{}", (Object)this.hospitalId, (Object)e);
            e.printStackTrace();
        }
    }

    public void SiChuanUploadNew() {
        Map map = SpringUtils.getApplicationContext().getBeansOfType(SiChuanIInit.class);
        ArrayList initList = new ArrayList();
        map.forEach((key, value) -> initList.add(value));
        initList.sort(AnnotationAwareOrderComparator.INSTANCE);
        initList.forEach(value -> {
            IUpload iUpload = value.scDataInit(this.hospitalId);
            iUpload.dataUpload();
        });
        log.info("\u56db\u5ddd\u76d1\u7ba1\u5e73\u53f0hospitalId\uff1a{} UploadReport schedule end!", (Object)this.hospitalId);
    }

    public void JDZEYUploadManual() {
        try {
            Map map = SpringUtils.getApplicationContext().getBeansOfType(JiangXiIInit.class);
            ArrayList initList = new ArrayList();
            map.forEach((key, value) -> initList.add(value));
            initList.sort(AnnotationAwareOrderComparator.INSTANCE);
            initList.forEach(value -> {
                IUpload iUpload = value.ndefyDataInit(this.hospitalId);
                boolean flag = iUpload.dataStorage();
                if (flag) {
                    iUpload.dataUpload();
                }
            });
            log.info("\u6c5f\u897f\u76d1\u7ba1\u5e73\u53f0hospitalId\uff1a{} UploadReport schedule end!", (Object)this.hospitalId);
        }
        catch (Exception e) {
            log.error("\u6c5f\u897f\u76d1\u7ba1\u5e73\u53f0hospitalId\uff1a{},\u5b9a\u65f6\u4efb\u52a1\u62a5\u9519:{}", (Object)this.hospitalId, (Object)e);
            e.printStackTrace();
        }
    }
}

