/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.data.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.data.dao.AdmissionHNMapper;
import com.ebaiyihui.data.dao.MainHNMapper;
import com.ebaiyihui.data.pojo.BdOrganization;
import com.ebaiyihui.data.pojo.vo.hn.CollectDataOrgXmlVO;
import com.ebaiyihui.data.pojo.vo.hn.DrugsLists;
import com.ebaiyihui.data.pojo.vo.hn.OrgInfoXmlVO;
import com.ebaiyihui.data.pojo.vo.hn.OutpatientDiagnosisHNVo;
import com.ebaiyihui.data.pojo.vo.hn.OutpatientPrescriptionHNVo;
import com.ebaiyihui.data.pojo.vo.hn.OutpatientRecordHNVo;
import com.ebaiyihui.data.pojo.vo.hn.PatientUserHNVo;
import com.ebaiyihui.data.pojo.vo.hn.ReportXmlHNVo;
import com.ebaiyihui.data.service.AdmissionAndMainHNService;
import com.ebaiyihui.data.service.CrossDatabaseQueryService;
import com.ebaiyihui.data.utils.DateUtils;
import com.ebaiyihui.data.utils.XmlUtil;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.UUIDUtils;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdmissionAndMainServiceHNImpl
implements AdmissionAndMainHNService {
    private static final Logger log = LoggerFactory.getLogger(AdmissionAndMainServiceHNImpl.class);
    @Autowired
    private AdmissionHNMapper admissionHNMapper;
    @Autowired
    private MainHNMapper mainHNMapper;
    @Autowired
    private CrossDatabaseQueryService crossDatabaseQueryService;

    public BaseResponse<String> AdmissionAndMain() {
        List listAdmission = this.admissionHNMapper.getListAdmission("661");
        if (listAdmission.isEmpty()) {
            return BaseResponse.error((String)"\u65e0\u4e0a\u62a5\u6570\u636e\uff01");
        }
        log.info("\u4e0a\u62a5\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString((Object)listAdmission));
        Object exportXml = null;
        ArrayList<String> data = new ArrayList<String>();
        for (String admId : listAdmission) {
            ReportXmlHNVo reportXmlHNVo = new ReportXmlHNVo();
            OutpatientDiagnosisHNVo outpatientDiagnosis = this.admissionHNMapper.getOutpatientDiagnosis(admId);
            List diagnosisLists = this.mainHNMapper.getDiagnosisLists(admId);
            if (0 == diagnosisLists.size()) continue;
            outpatientDiagnosis.setDiagnosisLists(diagnosisLists);
            reportXmlHNVo.setOutpatientDiagnosisHNVo(outpatientDiagnosis);
            PatientUserHNVo patientUser = this.admissionHNMapper.getPatientUser(admId);
            String healthNo = patientUser.getIdentityCardValue().substring(0, 17);
            patientUser.setHealthRecNo(healthNo);
            String birthday = patientUser.getBirthday();
            String newBirthday = DateUtils.strToStr((String)birthday, (String)"yyyy-MM-dd", (String)"yyyyMMdd");
            patientUser.setBirthday(newBirthday);
            reportXmlHNVo.setPatientUserHNVo(patientUser);
            OutpatientRecordHNVo outpatientRecord = this.admissionHNMapper.getOutpatientRecord(admId);
            outpatientRecord.setDiagNo(outpatientRecord.getDiagNo());
            outpatientRecord.setMedInsUscc("12410300416527666M");
            Integer ageYear = DateUtils.getAgeByBirthDates((String)birthday, (String)"yyyy-MM-dd");
            outpatientRecord.setAgeYear(ageYear.toString());
            outpatientRecord.setAgeMonth("1");
            outpatientRecord.setAgeDay("1");
            outpatientRecord.setMedPracticeName(UUIDUtils.getUUID());
            reportXmlHNVo.setOutpatientRecordHNVo(outpatientRecord);
            List outpatientPrescription = this.mainHNMapper.getOutpatientPrescription(admId);
            for (OutpatientPrescriptionHNVo patientPrescription : outpatientPrescription) {
                List drugsLists = this.mainHNMapper.getDrugsLists(admId);
                if (drugsLists.size() == 0) {
                    drugsLists.add(new DrugsLists());
                }
                patientPrescription.setGetDrugOrgCode("12410300416527666M");
                patientPrescription.setGetDrugOrgName("\u6d1b\u9633\u5e02\u4e2d\u5fc3\u533b\u9662");
                patientPrescription.setDrugsLists(drugsLists);
            }
            reportXmlHNVo.setOutpatientPrescriptionHNVo(outpatientPrescription);
            String xml = XmlUtil.converTomXml((Object)reportXmlHNVo);
            data.add(xml);
        }
        return BaseResponse.success((Object)JSONObject.toJSONString(data));
    }

    public String getLyZxOrgXml() {
        BdOrganization organization = this.crossDatabaseQueryService.getById(new Integer("661"));
        if (organization == null) {
            return null;
        }
        CollectDataOrgXmlVO collectDataOrgXmlVO = new CollectDataOrgXmlVO();
        OrgInfoXmlVO orgInfoXmlVO = new OrgInfoXmlVO();
        orgInfoXmlVO.setOrgCode("12410300416527666M");
        orgInfoXmlVO.setOrgName(organization.getOrganName() + "\u4e92\u8054\u7f51\u533b\u9662");
        orgInfoXmlVO.setOrgTypeCode("A100");
        orgInfoXmlVO.setOrgTypeName("\u7efc\u5408\u533b\u9662");
        orgInfoXmlVO.setMedInsUscc("12410300416527666M");
        orgInfoXmlVO.setMedInsName(organization.getOrganName());
        orgInfoXmlVO.setMedInsAddress(organization.getAddress());
        orgInfoXmlVO.setMedInsLpName(organization.getLegalRepresentative());
        orgInfoXmlVO.setIhSafeLv("\u4e09\u7ea7\u7b49\u4fdd");
        orgInfoXmlVO.setAddrState("41");
        orgInfoXmlVO.setAddrCity("03");
        orgInfoXmlVO.setAddrCounty("03");
        orgInfoXmlVO.setAddrTown("\u6c49\u5c6f\u8def\u8857\u9053");
        orgInfoXmlVO.setAddrStreet("\u4e2d\u5dde\u4e2d\u8def");
        orgInfoXmlVO.setAddrHouseNumber("288");
        orgInfoXmlVO.setEconomyTypeCode("110");
        orgInfoXmlVO.setEconomyTypeName("\u56fd\u6709\u5168\u8d44");
        orgInfoXmlVO.setOrgLevelCode("32");
        orgInfoXmlVO.setOrgLevelName("\u4e09\u7ea7\u7532\u7b49");
        orgInfoXmlVO.setIhLegalPerson(organization.getLegalRepresentative());
        orgInfoXmlVO.setStaffNum("2672");
        orgInfoXmlVO.setDepartNum("70");
        collectDataOrgXmlVO.setOrgInfoXmlVO(orgInfoXmlVO);
        String toXml = XmlUtil.converTomXml((Object)collectDataOrgXmlVO);
        return toXml;
    }
}

