/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.data.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.data.dao.AdmissionJXMapper;
import com.ebaiyihui.data.dao.PatientBaseDataMapper;
import com.ebaiyihui.data.pojo.vo.jx.OrganInfo;
import com.ebaiyihui.data.pojo.vo.jx.PatientInfoListJX16VO;
import com.ebaiyihui.data.pojo.vo.sh.Area;
import com.ebaiyihui.data.pojo.vo.sh.JxAreaCode;
import com.ebaiyihui.data.service.PatientBaseDataService;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PatientBaseDataServiceImp
implements PatientBaseDataService {
    private static final Logger log = LoggerFactory.getLogger(PatientBaseDataServiceImp.class);
    @Autowired
    private PatientBaseDataMapper patientBaseDataMapper;
    @Autowired
    private AdmissionJXMapper admissionJXMapper;

    public List<PatientInfoListJX16VO> uploadPatientInfo(String hospitalId) {
        List<PatientInfoListJX16VO> patientInfoListJX16VOS = new ArrayList();
        OrganInfo organInfo = this.admissionJXMapper.getOrganInfo(hospitalId);
        patientInfoListJX16VOS = this.patientBaseDataMapper.selectNDPatientData(hospitalId);
        patientInfoListJX16VOS.forEach(x -> {
            if (!Objects.equals("36", x.getProvinceCode())) {
                String areaCode = organInfo.getDistrict();
                x.setProvinceCode(areaCode.substring(0, 2));
                x.setCityCode(areaCode.substring(0, 4));
                x.setAreaCode(areaCode);
            }
        });
        return patientInfoListJX16VOS;
    }

    public List<PatientInfoListJX16VO> getAreaByCode(List<PatientInfoListJX16VO> patientInfoListJX16VOList) {
        ArrayList<PatientInfoListJX16VO> listJX16VOS = new ArrayList<PatientInfoListJX16VO>();
        patientInfoListJX16VOList.forEach(patientInfoListJX16VO -> {
            String cardNumber = patientInfoListJX16VO.getCardNumber();
            String provinceCode = patientInfoListJX16VO.getCardNumber().substring(0, 2);
            String cityCode = patientInfoListJX16VO.getCardNumber().substring(0, 4);
            String areaCode = patientInfoListJX16VO.getCardNumber().substring(0, 6);
            JxAreaCode provinceCodeVO = this.patientBaseDataMapper.selectByCode(Integer.valueOf(provinceCode).intValue());
            JxAreaCode cityCodeVO = this.patientBaseDataMapper.selectByCode(Integer.valueOf(cityCode).intValue());
            JxAreaCode areaCodeVO = this.patientBaseDataMapper.selectByCode(Integer.valueOf(areaCode).intValue());
            if (Objects.nonNull(provinceCodeVO) && Objects.nonNull(cityCodeVO) && Objects.nonNull(areaCodeVO)) {
                patientInfoListJX16VO.setNational("1");
                patientInfoListJX16VO.setProvinceCode(patientInfoListJX16VO.getCardNumber().substring(0, 2));
                patientInfoListJX16VO.setCityCode(patientInfoListJX16VO.getCardNumber().substring(0, 4));
                patientInfoListJX16VO.setAreaCode(patientInfoListJX16VO.getCardNumber().substring(0, 6));
                listJX16VOS.add((PatientInfoListJX16VO)patientInfoListJX16VO);
            }
        });
        return listJX16VOS;
    }

    public Area getArea(String cardId) {
        Area area = new Area();
        String provinceAreaName = this.patientBaseDataMapper.getAllAreaName(cardId.substring(0, 2) + "0000");
        String cityAreaName = this.patientBaseDataMapper.getAllAreaName(cardId.substring(0, 4) + "00").replace(provinceAreaName, "");
        String countAreaName = this.patientBaseDataMapper.getAllAreaName(cardId.substring(0, 6)).replace(provinceAreaName + cityAreaName, "");
        area.setProvinceCode(cardId.substring(0, 2));
        area.setProvinceName(provinceAreaName);
        area.setCityCode(cardId.substring(0, 4));
        area.setCityName(cityAreaName);
        area.setAreaCode(cardId.substring(0, 6));
        area.setAreaName(countAreaName);
        area.setAddress(this.patientBaseDataMapper.getAllAreaName(cardId.substring(0, 6)));
        log.info("\u6839\u636ecardId={},\u83b7\u53d6\u7684\u7701\u5e02\u533a\u4fe1\u606f\uff1a{}", (Object)cardId, (Object)JSON.toJSONString((Object)area));
        return area;
    }
}

