/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.data.service.impl.beijing;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.data.business.upload.immediate.BeijingTableChangeHandler;
import com.ebaiyihui.data.business.upload.reservation.BeijingUpload;
import com.ebaiyihui.data.business.upload.reservation.IUpload;
import com.ebaiyihui.data.business.upload.reservation.bo.BeijingHospitalInfo;
import com.ebaiyihui.data.business.upload.reservation.enums.beijing.BeijingHosNameEnum;
import com.ebaiyihui.data.dao.HtzxyyMappper;
import com.ebaiyihui.data.factroy.InitDataServiceFactory;
import com.ebaiyihui.data.pojo.vo.bj.exportBJZRXml.ClinicDataVo;
import com.ebaiyihui.data.pojo.vo.bj.exportBJZRXml.ExportBJZRXVo;
import com.ebaiyihui.data.service.beijing.BeijingInitDataService;
import com.ebaiyihui.data.utils.DateUtils;
import com.ebaiyihui.data.utils.XmlUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class HtzxyyInitDataServiceImpl
implements BeijingInitDataService,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(HtzxyyInitDataServiceImpl.class);
    public static final String CLINIC_METHOD = "clinic";
    @Autowired
    private HtzxyyMappper htzxyyMappper;

    public IUpload getClinicInfoByAdmIdAndHosId(String admId, String hospitalId) {
        ClinicDataVo clinicDataVo = this.htzxyyMappper.getAdmissionXmlByAdmIdAndHosId(admId, hospitalId);
        log.info("clinicDataVo==>{}", (Object)JSON.toJSONString((Object)clinicDataVo));
        if (Objects.isNull(clinicDataVo)) {
            return null;
        }
        BeijingHospitalInfo beijingHospitalInfo = new BeijingHospitalInfo(BeijingHosNameEnum.getDesc((String)hospitalId));
        clinicDataVo.setA01C(beijingHospitalInfo.getYljgdm());
        String clinicData = this.convertClinicInfoToXml(clinicDataVo);
        if (StringUtils.isBlank((CharSequence)clinicData)) {
            return null;
        }
        BeijingUpload beijingUpload = new BeijingUpload();
        beijingUpload.setHosName(BeijingHosNameEnum.getDesc((String)hospitalId));
        beijingUpload.setServiceMethod(CLINIC_METHOD);
        beijingUpload.setData(clinicData);
        return beijingUpload;
    }

    public IUpload getClinicInfoByMainIdAndHosId(String mainId, String hospitalId) {
        String admId = this.htzxyyMappper.getAdmIdByMainIdAndHospitalId(mainId);
        String admStatus = this.htzxyyMappper.getAdmStatusByAdmId(admId);
        if (BeijingTableChangeHandler.admFinishStatus.contains(admStatus)) {
            ClinicDataVo clinicDataVo = this.htzxyyMappper.getAdmissionXmlByAdmIdAndHosId(admId, hospitalId);
            log.info("clinicDataVo==>{}", (Object)JSON.toJSONString((Object)clinicDataVo));
            if (Objects.isNull(clinicDataVo)) {
                return null;
            }
            BeijingHospitalInfo beijingHospitalInfo = new BeijingHospitalInfo(BeijingHosNameEnum.getDesc((String)hospitalId));
            clinicDataVo.setA01C(beijingHospitalInfo.getYljgdm());
            ExportBJZRXVo exportBJZRXVo = new ExportBJZRXVo();
            clinicDataVo.setC03s(DateUtils.dateToFullString((Date)clinicDataVo.getC03()));
            if (clinicDataVo.getC08() != null) {
                clinicDataVo.setC08s(DateUtils.dateToFullString((Date)clinicDataVo.getC08()));
            }
            BeanUtils.copyProperties((Object)clinicDataVo, (Object)exportBJZRXVo);
            exportBJZRXVo.setC08(clinicDataVo.getC08s());
            exportBJZRXVo.setC03(clinicDataVo.getC03s());
            List eList = this.htzxyyMappper.getPresInfoByMainId(mainId);
            List dList = this.htzxyyMappper.getDiagnosticInfoByMainId(mainId);
            exportBJZRXVo.setDs(dList);
            ArrayList es = new ArrayList();
            es.addAll(eList);
            exportBJZRXVo.setEs(es);
            ArrayList fs = new ArrayList();
            exportBJZRXVo.setFs(fs);
            String clinicInfoXml = XmlUtil.converTomXml((Object)exportBJZRXVo);
            if (StringUtils.isBlank((CharSequence)clinicInfoXml)) {
                return null;
            }
            BeijingUpload beijingUpload = new BeijingUpload();
            beijingUpload.setHosName(BeijingHosNameEnum.getDesc((String)hospitalId));
            beijingUpload.setServiceMethod(CLINIC_METHOD);
            beijingUpload.setData(clinicInfoXml);
            return beijingUpload;
        }
        return null;
    }

    private String convertClinicInfoToXml(ClinicDataVo clinicData) {
        ExportBJZRXVo exportBJZRXVo = new ExportBJZRXVo();
        clinicData.setC03s(DateUtils.dateToFullString((Date)clinicData.getC03()));
        if (clinicData.getC08() != null) {
            clinicData.setC08s(DateUtils.dateToFullString((Date)clinicData.getC08()));
        }
        BeanUtils.copyProperties((Object)clinicData, (Object)exportBJZRXVo);
        exportBJZRXVo.setC08(clinicData.getC08s());
        exportBJZRXVo.setC03(clinicData.getC03s());
        List eList = this.htzxyyMappper.mosDrugDetail(clinicData.getAdmId());
        if (CollectionUtils.isEmpty((Collection)eList)) {
            log.info("\u672a\u5f00\u5904\u65b9\u6216\u8005\u5904\u65b9\u8fd8\u6ca1\u652f\u4ed8\u5b8c\u6210\uff0c \u5c31\u8bcaid->{}", (Object)clinicData.getAdmId());
            return "";
        }
        List dList = this.htzxyyMappper.mosDiagnostic(clinicData.getAdmId());
        exportBJZRXVo.setDs(dList);
        ArrayList es = new ArrayList();
        es.addAll(eList);
        exportBJZRXVo.setEs(es);
        ArrayList fs = new ArrayList();
        exportBJZRXVo.setFs(fs);
        String clinicInfoXml = XmlUtil.converTomXml((Object)exportBJZRXVo);
        return clinicInfoXml;
    }

    public void afterPropertiesSet() throws Exception {
        InitDataServiceFactory.registerBeijingInitDataService((String)BeijingHosNameEnum.HTZXYY.getValue(), (BeijingInitDataService)this);
    }
}

