/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.data.service.impl.beijing;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.data.common.constants.HisConstants;
import com.ebaiyihui.data.dao.AdmissionBJMapper;
import com.ebaiyihui.data.dao.MainBJMapper;
import com.ebaiyihui.data.pojo.vo.bj.exportBJZRXml.ClinicDataVo;
import com.ebaiyihui.data.pojo.vo.bj.exportBJZRXml.ExportBJZRXVo;
import com.ebaiyihui.data.service.beijing.MonitoringPlatformDataExportBJZRService;
import com.ebaiyihui.data.utils.DateUtils;
import com.ebaiyihui.data.utils.XmlUtil;
import com.ebaiyihui.framework.response.BaseResponse;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MonitoringPlatformDataExportBJZRImpl
implements MonitoringPlatformDataExportBJZRService {
    private static final Logger log = LoggerFactory.getLogger(MonitoringPlatformDataExportBJZRImpl.class);
    @Autowired
    private AdmissionBJMapper admissionBJMapper;
    @Autowired
    private MainBJMapper mainBJMapper;
    private static String doctorIds = "35189,35461,35269,35189,35570,35330,35268,35400,35463,35457,35458,35459,35460,\n35566,35573,36046,36073,36074,36075,36525,28493,31169,31548";

    public BaseResponse<String> getExportXmlByAdmId(String admId) {
        List clinicDataVo = this.admissionBJMapper.getExportXmlByAdmId(doctorIds, admId);
        log.info("clinicDataVo==>{}", (Object)JSON.toJSONString((Object)clinicDataVo));
        return this.exportXmlData(clinicDataVo);
    }

    public BaseResponse<String> getDayExportXmlData() {
        List clinicDataVo = this.admissionBJMapper.getDayExportXmlData(doctorIds);
        log.info("clinicDataVo==>{}", (Object)JSON.toJSONString((Object)clinicDataVo));
        return this.exportXmlData(clinicDataVo);
    }

    public BaseResponse<String> getHistoryExportXmlData() {
        List clinicDataVo = this.admissionBJMapper.getHistoryExportXmlData(doctorIds);
        log.info("clinicDataVo==>{}", (Object)JSON.toJSONString((Object)clinicDataVo));
        return this.exportXmlData(clinicDataVo);
    }

    private BaseResponse<String> exportXmlData(List<ClinicDataVo> clinicDataVo) {
        String exportXml = null;
        for (ClinicDataVo clinicData : clinicDataVo) {
            ExportBJZRXVo exportBJZRXVo = new ExportBJZRXVo();
            clinicData.setC03s(DateUtils.dateToFullString((Date)clinicData.getC03()));
            if (clinicData.getC08() != null) {
                clinicData.setC08s(DateUtils.dateToFullString((Date)clinicData.getC08()));
            }
            BeanUtils.copyProperties((Object)clinicData, (Object)exportBJZRXVo);
            exportBJZRXVo.setC08(clinicData.getC08s());
            exportBJZRXVo.setC03(clinicData.getC03s());
            List eList = this.mainBJMapper.mosDrugDetail(clinicData.getAdmId());
            List dList = this.mainBJMapper.mosDiagnostic(clinicData.getAdmId());
            if (HisConstants.ERROR.intValue() != eList.size()) {
                exportBJZRXVo.setDs(dList);
                ArrayList es = new ArrayList();
                es.add(eList.get(0));
                exportBJZRXVo.setEs(es);
                ArrayList fs = new ArrayList();
                exportBJZRXVo.setFs(fs);
            }
            if (HisConstants.ERROR.intValue() == eList.size()) continue;
            exportXml = XmlUtil.converTomXml((Object)exportBJZRXVo);
        }
        return BaseResponse.success(exportXml);
    }
}

