/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.data.service.impl.hebei;

import com.ebaiyihui.data.business.upload.reservation.HeBeiUpload;
import com.ebaiyihui.data.business.upload.reservation.IUpload;
import com.ebaiyihui.data.business.upload.reservation.enums.hebei.HeBeiHosNameEnum;
import com.ebaiyihui.data.dao.HeBeiBaseServiceMapper;
import com.ebaiyihui.data.pojo.vo.hebei.HeBeiDeptInfo;
import com.ebaiyihui.data.pojo.vo.hebei.HeBeiDeptInfoReqVO;
import com.ebaiyihui.data.pojo.vo.hebei.HeBeiDoctorInfo;
import com.ebaiyihui.data.pojo.vo.hebei.HeBeiDoctorInfoReqVO;
import com.ebaiyihui.data.pojo.vo.hebei.HeBeiOrganInfo;
import com.ebaiyihui.data.pojo.vo.hebei.HeBeiOrganInfoReqVO;
import com.ebaiyihui.data.service.hebei.HeBeiBaseServiceService;
import com.ebaiyihui.data.utils.DateUtils;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HeBeiBaseServiceServiceImpl
implements HeBeiBaseServiceService {
    @Autowired
    private HeBeiBaseServiceMapper heBeiBaseServiceMapper;

    public IUpload getOrganInfo(String organId) {
        if (Objects.isNull(organId)) {
            return null;
        }
        HeBeiOrganInfo organInfo = this.heBeiBaseServiceMapper.getOrganInfo(organId);
        if (Objects.isNull(organInfo)) {
            return null;
        }
        HeBeiOrganInfoReqVO heBeiOrganInfoReqVO = new HeBeiOrganInfoReqVO();
        HeBeiOrganInfoReqVO.MessagesBean messagesBean = new HeBeiOrganInfoReqVO.MessagesBean();
        HeBeiOrganInfoReqVO.MessagesBean.BusinessBean businessBean = new HeBeiOrganInfoReqVO.MessagesBean.BusinessBean();
        HeBeiOrganInfoReqVO.MessagesBean.BusinessBean.EVNBean evnBean = new HeBeiOrganInfoReqVO.MessagesBean.BusinessBean.EVNBean();
        evnBean.setEventTypeCode("CASE_ORGAN_INFO");
        evnBean.setEventTypeName("\u673a\u6784\u4fe1\u606f");
        businessBean.setEVN(evnBean);
        HeBeiOrganInfoReqVO.MessagesBean.BusinessBean.JGMBean jgmBean = new HeBeiOrganInfoReqVO.MessagesBean.BusinessBean.JGMBean();
        jgmBean.setPROV_CODE(organInfo.getProvCode());
        jgmBean.setPROV_NAME(organInfo.getProvName());
        jgmBean.setCITY_CODE(organInfo.getCityCode());
        jgmBean.setCITY_NAME(organInfo.getCityName());
        jgmBean.setCOUN_CODE(organInfo.getCounCode());
        jgmBean.setCOUN_NAME(organInfo.getCounName());
        jgmBean.setORG_CODE(organInfo.getOrgCode());
        jgmBean.setORG_NAME(organInfo.getOrgName() + "\u4e92\u8054\u7f51\u533b\u9662");
        jgmBean.setTREAT_ITEM_CODE(organInfo.getTreatItemCode());
        jgmBean.setTREAT_ITEM_NAME(organInfo.getTreatItemName());
        jgmBean.setJOIN_DATE(DateUtils.getCurrentDateTimeString());
        jgmBean.setBUS_DATE(DateUtils.getCurrentDateTimeString());
        jgmBean.setLAST_UPDATE_DTIME(DateUtils.getCurrentDateTimeString());
        businessBean.setJGM(jgmBean);
        messagesBean.setBusiness(businessBean);
        heBeiOrganInfoReqVO.setMessages(messagesBean);
        Gson gson = new Gson();
        String jsonData = gson.toJson((Object)heBeiOrganInfoReqVO);
        HeBeiUpload heBeiUpload = new HeBeiUpload();
        heBeiUpload.setData(jsonData);
        heBeiUpload.setServiceMethod("uploadOrganization");
        heBeiUpload.setHosName(HeBeiHosNameEnum.getDesc((String)organId));
        return heBeiUpload;
    }

    public IUpload getDeptInfo(String organId) {
        if (Objects.isNull(organId)) {
            return null;
        }
        List deptInfoList = this.heBeiBaseServiceMapper.getDeptInfo(organId);
        if (deptInfoList == null || deptInfoList.size() <= 0) {
            return null;
        }
        ArrayList<HeBeiDeptInfoReqVO> heBeiDeptInfoReqVOS = new ArrayList<HeBeiDeptInfoReqVO>();
        for (HeBeiDeptInfo deptInfo : deptInfoList) {
            HeBeiDeptInfoReqVO heBeiDeptInfoReqVO = new HeBeiDeptInfoReqVO();
            HeBeiDeptInfoReqVO.MessagesBean messagesBean = new HeBeiDeptInfoReqVO.MessagesBean();
            HeBeiDeptInfoReqVO.MessagesBean.BusinessBean businessBean = new HeBeiDeptInfoReqVO.MessagesBean.BusinessBean();
            HeBeiDeptInfoReqVO.MessagesBean.BusinessBean.EVNBean evnBean = new HeBeiDeptInfoReqVO.MessagesBean.BusinessBean.EVNBean();
            evnBean.setEventTypeCode("CASE_DEPARTMENT_INFO");
            evnBean.setEventTypeName("\u79d1\u5ba4\u4fe1\u606f");
            businessBean.setEVN(evnBean);
            HeBeiDeptInfoReqVO.MessagesBean.BusinessBean.JGMBean jgmBean = new HeBeiDeptInfoReqVO.MessagesBean.BusinessBean.JGMBean();
            jgmBean.setPROV_CODE(deptInfo.getProvCode());
            jgmBean.setPROV_NAME(deptInfo.getProvName());
            jgmBean.setCITY_CODE(deptInfo.getCityCode());
            jgmBean.setCITY_NAME(deptInfo.getCityName());
            jgmBean.setCOUN_CODE(deptInfo.getCounCode());
            jgmBean.setCOUN_NAME(deptInfo.getCounName());
            jgmBean.setORG_CODE(deptInfo.getOrgCode());
            jgmBean.setORG_NAME(deptInfo.getOrgName());
            jgmBean.setDEP_CODE(deptInfo.getDepCode());
            jgmBean.setDEP_NAME(deptInfo.getDepName());
            jgmBean.setTREAT_ITEM_CODE(deptInfo.getTreatItemCode());
            jgmBean.setTREAT_ITEM_NAME(deptInfo.getTreatItemName());
            jgmBean.setJOIN_DATE(DateUtils.getCurrentDateTimeString());
            jgmBean.setBUS_DATE(DateUtils.getCurrentDateTimeString());
            jgmBean.setLAST_UPDATE_DTIME(DateUtils.getCurrentDateTimeString());
            businessBean.setJGM(jgmBean);
            messagesBean.setBusiness(businessBean);
            heBeiDeptInfoReqVO.setMessages(messagesBean);
            heBeiDeptInfoReqVOS.add(heBeiDeptInfoReqVO);
        }
        Gson gson = new Gson();
        String jsonData = gson.toJson(heBeiDeptInfoReqVOS);
        HeBeiUpload heBeiUpload = new HeBeiUpload();
        heBeiUpload.setData(jsonData);
        heBeiUpload.setServiceMethod("uploadDepartment");
        heBeiUpload.setHosName(HeBeiHosNameEnum.getDesc((String)organId));
        return heBeiUpload;
    }

    public IUpload getDoctorInfo(String doctorId, String hospitalId) {
        HeBeiOrganInfo organInfo = this.heBeiBaseServiceMapper.getOrganInfo(hospitalId);
        if (Objects.isNull(doctorId)) {
            return null;
        }
        HeBeiDoctorInfo doctorInfo = this.heBeiBaseServiceMapper.getDoctorInfo(doctorId);
        if (Objects.isNull(doctorInfo)) {
            return null;
        }
        HeBeiDoctorInfoReqVO heBeiDoctorInfoReqVO = new HeBeiDoctorInfoReqVO();
        HeBeiDoctorInfoReqVO.MessagesBean messagesBean = new HeBeiDoctorInfoReqVO.MessagesBean();
        HeBeiDoctorInfoReqVO.MessagesBean.BusinessBean businessBean = new HeBeiDoctorInfoReqVO.MessagesBean.BusinessBean();
        HeBeiDoctorInfoReqVO.MessagesBean.BusinessBean.EVNBean evnBean = new HeBeiDoctorInfoReqVO.MessagesBean.BusinessBean.EVNBean();
        evnBean.setEventTypeCode("CASE_DOCTOR_INFO");
        evnBean.setEventTypeName("\u4eba\u5458\u4fe1\u606f");
        businessBean.setEVN(evnBean);
        HeBeiDoctorInfoReqVO.MessagesBean.BusinessBean.JGMBean jgmBean = new HeBeiDoctorInfoReqVO.MessagesBean.BusinessBean.JGMBean();
        jgmBean.setPROV_CODE(organInfo.getProvCode());
        jgmBean.setPROV_NAME(organInfo.getProvCode());
        jgmBean.setCITY_CODE(organInfo.getCityCode());
        jgmBean.setCITY_NAME(organInfo.getCityName());
        jgmBean.setCOUN_CODE(organInfo.getCounCode());
        jgmBean.setCOUN_NAME(organInfo.getCounName());
        jgmBean.setORG_CODE(doctorInfo.getOrgCode());
        jgmBean.setORG_NAME(doctorInfo.getOrgName());
        jgmBean.setDEP_CODE(doctorInfo.getDepCode());
        jgmBean.setDEP_NAME(doctorInfo.getDepName());
        jgmBean.setDOCTOR_CODE(doctorInfo.getDoctorCode());
        jgmBean.setDOCTOR_NAME(doctorInfo.getDoctorName());
        jgmBean.setSEX_CODE(doctorInfo.getSexCode());
        jgmBean.setSEX_NAME(doctorInfo.getSexName());
        jgmBean.setAGE_YEAR(doctorInfo.getAgeYear());
        jgmBean.setBIRTH_DATE(doctorInfo.getBirthDate());
        jgmBean.setID_TYPE_CODE(doctorInfo.getIdTypeCode());
        jgmBean.setID_TYPE_NAME(doctorInfo.getIdTypeName());
        jgmBean.setID_NO(doctorInfo.getIdNo());
        jgmBean.setDOCTOR_TITLE_CODE(doctorInfo.getDoctorTitleCode());
        jgmBean.setDOCTOR_TITLE(doctorInfo.getDoctorTitle());
        if (doctorInfo.getDoctorTitle().contains("\u836f\u5e08")) {
            jgmBean.setDOCTOR_TYPE("3");
        } else {
            jgmBean.setDOCTOR_TYPE("1");
        }
        jgmBean.setJOIN_DATE(DateUtils.getCurrentDateTimeString());
        jgmBean.setBUS_DATE(DateUtils.getCurrentDateTimeString());
        jgmBean.setLAST_UPDATE_DTIME(DateUtils.getCurrentDateTimeString());
        businessBean.setJGM(jgmBean);
        messagesBean.setBusiness(businessBean);
        heBeiDoctorInfoReqVO.setMessages(messagesBean);
        Gson gson = new Gson();
        String jsonData = gson.toJson((Object)heBeiDoctorInfoReqVO);
        HeBeiUpload heBeiUpload = new HeBeiUpload();
        heBeiUpload.setData(jsonData);
        heBeiUpload.setServiceMethod("uploadDoctor");
        heBeiUpload.setHosName(HeBeiHosNameEnum.getDesc((String)doctorInfo.getOrganId()));
        return heBeiUpload;
    }
}

