/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.data.service.impl.hunan;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ebaiyihui.data.business.upload.reservation.HuNanUpload;
import com.ebaiyihui.data.business.upload.reservation.IUpload;
import com.ebaiyihui.data.business.upload.reservation.bo.HuNanHospitalInfo;
import com.ebaiyihui.data.business.upload.reservation.enums.hunan.HnHosNameEnum;
import com.ebaiyihui.data.business.upload.reservation.enums.hunan.HuNanServiceMethodEnum;
import com.ebaiyihui.data.business.upload.util.MongoDBFactory;
import com.ebaiyihui.data.dao.MedicalcloudRecipeMapper;
import com.ebaiyihui.data.dao.OnlineOutpatientHNMapper;
import com.ebaiyihui.data.dao.PatientBaseDataMapper;
import com.ebaiyihui.data.dao.RemoteMapper;
import com.ebaiyihui.data.enums.CardTypeEnum;
import com.ebaiyihui.data.pojo.vo.hn.AnomalousEventHNVo;
import com.ebaiyihui.data.pojo.vo.hn.AppointHNVo;
import com.ebaiyihui.data.pojo.vo.hn.ChargeInfo;
import com.ebaiyihui.data.pojo.vo.hn.ConsultHNVo;
import com.ebaiyihui.data.pojo.vo.hn.EvaluationHNVo;
import com.ebaiyihui.data.pojo.vo.hn.FeeHNVo;
import com.ebaiyihui.data.pojo.vo.hn.PatientCardInfo;
import com.ebaiyihui.data.pojo.vo.hn.PatientInfo;
import com.ebaiyihui.data.pojo.vo.hn.RecipeIndicatorsDetailInfo;
import com.ebaiyihui.data.pojo.vo.hn.RecipeIndicatorsInfo;
import com.ebaiyihui.data.pojo.vo.hn.RecipeVerificationInfo;
import com.ebaiyihui.data.pojo.vo.hn.RevisitHNVo;
import com.ebaiyihui.data.pojo.vo.hn.RevisitLastVo;
import com.ebaiyihui.data.service.hunan.HuNanInitDataService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class HuNanInitDataServiceImpl
implements HuNanInitDataService {
    private static final Logger log = LoggerFactory.getLogger(HuNanInitDataServiceImpl.class);
    private static final String YLJGDM = "70085";
    @Autowired
    MedicalcloudRecipeMapper medicalcloudRecipeMapper;
    @Autowired
    OnlineOutpatientHNMapper onlineOutpatientHNMapper;
    @Autowired
    RemoteMapper remoteMapper;
    @Autowired
    PatientBaseDataMapper patientBaseDataMapper;

    public IUpload getPatientInfo(String cardId) {
        HuNanUpload huNanUpload = new HuNanUpload();
        PatientCardInfo patientCardInfo = this.patientBaseDataMapper.selectCardInfo(cardId);
        PatientInfo patient = this.patientBaseDataMapper.selectPatient(patientCardInfo.getPatientid());
        if (Objects.isNull(patient)) {
            return null;
        }
        String csrq = patient.getCsrq().replace("-", "");
        patient.setCsrq(csrq);
        ArrayList cardList = new ArrayList();
        HashMap<String, String> cardMap = new HashMap<String, String>();
        cardMap.put("kh", patient.getZjhm());
        if (CardTypeEnum.SBK.getValue().equals(patientCardInfo.getKlx())) {
            cardMap.put("klx", CardTypeEnum.TYZFK.getValue());
        } else if (CardTypeEnum.FTYZFK.getValue().equals(patientCardInfo.getKlx())) {
            cardMap.put("klx", CardTypeEnum.YBK.getValue());
        } else {
            cardMap.put("klx", CardTypeEnum.QTK.getValue());
        }
        cardList.add(cardMap);
        patient.setCardList(cardList);
        patient.setGmbz("1");
        patient.setYljgdm(YLJGDM);
        HuNanHospitalInfo huNanHospitalInfo = this.getHuNanHospitalInfo(HnHosNameEnum.HNHT.toString());
        patient.setHlwyljgdm(huNanHospitalInfo.getHlwyljgdm());
        patient.setYljgdm(huNanHospitalInfo.getYljgdm());
        log.info("\u60a3\u8005\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)patient));
        String data = JSON.toJSONString((Object)patient);
        log.info("\u4e0a\u62a5\u60a3\u8005\u6570\u636e\uff1a{}", (Object)data);
        huNanUpload.setData(data);
        huNanUpload.setHosName(HnHosNameEnum.HNHT.toString());
        huNanUpload.setServiceMethod(HuNanServiceMethodEnum.uploadPatientInfo.getDesc());
        huNanUpload.setServiceMethodSign(HuNanServiceMethodEnum.uploadPatientInfo.getValue());
        return huNanUpload;
    }

    public IUpload getAppointInfo(String admId) {
        HuNanUpload huNanUpload = new HuNanUpload();
        AppointHNVo appointInfo = this.onlineOutpatientHNMapper.getAppointInfo(admId);
        if (null == appointInfo) {
            return null;
        }
        HuNanHospitalInfo huNanHospitalInfo = this.getHuNanHospitalInfo(HnHosNameEnum.HNHT.toString());
        appointInfo.setHlwyljgdm(huNanHospitalInfo.getHlwyljgdm());
        appointInfo.setYljgdm(huNanHospitalInfo.getYljgdm());
        huNanUpload.setData(JSON.toJSONStringWithDateFormat((Object)appointInfo, (String)"yyyy-MM-dd HH:mm:ss", (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat}));
        huNanUpload.setHosName(HnHosNameEnum.HNHT.toString());
        huNanUpload.setServiceMethod(HuNanServiceMethodEnum.uploadAppointInfo.getDesc());
        huNanUpload.setServiceMethodSign(HuNanServiceMethodEnum.uploadAppointInfo.getValue());
        return huNanUpload;
    }

    public IUpload getConsultInfo(String admId) {
        HuNanUpload huNanUpload = new HuNanUpload();
        ConsultHNVo consultHNVo = this.onlineOutpatientHNMapper.getConsultInfo(admId);
        if (null == consultHNVo) {
            return null;
        }
        HuNanHospitalInfo huNanHospitalInfo = this.getHuNanHospitalInfo(HnHosNameEnum.HNHT.toString());
        consultHNVo.setHlwyljgdm(huNanHospitalInfo.getHlwyljgdm());
        consultHNVo.setYljgdm(huNanHospitalInfo.getYljgdm());
        huNanUpload.setData(JSON.toJSONStringWithDateFormat((Object)consultHNVo, (String)"yyyy-MM-dd HH:mm:ss", (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat}));
        huNanUpload.setHosName(HnHosNameEnum.HNHT.toString());
        huNanUpload.setServiceMethod(HuNanServiceMethodEnum.uploadConsultInfo.getDesc());
        huNanUpload.setServiceMethodSign(HuNanServiceMethodEnum.uploadConsultInfo.getValue());
        return huNanUpload;
    }

    public IUpload getRevisitInfo(String admId, String patientid) {
        HuNanUpload huNanUpload = new HuNanUpload();
        huNanUpload.setHosName(HnHosNameEnum.HNHT.toString());
        huNanUpload.setServiceMethod(HuNanServiceMethodEnum.uploadRevisitInfo.getDesc());
        huNanUpload.setServiceMethodSign(HuNanServiceMethodEnum.uploadRevisitInfo.getValue());
        RevisitHNVo revisitInfo = this.onlineOutpatientHNMapper.getNowRevisitInfo(admId);
        if (null == revisitInfo) {
            return null;
        }
        HuNanHospitalInfo huNanHospitalInfo = this.getHuNanHospitalInfo(HnHosNameEnum.HNHT.toString());
        revisitInfo.setHlwyljgdm(huNanHospitalInfo.getHlwyljgdm());
        revisitInfo.setYljgdm(huNanHospitalInfo.getYljgdm());
        String icdName = this.onlineOutpatientHNMapper.getICDName(admId);
        if (StringUtils.isNotEmpty((String)icdName)) {
            revisitInfo.setBczdmc(icdName);
            List<String> list = Arrays.asList(icdName.split(";"));
            ArrayList<String> codeList = new ArrayList<String>();
            for (String name : list) {
                String icdCode = this.onlineOutpatientHNMapper.getICDCode(name);
                if (StringUtils.isEmpty((String)icdCode)) continue;
                codeList.add(icdCode);
            }
            if (CollectionUtils.isEmpty(codeList)) {
                revisitInfo.setBczdbm("\u6682\u65e0");
            } else {
                String code = StringUtils.join(codeList, (String)";");
                revisitInfo.setBczdbm(code);
            }
        } else {
            revisitInfo.setBczdmc("\u6682\u65e0");
            revisitInfo.setBczdbm("\u6682\u65e0");
        }
        String lasTAdmId = this.onlineOutpatientHNMapper.getLastOrder(patientid);
        if (StringUtils.isEmpty((String)lasTAdmId)) {
            return null;
        }
        RevisitLastVo lastRevisitInfo = this.onlineOutpatientHNMapper.getLastInfo(lasTAdmId);
        if (null == lastRevisitInfo) {
            return null;
        }
        BeanUtils.copyProperties((Object)lastRevisitInfo, (Object)revisitInfo);
        String icdNameLast = this.onlineOutpatientHNMapper.getICDName(lasTAdmId);
        if (StringUtils.isNotEmpty((String)icdNameLast)) {
            revisitInfo.setCzzdmc(icdNameLast);
            List<String> listLast = Arrays.asList(icdNameLast.split(";"));
            ArrayList<String> codeListLast = new ArrayList<String>();
            for (String name : listLast) {
                String icdCode = this.onlineOutpatientHNMapper.getICDCode(name);
                if (StringUtils.isEmpty((String)icdCode)) continue;
                codeListLast.add(icdCode);
            }
            if (CollectionUtils.isEmpty(codeListLast)) {
                revisitInfo.setCzzdbm("\u6682\u65e0");
            } else {
                String codeLast = StringUtils.join(codeListLast, (String)";");
                revisitInfo.setCzzdbm(codeLast);
            }
        } else {
            revisitInfo.setCzzdmc("\u6682\u65e0");
            revisitInfo.setCzzdbm("\u6682\u65e0");
        }
        huNanUpload.setData(JSON.toJSONStringWithDateFormat((Object)revisitInfo, (String)"yyyy-MM-dd HH:mm:ss", (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat}));
        return huNanUpload;
    }

    public IUpload getPastMedicalHistory(String admId) {
        HuNanUpload huNanUpload = new HuNanUpload();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("patientId", (Object)"123456");
        huNanUpload.setHosName(HnHosNameEnum.HNHT.toString());
        huNanUpload.setServiceMethod(HuNanServiceMethodEnum.uploadPastMedicalHistory.getDesc());
        huNanUpload.setServiceMethodSign(HuNanServiceMethodEnum.uploadPastMedicalHistory.getValue());
        return huNanUpload;
    }

    public IUpload getChargeInfo(String admId) {
        HuNanUpload huNanUpload = new HuNanUpload();
        FeeHNVo chargeInfo = this.onlineOutpatientHNMapper.getChargeInfo(admId);
        if (null == chargeInfo) {
            return null;
        }
        HuNanHospitalInfo huNanHospitalInfo = this.getHuNanHospitalInfo(HnHosNameEnum.HNHT.toString());
        chargeInfo.setHlwyljgdm(huNanHospitalInfo.getHlwyljgdm());
        chargeInfo.setYljgdm(huNanHospitalInfo.getYljgdm());
        huNanUpload.setData(JSON.toJSONStringWithDateFormat((Object)chargeInfo, (String)"yyyy-MM-dd HH:mm:ss", (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat}));
        huNanUpload.setHosName(HnHosNameEnum.HNHT.toString());
        huNanUpload.setServiceMethod(HuNanServiceMethodEnum.uploadCharge.getDesc());
        huNanUpload.setServiceMethodSign(HuNanServiceMethodEnum.uploadCharge.getValue());
        return huNanUpload;
    }

    public IUpload getRecipeIndicatorsInfo(String mainId) {
        HuNanUpload huNanUpload = new HuNanUpload();
        RecipeIndicatorsInfo recipeIndicatorsInfo = this.medicalcloudRecipeMapper.getRecipeIndicatorsInfoHN(mainId, YLJGDM);
        if (Objects.isNull(recipeIndicatorsInfo)) {
            return null;
        }
        HuNanHospitalInfo huNanHospitalInfo = this.getHuNanHospitalInfo(HnHosNameEnum.HNHT.toString());
        recipeIndicatorsInfo.setHlwyljgdm(huNanHospitalInfo.getHlwyljgdm());
        recipeIndicatorsInfo.setYljgdm(huNanHospitalInfo.getYljgdm());
        for (RecipeIndicatorsDetailInfo recipeIndicatorsDetailInfo : recipeIndicatorsInfo.getOrderList()) {
            recipeIndicatorsDetailInfo.setHlwyljgdm(huNanHospitalInfo.getHlwyljgdm());
            recipeIndicatorsDetailInfo.setYljgdm(huNanHospitalInfo.getYljgdm());
        }
        String data = JSON.toJSONString((Object)recipeIndicatorsInfo);
        log.info("\u4e0a\u62a5\u5904\u65b9\u6570\u636e\uff1a{}", (Object)data);
        huNanUpload.setData(data);
        huNanUpload.setHosName(HnHosNameEnum.HNHT.toString());
        huNanUpload.setServiceMethod(HuNanServiceMethodEnum.uploadRecipeIndicators.getDesc());
        huNanUpload.setServiceMethodSign(HuNanServiceMethodEnum.uploadRecipeIndicators.getValue());
        return huNanUpload;
    }

    public IUpload getPresChargeInfo(String mainId) {
        HuNanUpload huNanUpload = new HuNanUpload();
        ChargeInfo chargeInfo = this.medicalcloudRecipeMapper.getPresChargeInfoHN(mainId, YLJGDM);
        if (Objects.isNull(chargeInfo)) {
            return null;
        }
        HuNanHospitalInfo huNanHospitalInfo = this.getHuNanHospitalInfo(HnHosNameEnum.HNHT.toString());
        chargeInfo.setHlwyljgdm(huNanHospitalInfo.getHlwyljgdm());
        chargeInfo.setYljgdm(huNanHospitalInfo.getYljgdm());
        String data = JSON.toJSONString((Object)chargeInfo);
        log.info("\u4e0a\u62a5\u6536\u8d39\u6570\u636e\uff1a{}", (Object)data);
        huNanUpload.setData(data);
        huNanUpload.setHosName(HnHosNameEnum.HNHT.toString());
        huNanUpload.setServiceMethod(HuNanServiceMethodEnum.uploadCharge.getDesc());
        huNanUpload.setServiceMethodSign(HuNanServiceMethodEnum.uploadCharge.getValue());
        return huNanUpload;
    }

    public IUpload getEvaluationNews(String admId) {
        HuNanUpload huNanUpload = new HuNanUpload();
        EvaluationHNVo evaluation = this.onlineOutpatientHNMapper.getEvaluation(admId);
        if (null == evaluation) {
            return null;
        }
        HuNanHospitalInfo huNanHospitalInfo = this.getHuNanHospitalInfo(HnHosNameEnum.HNHT.toString());
        evaluation.setHlwyljgdm(huNanHospitalInfo.getHlwyljgdm());
        evaluation.setYljgdm(huNanHospitalInfo.getYljgdm());
        huNanUpload.setData(JSON.toJSONStringWithDateFormat((Object)evaluation, (String)"yyyy-MM-dd HH:mm:ss", (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat}));
        huNanUpload.setHosName(HnHosNameEnum.HNHT.toString());
        huNanUpload.setServiceMethod(HuNanServiceMethodEnum.uploadEvaluationNews.getDesc());
        huNanUpload.setServiceMethodSign(HuNanServiceMethodEnum.uploadEvaluationNews.getValue());
        return huNanUpload;
    }

    public IUpload getRecipeVerification(String mainId) {
        HuNanUpload huNanUpload = new HuNanUpload();
        RecipeVerificationInfo recipeVerificationInfo = this.medicalcloudRecipeMapper.getRecipeVerificationHN(mainId, YLJGDM);
        if (Objects.isNull(recipeVerificationInfo)) {
            return null;
        }
        HuNanHospitalInfo huNanHospitalInfo = this.getHuNanHospitalInfo(HnHosNameEnum.HNHT.toString());
        recipeVerificationInfo.setHlwyljgdm(huNanHospitalInfo.getHlwyljgdm());
        recipeVerificationInfo.setYljgdm(huNanHospitalInfo.getYljgdm());
        String data = JSON.toJSONString((Object)recipeVerificationInfo);
        log.info("\u4e0a\u62a5\u5904\u65b9\u6838\u9500\u6570\u636e\uff1a{}", (Object)data);
        huNanUpload.setData(data);
        huNanUpload.setHosName(HnHosNameEnum.HNHT.toString());
        huNanUpload.setServiceMethod(HuNanServiceMethodEnum.uploadRecipeVerification.getDesc());
        huNanUpload.setServiceMethodSign(HuNanServiceMethodEnum.uploadRecipeVerification.getValue());
        return huNanUpload;
    }

    public IUpload getRemoteConsultationInfo(String id) {
        HuNanUpload huNanUpload = new HuNanUpload();
        Map stringObjectMap = this.remoteMapper.selectHuNanConsultation(id);
        String data = JSON.toJSONStringWithDateFormat((Object)stringObjectMap, (String)"yyyy-MM-dd HH:mm:ss", (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat});
        if (StringUtils.isBlank((String)data)) {
            return null;
        }
        huNanUpload.setData(data);
        huNanUpload.setHosName(HnHosNameEnum.HNHT.toString());
        huNanUpload.setServiceMethod(HuNanServiceMethodEnum.uploadRemoteConsultationInfo.getDesc());
        huNanUpload.setServiceMethodSign(HuNanServiceMethodEnum.uploadRemoteConsultationInfo.getValue());
        return huNanUpload;
    }

    public IUpload getRemoteReferralInfo(String id) {
        HuNanUpload huNanUpload = new HuNanUpload();
        Map stringObjectMap = this.remoteMapper.selectHuNanReferral(id);
        String data = JSON.toJSONStringWithDateFormat((Object)stringObjectMap, (String)"yyyy-MM-dd HH:mm:ss", (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat});
        if (StringUtils.isBlank((String)data)) {
            return null;
        }
        huNanUpload.setData(data);
        huNanUpload.setHosName(HnHosNameEnum.HNHT.toString());
        huNanUpload.setServiceMethod(HuNanServiceMethodEnum.uploadRemoteReferralInfo.getDesc());
        huNanUpload.setServiceMethodSign(HuNanServiceMethodEnum.uploadRemoteReferralInfo.getValue());
        return huNanUpload;
    }

    public String getIsHaveEva(String admId) {
        String isHaveEva = this.onlineOutpatientHNMapper.getIsHaveEva(admId);
        return isHaveEva;
    }

    public IUpload getAnomalousEvent(String xId) {
        HuNanUpload huNanUpload = new HuNanUpload();
        AnomalousEventHNVo anomalousEvent = this.onlineOutpatientHNMapper.getAnomalousEvent(xId);
        if (null == anomalousEvent) {
            return null;
        }
        HuNanHospitalInfo huNanHospitalInfo = this.getHuNanHospitalInfo(HnHosNameEnum.HNHT.toString());
        anomalousEvent.setHlwyljgdm(huNanHospitalInfo.getHlwyljgdm());
        anomalousEvent.setYljgdm(huNanHospitalInfo.getYljgdm());
        huNanUpload.setData(JSON.toJSONStringWithDateFormat((Object)anomalousEvent, (String)"yyyy-MM-dd HH:mm:ss", (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat}));
        huNanUpload.setHosName(HnHosNameEnum.HNHT.toString());
        huNanUpload.setServiceMethod(HuNanServiceMethodEnum.uploadEventInfo.getDesc());
        huNanUpload.setServiceMethodSign(HuNanServiceMethodEnum.uploadEventInfo.getValue());
        return huNanUpload;
    }

    private HuNanHospitalInfo getHuNanHospitalInfo(String hosName) {
        MongoDBFactory mongoDBFactory = new MongoDBFactory("hos_info_config");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("hos_name", hosName);
        String data = mongoDBFactory.findOne("config", map);
        log.info("get HuNanHospitalInfo data =" + data);
        HuNanHospitalInfo huNanHospitalInfo = (HuNanHospitalInfo)JSONObject.parseObject((String)data, HuNanHospitalInfo.class);
        return huNanHospitalInfo;
    }

    private HuNanHospitalInfo getHuNanHospitalInfoByHosId(String hosId) {
        MongoDBFactory mongoDBFactory = new MongoDBFactory("hos_info_config");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("hos_id", hosId);
        String data = mongoDBFactory.findOne("config", map);
        log.info("get HuNanHospitalInfo data =" + data);
        HuNanHospitalInfo huNanHospitalInfo = (HuNanHospitalInfo)JSONObject.parseObject((String)data, HuNanHospitalInfo.class);
        return huNanHospitalInfo;
    }
}

