/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.data.service.impl.jx;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ebaiyihui.data.business.upload.reservation.IUpload;
import com.ebaiyihui.data.business.upload.reservation.JiangXiIInit;
import com.ebaiyihui.data.business.upload.reservation.JxUpload;
import com.ebaiyihui.data.dao.AdmissionJXMapper;
import com.ebaiyihui.data.pojo.vo.jx.AdmInfoJX16Vo;
import com.ebaiyihui.data.pojo.vo.jx.OnlineAppointPatientIdJX16Vo;
import com.ebaiyihui.data.pojo.vo.jx.OnlinePrescriptionCancelVo;
import com.ebaiyihui.data.pojo.vo.jx.OnlinePrescriptionJX16Vo;
import com.ebaiyihui.data.utils.IsNullUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@Order(value=4)
public class AdmInfoServiceImpl
implements JiangXiIInit {
    private static final Logger log = LoggerFactory.getLogger(AdmInfoServiceImpl.class);
    @Autowired
    private AdmissionJXMapper admissionJXMapper;

    public IUpload ndefyDataInit(String hospitalId) {
        List listAdmissionInfoJXND = this.admissionJXMapper.getListAdmissionInfoJXND(hospitalId);
        JxUpload jxUpload = this.convertAdmissionInfo(listAdmissionInfoJXND, hospitalId);
        log.info("\u67e5\u8be2\u6c5f\u897f\u7701\u5728\u7ebf\u590d\u8bca\u5df2\u5b8c\u6210\u5c31\u8bca\u4fe1\u606f\u8ba2\u5355{}", (Object)JSON.toJSONString((Object)jxUpload));
        jxUpload.setHospitalId(hospitalId);
        return jxUpload;
    }

    private JxUpload convertAdmissionInfo(List<AdmInfoJX16Vo> listAdmissionInfoJXND, String hospitalId) {
        log.info("\u6784\u5efa\u5c31\u8bca\u4fe1\u606f  AdmInfoServiceImpl");
        JxUpload jxUpload = new JxUpload();
        if (CollectionUtils.isEmpty(listAdmissionInfoJXND)) {
            jxUpload.setData("");
        } else {
            this.listAdmission(listAdmissionInfoJXND, hospitalId);
            ArrayList admInfoRes = new ArrayList();
            listAdmissionInfoJXND.stream().forEach(resList -> {
                AdmInfoJX16Vo onlineAppointRes = new AdmInfoJX16Vo();
                BeanUtils.copyProperties((Object)resList, (Object)onlineAppointRes);
                admInfoRes.add(onlineAppointRes);
            });
        }
        jxUpload.setData(JSON.toJSONStringWithDateFormat(listAdmissionInfoJXND, (String)"yyyy-MM-dd HH:mm:ss", (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat}));
        jxUpload.setServiceId("Patient.Treatment");
        jxUpload.setServiceMethod("Patient.Treatment");
        return jxUpload;
    }

    private void listAdmission(List<AdmInfoJX16Vo> listAdmissionInfoJXND, String hospitalId) {
        for (AdmInfoJX16Vo admInfoJX16Vo : listAdmissionInfoJXND) {
            List prescriptionList = new ArrayList();
            ArrayList<OnlinePrescriptionJX16Vo> onlinePrescriptionJX16VoList = new ArrayList<OnlinePrescriptionJX16Vo>();
            ArrayList<OnlinePrescriptionCancelVo> prescriptionCancelList = new ArrayList<OnlinePrescriptionCancelVo>();
            prescriptionList = this.admissionJXMapper.getPrescriptionJXND(admInfoJX16Vo.getTreNo());
            if (prescriptionList.isEmpty()) {
                OnlineAppointPatientIdJX16Vo onlineAppointPatientIdJX16Vo = new OnlineAppointPatientIdJX16Vo();
                onlineAppointPatientIdJX16Vo.setCardNumber(admInfoJX16Vo.getCardNumber());
                admInfoJX16Vo.setPrescriptionCancelData(new ArrayList());
                admInfoJX16Vo.setPrescriptionData(new ArrayList());
                admInfoJX16Vo.setType(Integer.valueOf(100));
                continue;
            }
            Iterator iterator = prescriptionList.iterator();
            OnlineAppointPatientIdJX16Vo onlineAppointPatientIdJX16Vo = new OnlineAppointPatientIdJX16Vo();
            onlineAppointPatientIdJX16Vo.setCardNumber(admInfoJX16Vo.getCardNumber());
            while (iterator.hasNext()) {
                OnlinePrescriptionJX16Vo next = (OnlinePrescriptionJX16Vo)iterator.next();
                if (!Objects.nonNull(next.getPresNo())) continue;
                List onlineDrugDataVos = this.admissionJXMapper.selectDrugInfoList(next.getPresNo());
                log.info("onlineDrugDataVos:{}", (Object)JSON.toJSONString((Object)onlineDrugDataVos));
                List validateProperty = IsNullUtil.validateProperty((List)onlineDrugDataVos, (String[])new String[]{"remark"});
                OnlinePrescriptionCancelVo onlinePrescriptionCancelVo = this.admissionJXMapper.prescriptionWriteOff(next.getPresNo());
                if (!validateProperty.isEmpty()) {
                    iterator.remove();
                    continue;
                }
                if (null != onlinePrescriptionCancelVo) {
                    prescriptionCancelList.add(onlinePrescriptionCancelVo);
                }
                next.setDrugData(onlineDrugDataVos);
                onlinePrescriptionJX16VoList.add(next);
            }
            admInfoJX16Vo.setPrescriptionCancelData(prescriptionCancelList);
            admInfoJX16Vo.setPrescriptionData(onlinePrescriptionJX16VoList);
        }
        listAdmissionInfoJXND.forEach(x -> {
            if (x.getPrescriptionCancelData().isEmpty() && !x.getPrescriptionData().isEmpty()) {
                x.setPrescriptionCancelData(new ArrayList());
                x.setType(Integer.valueOf(1));
            } else if (x.getPrescriptionCancelData().isEmpty() && x.getPrescriptionData().isEmpty()) {
                x.setPrescriptionCancelData(new ArrayList());
                x.setPrescriptionData(new ArrayList());
                x.setType(Integer.valueOf(100));
            } else if (!x.getPrescriptionCancelData().isEmpty() && !x.getPrescriptionData().isEmpty()) {
                x.setType(Integer.valueOf(1));
            }
        });
    }
}

