/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.data.service.impl.jx;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ebaiyihui.data.business.upload.reservation.IUpload;
import com.ebaiyihui.data.business.upload.reservation.JxUpload;
import com.ebaiyihui.data.business.upload.util.MongoDBFactory;
import com.ebaiyihui.data.pojo.vo.HospitalConfig;
import com.ebaiyihui.data.pojo.vo.jx.AgreeMentVo;
import com.ebaiyihui.data.utils.DateUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AgreementImpl {
    private static final Logger log = LoggerFactory.getLogger(AgreementImpl.class);

    public IUpload ndefyDataInit(String hospitalId) {
        MongoDBFactory mongoDBFactory = new MongoDBFactory("hos_info_config");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("hospitalId", hospitalId);
        String data = mongoDBFactory.findOne("config", map);
        HospitalConfig hospitalConfig = (HospitalConfig)JSONObject.parseObject((String)data, HospitalConfig.class);
        AgreeMentVo patientAgreeMentVo = new AgreeMentVo();
        AgreeMentVo doctorAgreeMentVo = new AgreeMentVo();
        AgreeMentVo patientInformedConsent = new AgreeMentVo();
        ArrayList<AgreeMentVo> agreeMentVos = new ArrayList<AgreeMentVo>();
        patientAgreeMentVo.setProtocolType("1");
        patientAgreeMentVo.setBytesInfo(hospitalConfig.getPatientUserAgreement());
        patientAgreeMentVo.setReleaseDate(DateUtils.getCurrentDate());
        patientAgreeMentVo.setUploadTime(new Date());
        agreeMentVos.add(patientAgreeMentVo);
        doctorAgreeMentVo.setProtocolType("2");
        doctorAgreeMentVo.setBytesInfo(hospitalConfig.getDoctorUserAgreement());
        doctorAgreeMentVo.setReleaseDate(new Date());
        doctorAgreeMentVo.setUploadTime(new Date());
        agreeMentVos.add(doctorAgreeMentVo);
        patientInformedConsent.setProtocolType("3");
        patientInformedConsent.setBytesInfo(hospitalConfig.getPatientInformedConsent());
        patientInformedConsent.setUploadTime(new Date());
        patientInformedConsent.setReleaseDate(new Date());
        agreeMentVos.add(patientInformedConsent);
        JxUpload jxUpload = new JxUpload();
        jxUpload.setHospitalId(hospitalId);
        jxUpload.setData(JSON.toJSONStringWithDateFormat(agreeMentVos, (String)"yyyy-MM-dd HH:mm:ss", (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat}));
        jxUpload.setServiceId("Patient.UserAgreement");
        jxUpload.setServiceMethod("Patient.UserAgreement");
        return jxUpload;
    }
}

