/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.data.service.impl.jx;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ebaiyihui.data.business.upload.reservation.bo.JxHospitalInfo;
import com.ebaiyihui.data.business.upload.util.MongoDBFactory;
import com.ebaiyihui.data.pojo.entity.jx.ComplaintDoctorReqVo;
import com.ebaiyihui.data.pojo.entity.jx.ConsultQueryReqVo;
import com.ebaiyihui.data.pojo.entity.jx.SatisfactionDoctorReqVo;
import com.ebaiyihui.data.pojo.vo.HospitalConfig;
import com.ebaiyihui.data.pojo.vo.jx.FilterDoctorVo;
import com.ebaiyihui.data.service.impl.jx.IBaseService;
import com.ebaiyihui.data.service.jx.JiangXiService;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.HttpKit;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JiangXiServiceImpl
implements JiangXiService {
    private static final Logger log = LoggerFactory.getLogger(JiangXiServiceImpl.class);
    @Autowired
    IBaseService iBaseService;

    public BaseResponse<String> uploadSatisfactionDoctor(SatisfactionDoctorReqVo satisfactionDoctorReqVo) {
        JxHospitalInfo jxHospitalInfo = this.getJxHospitalInfoByHosId(satisfactionDoctorReqVo.getHosId());
        if (Objects.isNull(jxHospitalInfo)) {
            return BaseResponse.error((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\u540e\u53f0\u914d\u7f6e");
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("orgCode", (Object)jxHospitalInfo.getAppCode());
        jsonObject.put("doctorCode", (Object)satisfactionDoctorReqVo.getDoctorCode());
        jsonObject.put("cardType", (Object)satisfactionDoctorReqVo.getCardType());
        jsonObject.put("cardNumber", (Object)satisfactionDoctorReqVo.getCardNumber());
        jsonObject.put("appCode", (Object)jxHospitalInfo.getAppKey());
        jsonObject.put("appSecret", (Object)jxHospitalInfo.getAppSecret());
        jsonObject.put("hostName", (Object)jxHospitalInfo.getHospitalHost());
        try {
            String body = HttpKit.jsonPost((String)(jxHospitalInfo.getFrontHost() + "/satisfaction/doctor"), (String)jsonObject.toJSONString());
            return (BaseResponse)JSON.parseObject((String)body, BaseResponse.class);
        }
        catch (Exception e) {
            log.info("uploadSatisfactionDoctor\u8bf7\u6c42\u5931\u8d25->{}", (Throwable)e);
            return BaseResponse.error((String)"\u7f51\u7edc\u8d85\u65f6\uff0c\u8bf7\u91cd\u8bd5");
        }
    }

    public BaseResponse<String> uploadComplaintDoctor(ComplaintDoctorReqVo complaintDoctorReqVo) {
        JxHospitalInfo jxHospitalInfo = this.getJxHospitalInfoByHosId(complaintDoctorReqVo.getHosId());
        if (Objects.isNull(jxHospitalInfo)) {
            return BaseResponse.error((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\u540e\u53f0\u914d\u7f6e");
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("orgCode", (Object)jxHospitalInfo.getAppCode());
        jsonObject.put("doctorCode", (Object)complaintDoctorReqVo.getDoctorCode());
        jsonObject.put("cardType", (Object)complaintDoctorReqVo.getCardType());
        jsonObject.put("cardNumber", (Object)complaintDoctorReqVo.getCardNumber());
        jsonObject.put("appCode", (Object)jxHospitalInfo.getAppKey());
        jsonObject.put("appSecret", (Object)jxHospitalInfo.getAppSecret());
        jsonObject.put("hostName", (Object)jxHospitalInfo.getHospitalHost());
        try {
            String body = HttpKit.jsonPost((String)(jxHospitalInfo.getFrontHost() + "/complaint/doctor"), (String)jsonObject.toJSONString());
            return (BaseResponse)JSON.parseObject((String)body, BaseResponse.class);
        }
        catch (Exception e) {
            log.info("uploadComplaintDoctor\u8bf7\u6c42\u5931\u8d25->{}", (Throwable)e);
            return BaseResponse.error((String)"\u7f51\u7edc\u8d85\u65f6\uff0c\u8bf7\u91cd\u8bd5");
        }
    }

    public BaseResponse<String> consultQuery(ConsultQueryReqVo complaintDoctorReqVo) {
        JxHospitalInfo jxHospitalInfo = this.getJxHospitalInfoByHosId(complaintDoctorReqVo.getHosId());
        if (Objects.isNull(jxHospitalInfo)) {
            return BaseResponse.error((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\u540e\u53f0\u914d\u7f6e");
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("treId", (Object)complaintDoctorReqVo.getTreId());
        jsonObject.put("orgCode", (Object)jxHospitalInfo.getAppCode());
        jsonObject.put("appKey", (Object)jxHospitalInfo.getAppKey());
        jsonObject.put("appSecret", (Object)jxHospitalInfo.getAppSecret());
        jsonObject.put("hostName", (Object)jxHospitalInfo.getHospitalHost());
        try {
            String body = HttpKit.jsonPost((String)(jxHospitalInfo.getFrontHost() + "/consult/query"), (String)jsonObject.toJSONString());
            return (BaseResponse)JSON.parseObject((String)body, BaseResponse.class);
        }
        catch (Exception e) {
            log.info("consultQuery\u8bf7\u6c42\u5931\u8d25->{}", (Throwable)e);
            return BaseResponse.error((String)"\u7f51\u7edc\u8d85\u65f6\uff0c\u8bf7\u91cd\u8bd5");
        }
    }

    public BaseResponse insertHospitalConfig(HospitalConfig hospitalConfig) {
        try {
            MongoDBFactory mongoDBFactory = new MongoDBFactory("hos_info_config");
            mongoDBFactory.insert("config", JSON.toJSONString((Object)hospitalConfig));
        }
        catch (Exception e) {
            log.error("\u65b0\u589e\u533b\u9662\u914d\u7f6e\u53c2\u6570\u5931\u8d25{}", (Throwable)e);
            return BaseResponse.error((String)"\u65b0\u589e\u533b\u9662\u914d\u7f6e\u53c2\u6570\u5931\u8d25");
        }
        return BaseResponse.success();
    }

    public BaseResponse updateHospitalConfig(HospitalConfig hospitalConfig) {
        try {
            MongoDBFactory mongoDBFactory = new MongoDBFactory("hos_info_config");
            HospitalConfig key = new HospitalConfig();
            key.setHospitalId(hospitalConfig.getHospitalId());
            mongoDBFactory.update("config", JSON.toJSONString((Object)key), JSON.toJSONString((Object)hospitalConfig));
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u533b\u9662\u914d\u7f6e\u53c2\u6570\u5931\u8d25{}", (Throwable)e);
            return BaseResponse.error((String)"\u4fee\u6539\u533b\u9662\u914d\u7f6e\u53c2\u6570\u5931\u8d25");
        }
        return BaseResponse.success();
    }

    public BaseResponse findHospitalConfig(String hospitalId) {
        HospitalConfig hos;
        try {
            MongoDBFactory mongoDBFactory = new MongoDBFactory("hos_info_config");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("hospitalId", hospitalId);
            String result = mongoDBFactory.findOne("config", map);
            hos = (HospitalConfig)JSON.parseObject((String)result, HospitalConfig.class);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u533b\u9662\u914d\u7f6e\u53c2\u6570\u5931\u8d25{}", (Throwable)e);
            return BaseResponse.error((String)"\u67e5\u8be2\u533b\u9662\u914d\u7f6e\u53c2\u6570\u5931\u8d25");
        }
        return BaseResponse.success((Object)hos);
    }

    public BaseResponse insertFilterDoctor(List<FilterDoctorVo> filterDoctorVos) {
        Boolean flag;
        try {
            flag = this.iBaseService.saveBatch(filterDoctorVos);
        }
        catch (Exception e) {
            log.error("\u65b0\u589e\u8fc7\u6ee4\u533b\u751f\u4fe1\u606f\u5931\u8d25{}", (Throwable)e);
            return BaseResponse.error((String)"\u65b0\u589e\u8fc7\u6ee4\u533b\u751f\u4fe1\u606f\u5931\u8d25");
        }
        if (!flag.booleanValue()) {
            return BaseResponse.error((String)"\u65b0\u589e\u8fc7\u6ee4\u533b\u751f\u4fe1\u606f\u5931\u8d25");
        }
        return BaseResponse.success();
    }

    public BaseResponse deleteFilterDoctor(String doctorId) {
        try {
            QueryWrapper queryWrapper = new QueryWrapper();
            FilterDoctorVo filterDoctorVo = new FilterDoctorVo();
            filterDoctorVo.setDoctorId(doctorId);
            queryWrapper.setEntity((Object)filterDoctorVo);
            this.iBaseService.remove((Wrapper)queryWrapper);
        }
        catch (Exception e) {
            log.error("\u8fc7\u6ee4\u533b\u751f\u4fe1\u606f\u5220\u9664\u5931\u8d25{}", (Throwable)e);
            return BaseResponse.error((String)"\u8fc7\u6ee4\u533b\u751f\u4fe1\u606f\u5220\u9664\u5931\u8d25");
        }
        return BaseResponse.success();
    }

    public BaseResponse findByHospitalId(String hospitaIdl) {
        List filterDoctorVoList;
        try {
            QueryWrapper queryWrapper = new QueryWrapper();
            FilterDoctorVo filterDoctorVo = new FilterDoctorVo();
            filterDoctorVo.setHospitalId(hospitaIdl);
            queryWrapper.setEntity((Object)filterDoctorVo);
            filterDoctorVoList = this.iBaseService.list((Wrapper)queryWrapper);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u8fc7\u6ee4\u533b\u751f\u4fe1\u606f\u5931\u8d25{}", (Throwable)e);
            return BaseResponse.error((String)"\u67e5\u8be2\u8fc7\u6ee4\u533b\u751f\u4fe1\u606f\u5931\u8d25");
        }
        return BaseResponse.success((Object)filterDoctorVoList);
    }

    private JxHospitalInfo getJxHospitalInfoByHosId(String hosId) {
        JxHospitalInfo jxHospitalInfo = new JxHospitalInfo(hosId);
        return jxHospitalInfo;
    }
}

