/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.data.service.impl.sichuan;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ebaiyihui.data.business.upload.reservation.IUpload;
import com.ebaiyihui.data.business.upload.reservation.ScUpload;
import com.ebaiyihui.data.business.upload.reservation.SiChuanIInit;
import com.ebaiyihui.data.config.NodeConfig;
import com.ebaiyihui.data.dao.AdmissionSCMapper;
import com.ebaiyihui.data.pojo.vo.sc.UploadConsultReq;
import com.ebaiyihui.data.utils.HttpsApiUtil;
import com.ebaiyihui.data.utils.RedisUtil;
import com.ebaiyihui.data.utils.SnowflakeIdWorker;
import com.ebaiyihui.framework.utils.IdCardUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@Order(value=1)
public class UploadConsultServiceImpl
implements SiChuanIInit {
    private static final Logger log = LoggerFactory.getLogger(UploadConsultServiceImpl.class);
    @Autowired
    private NodeConfig nodeConfig;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    @Autowired
    private AdmissionSCMapper admissionSCMapper;

    public IUpload scDataInit(String hospitalId) {
        List listConsultInfoSC = this.admissionSCMapper.getListConsultInfoSC(hospitalId);
        ScUpload scUpload = this.convertConsultInfoInfo(listConsultInfoSC, hospitalId);
        scUpload.setHospitalId(hospitalId);
        return scUpload;
    }

    private ScUpload convertConsultInfoInfo(List<UploadConsultReq> listConsultInfoSC, String hospitalId) {
        log.info("\u6784\u5efa\u5c31\u8bca\u4fe1\u606f  AdmInfoServiceImpl");
        ScUpload scUpload = new ScUpload();
        if (CollectionUtils.isEmpty(listConsultInfoSC)) {
            scUpload.setData("");
        } else {
            listConsultInfoSC.stream().forEach(resList -> {
                resList.setThirdUniqueid(String.valueOf(this.snowflakeIdWorker.nextId()));
                Object obj = this.redisUtil.get("scAccessToken");
                String acccessToken = "";
                acccessToken = Objects.isNull(obj) ? this.getAccessToken() : obj.toString();
                resList.setAccessToken(acccessToken);
                resList.setClientId(this.nodeConfig.getClientId());
                resList.setPatientAge(Integer.valueOf(IdCardUtil.getAgeByIdCard((String)resList.getPatientIdcardNum())));
            });
        }
        scUpload.setData(JSON.toJSONStringWithDateFormat(listConsultInfoSC, (String)"yyyy-MM-dd HH:mm:ss", (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat}));
        scUpload.setSuffix("/wjw/upload/uploadConsult");
        return scUpload;
    }

    private String getAccessToken() {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("clientId", this.nodeConfig.getClientId());
        m.put("appSecret", this.nodeConfig.getAppSecret());
        byte[] bytes = new byte[]{};
        try {
            bytes = HttpsApiUtil.sendJsonToHttpsPost((String)"https://202.61.88.184:19200/wjw/third/oauth/getAccessToken", (String)JSONObject.toJSONString(m), (String)"UTF-8");
        }
        catch (Exception e) {
            log.info("\u8bf7\u6c42\u83b7\u53d6accessToken\u5f02\u5e38");
            return "";
        }
        String s1 = new String(bytes);
        log.info("\u8bf7\u6c42\u83b7\u53d6accessToken\u8fd4\u56de" + s1);
        if (Objects.isNull(s1) || "".equals(s1)) {
            return "";
        }
        JSONObject jSONObject = JSONObject.parseObject((String)s1);
        String data = jSONObject.getString("data");
        JSONObject dataStrObj = JSONObject.parseObject((String)data);
        String accessToken = dataStrObj.getString("accessToken");
        this.redisUtil.set("scAccessToken", (Object)accessToken, 86400L);
        return accessToken;
    }
}

