/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.data.utils;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

/*
 * Exception performing whole class analysis ignored.
 */
public final class DateUtils {
    public static final String FULL_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String SIMPLE_FORMAT = "yyyy-MM-dd";
    private static final String FORMAT = "yyyyMMddHHmmss";
    private static final String SIMPLE_NOSPE_FORMAT = "yyyyMMdd";
    private static final String SIMPLE_TIME_FORMAT = "HH:mm:ss";

    public static String getCurrentTime() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss");
        return df.format(calendar.getTime());
    }

    public static Date getDateBefore(Date d, int day) {
        Calendar now = Calendar.getInstance();
        now.setTime(d);
        now.set(5, now.get(5) - day);
        return now.getTime();
    }

    public static Date getDateAfter(Date d, int day) {
        Calendar now = Calendar.getInstance();
        now.setTime(d);
        now.set(5, now.get(5) + day);
        return now.getTime();
    }

    public static Date getAddMonth(Date date, int month) {
        Calendar now = Calendar.getInstance();
        now.setTime(date);
        now.add(2, month);
        return now.getTime();
    }

    public static Date getSubtractMonth(Date date, int month) {
        Calendar now = Calendar.getInstance();
        now.setTime(date);
        now.add(2, -month);
        return now.getTime();
    }

    public static Date getAddYear(Date date, int year) {
        Calendar now = Calendar.getInstance();
        now.setTime(date);
        now.add(1, year);
        return now.getTime();
    }

    public static Date getSubtractYear(Date date, int year) {
        Calendar now = Calendar.getInstance();
        now.setTime(date);
        now.add(1, -year);
        return now.getTime();
    }

    private static Calendar initCurrentDate() {
        Date date = new Date(System.currentTimeMillis());
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c;
    }

    public static int getCurrentYear() {
        Calendar c = DateUtils.initCurrentDate();
        return c.get(1);
    }

    public static int getCurrentMonth() {
        return DateUtils.initCurrentDate().get(2) + 1;
    }

    public static int getCurrentDay() {
        return DateUtils.initCurrentDate().get(5);
    }

    public static int getCurrentHour() {
        return DateUtils.initCurrentDate().get(11);
    }

    public static int getCurrentMinute() {
        return DateUtils.initCurrentDate().get(12);
    }

    public static int getCurrentSecond() {
        return DateUtils.initCurrentDate().get(13);
    }

    public static String getCurrentDate(String format) {
        SimpleDateFormat parse = new SimpleDateFormat(format);
        return parse.format(new Date());
    }

    public static Date parseDate(String str, String parsePatterns) throws ParseException {
        if (str == null || parsePatterns == null) {
            throw new IllegalArgumentException("Date and Patterns must not be null");
        }
        SimpleDateFormat parser = null;
        ParsePosition pos = new ParsePosition(0);
        parser = new SimpleDateFormat(parsePatterns);
        pos.setIndex(0);
        Date date = parser.parse(str, pos);
        if (date != null && pos.getIndex() == str.length()) {
            return date;
        }
        throw new ParseException("Unable to parse the date: " + str, -1);
    }

    public static String dateToString(Date date, String par) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(par);
        return sdf.format(date);
    }

    public static long strToDateLong(String date) {
        long l = 0L;
        try {
            Calendar ca = Calendar.getInstance();
            ca.setTime(java.sql.Date.valueOf(date));
            l = ca.getTimeInMillis();
        }
        catch (Exception e) {
            new Exception("\u65e5\u671f\u5b57\u7b26\u4e32\u8f6c\u957f\u6574\u5f62\u9519\u8bef", e);
        }
        return l;
    }

    public static String longToStrDate(String format, long time) {
        SimpleDateFormat df = new SimpleDateFormat(format);
        return df.format(new Date(time));
    }

    public static Date strToDate(String str, String parsePatterns) throws ParseException {
        return DateUtils.parseDate((String)str, (String)parsePatterns);
    }

    public static Date getAfterCurrentDay(int days) {
        Date result = null;
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.add(7, days);
            result = calendar.getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String getCurrentDateTimeString() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        return df.format(calendar.getTime());
    }

    public static String getCurrentDateToString() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return df.format(calendar.getTime());
    }

    public static String getCurrentDateSimpleToString() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        return df.format(calendar.getTime());
    }

    public static String getCurrentDateSimpleNoSpeToString() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        return df.format(calendar.getTime());
    }

    public static Date getCurrentDate() {
        Calendar calendar = Calendar.getInstance();
        return calendar.getTime();
    }

    public static Timestamp getCurrentDateTimestamp() {
        Calendar calendar = Calendar.getInstance();
        return new Timestamp(calendar.getTime().getTime());
    }

    public static String getNextWeekToString() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(7, 6);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        return df.format(calendar.getTime());
    }

    public static String getNextDayToString(String day) {
        String result = "";
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        try {
            calendar.setTime(df.parse(day));
            calendar.add(7, 1);
            result = df.format(calendar.getTime());
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String getLastWeekToString() {
        String result = "";
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        try {
            calendar.add(4, -1);
            result = df.format(calendar.getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String getYestarDayToString(String day) {
        String result = "";
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        try {
            calendar.setTime(df.parse(day));
            calendar.add(7, -1);
            result = df.format(calendar.getTime());
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static Date stringToSimpleDate(String str) {
        if (str == null || "".equals(str)) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        try {
            return df.parse(str);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date stringToFullDate(String str) {
        if (str == null || "".equals(str)) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            return df.parse(str);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String dateToSimpleString(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        return df.format(date);
    }

    public static String dateToFullString(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return df.format(date);
    }

    public static String getWeekChinese(String date) {
        String[] weekDays = new String[]{"\u661f\u671f\u65e5", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d"};
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        try {
            cal.setTime(df.parse(date));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        int w = cal.get(7) - 1;
        if (w < 0) {
            w = 0;
        }
        return weekDays[w];
    }

    public static boolean judgeDate(String startStr, String endStr) {
        Date endDate;
        Date startDate = DateUtils.stringToSimpleDate((String)startStr);
        return startDate.before(endDate = DateUtils.stringToSimpleDate((String)endStr));
    }

    public static boolean judgeDateEqual(String startStr, String endStr) {
        Date endDate;
        Date startDate = DateUtils.stringToSimpleDate((String)startStr);
        return startDate.before(endDate = DateUtils.stringToSimpleDate((String)endStr)) || startDate.compareTo(endDate) == 0;
    }

    public static String getNumAfterDate(String str, int day) {
        Date startDate = DateUtils.stringToSimpleDate((String)str);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startDate);
        calendar.add(7, day);
        return DateUtils.dateToSimpleString((Date)calendar.getTime());
    }

    public static String unixTimeToString(String unixTime) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(Long.parseLong(unixTime));
        return DateUtils.dateToSimpleString((Date)c.getTime());
    }

    public static String stringToUnixTime(String date) {
        Calendar c = Calendar.getInstance();
        Date date2 = DateUtils.stringToSimpleDate((String)date);
        c.setTime(date2);
        return c.getTimeInMillis() + "";
    }

    public static Timestamp stringToTimestamp(String tsStr) {
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        try {
            ts = Timestamp.valueOf(tsStr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ts;
    }

    public static String getStrByTimestamp(Timestamp ccTime) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(ccTime);
    }

    public static Time strToTime(String strDate) {
        if ("".equals(strDate) || strDate == null) {
            return null;
        }
        String str = strDate;
        SimpleDateFormat format = new SimpleDateFormat("hh:mm:ss");
        Date d = null;
        try {
            d = format.parse(str);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Time.valueOf(str);
    }

    public static Time getTime() {
        Date d = new Date();
        Time time = new Time(d.getTime());
        return time;
    }

    public static int getBetweenDayNumber(Date dateA, Date dateB) {
        long dayNumber = 0L;
        long day = 86400000L;
        try {
            dayNumber = (dateB.getTime() - dateA.getTime()) / day;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (int)dayNumber;
    }

    public static int daysBetween(Date date1, Date date2) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date1);
        long time1 = cal.getTimeInMillis();
        cal.setTime(date2);
        long time2 = cal.getTimeInMillis();
        long betweenDays = (time2 - time1) / 86400000L;
        return Integer.parseInt(String.valueOf(betweenDays));
    }

    public static int secondsBetween(Date date1, Date date2) {
        if (date1.after(date2)) {
            return 0;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date1);
        long time1 = cal.getTimeInMillis();
        cal.setTime(date2);
        long time2 = cal.getTimeInMillis();
        long betweenDays = (time2 - time1) / 60000L;
        return Integer.parseInt(String.valueOf(betweenDays));
    }

    public static int hoursBetween(Date date1, Date date2) {
        if (date1.after(date2)) {
            return 0;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date1);
        long time1 = cal.getTimeInMillis();
        cal.setTime(date2);
        long time2 = cal.getTimeInMillis();
        long betweenDays = (time2 - time1) / 1000L / 3600L;
        return Integer.parseInt(String.valueOf(betweenDays));
    }

    public static Date dateAddDays(Date date, int addDays) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, addDays);
        return calendar.getTime();
    }

    public static Date dateAddHours(Date date, int addHours) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(11, addHours);
        return calendar.getTime();
    }

    public static Date addDateMinut(Date day, int hour) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(day);
        cal.add(10, hour);
        Date time = cal.getTime();
        return time;
    }

    public static Date dateAddMinutes(Date date, int addMinutes) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(12, addMinutes);
        return calendar.getTime();
    }

    public static String longToString(long currentTime, String formatType) throws ParseException {
        Date date = DateUtils.longToDate((long)currentTime, (String)formatType);
        String strTime = DateUtils.dateToString((Date)date, (String)formatType);
        return strTime;
    }

    public static long StringTolong(String strDateTime) {
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        long timeStamp = 0L;
        try {
            LocalDateTime localDateTime = LocalDateTime.parse(strDateTime, dtf);
            timeStamp = localDateTime.toInstant(ZoneOffset.of("+8")).toEpochMilli();
        }
        catch (Exception e) {
            return timeStamp;
        }
        return timeStamp;
    }

    public static Date stringToDate(String strTime, String formatType) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat(formatType);
        Date date = null;
        date = formatter.parse(strTime);
        return date;
    }

    public static Date longToDate(long currentTime, String formatType) throws ParseException {
        Date dateOld = new Date(currentTime);
        String sDateTime = DateUtils.dateToString((Date)dateOld, (String)formatType);
        Date date = DateUtils.stringToDate((String)sDateTime, (String)formatType);
        return date;
    }

    public static long dateToLong(Date date) {
        return date.getTime();
    }

    public static Date setPrecise(Date d, int hour, int min, int second) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(d);
        calendar.set(11, hour);
        calendar.set(12, min);
        calendar.set(13, second);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getNextDayStartTime() {
        Date date = new Date();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).add(6, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getBeginDayOfWeek() {
        Date date = new Date();
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int dayofweek = cal.get(7);
        if (dayofweek == 1) {
            dayofweek += 7;
        }
        cal.add(5, 2 - dayofweek);
        return DateUtils.getDayStartTime((Date)cal.getTime());
    }

    public static Date getEndDayOfWeek() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtils.getBeginDayOfWeek());
        cal.add(7, 6);
        Date weekEndSta = cal.getTime();
        return DateUtils.getDayEndTime((Date)weekEndSta);
    }

    public static Date getBeginDayOfLastWeek(Integer min) {
        Date date = new Date();
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int dayofweek = cal.get(7);
        if (dayofweek == 1) {
            dayofweek += 7;
        }
        cal.add(5, 2 - dayofweek - min * 7);
        return DateUtils.getDayStartTime((Date)cal.getTime());
    }

    public static Date getEndDayOfLastWeek(Integer min) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtils.getBeginDayOfLastWeek((Integer)min));
        cal.add(7, 6);
        Date weekEndSta = cal.getTime();
        return DateUtils.getDayEndTime((Date)weekEndSta);
    }

    public static Date getBeginDayLastWeek() {
        Date date = new Date();
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int dayofweek = cal.get(7);
        if (dayofweek == 1) {
            dayofweek += 7;
        }
        cal.add(5, 2 - dayofweek - 28);
        return DateUtils.getDayStartTime((Date)cal.getTime());
    }

    public static Date getEndDayLastWeek() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtils.getBeginDayLastWeek());
        cal.add(7, 6);
        Date weekEndSta = cal.getTime();
        return DateUtils.getDayEndTime((Date)weekEndSta);
    }

    public static Date getBeginDayOfNextWeek() {
        Date date = new Date();
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int dayofweek = cal.get(7);
        if (dayofweek == 1) {
            dayofweek += 7;
        }
        cal.add(5, 2 - dayofweek + 7);
        return DateUtils.getDayStartTime((Date)cal.getTime());
    }

    public static Date getEndDayOfNextWeek() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtils.getBeginDayOfNextWeek());
        cal.add(7, 6);
        Date weekEndSta = cal.getTime();
        return DateUtils.getDayEndTime((Date)weekEndSta);
    }

    public static Timestamp getDayStartTime(Date d) {
        Calendar calendar = Calendar.getInstance();
        if (null != d) {
            calendar.setTime(d);
        }
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.set(14, 0);
        return new Timestamp(calendar.getTimeInMillis());
    }

    public static Timestamp getDayEndTime(Date d) {
        Calendar calendar = Calendar.getInstance();
        if (null != d) {
            calendar.setTime(d);
        }
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
        calendar.set(14, 999);
        return new Timestamp(calendar.getTimeInMillis());
    }

    public static Date getWeek() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtils.date());
        cal.add(7, 6);
        Date weekEndSta = cal.getTime();
        return DateUtils.getDayEndTime((Date)weekEndSta);
    }

    public static Date date() {
        SimpleDateFormat deTime = new SimpleDateFormat("yyyy-MM-dd");
        Date date = new Date();
        String format = deTime.format(date);
        Date parse = null;
        try {
            parse = deTime.parse(format);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return parse;
    }

    public static Date getBegNextWeek(Integer min) {
        Date date = new Date();
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int dayofweek = cal.get(7);
        if (dayofweek == 1) {
            dayofweek += 7;
        }
        cal.add(5, 2 - dayofweek + min * 7);
        return DateUtils.getDayStartTime((Date)cal.getTime());
    }

    public static Date getEndNextWeek(Integer min) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtils.getBegNextWeek((Integer)min));
        cal.add(7, 6);
        Date weekEndSta = cal.getTime();
        return DateUtils.getDayEndTime((Date)weekEndSta);
    }

    public static long getTime(int hour, int minute, int second) {
        LocalTime localTime = LocalTime.of(hour, minute, second);
        return LocalDateTime.of(LocalDate.now(), localTime).toInstant(ZoneOffset.ofHours(8)).toEpochMilli();
    }

    public static Integer getAge(String idcard) throws ParseException {
        if (idcard == null) {
            return null;
        }
        if (idcard.length() != 18) {
            return null;
        }
        return DateUtils.getAgeByBirthDates((String)idcard.substring(6, 14), (String)"yyyyMMdd");
    }

    public static Integer getAgeByBirthDates(String birthDateStr, String format) {
        Date birthDate;
        if (birthDateStr == null || format == null) {
            return 0;
        }
        try {
            birthDate = new SimpleDateFormat(format).parse(birthDateStr);
        }
        catch (ParseException e) {
            return 0;
        }
        Calendar calendar = Calendar.getInstance();
        if (calendar.before(birthDate)) {
            return 0;
        }
        int yearNow = calendar.get(1);
        int monthNow = calendar.get(2);
        int dayOfMonthNow = calendar.get(5);
        calendar.setTime(birthDate);
        int yearBirth = calendar.get(1);
        int monthBirth = calendar.get(2);
        int dayOfMonthBirth = calendar.get(5);
        int age = yearNow - yearBirth;
        if (monthNow <= monthBirth) {
            if (monthNow == monthBirth) {
                if (dayOfMonthNow < dayOfMonthBirth) {
                    --age;
                }
            } else {
                --age;
            }
        }
        return age;
    }

    public static String strToStr(String dateStr, String oldFormart, String newFormart) {
        try {
            Date date = new SimpleDateFormat(oldFormart).parse(dateStr);
            SimpleDateFormat df = new SimpleDateFormat(newFormart);
            return df.format(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return dateStr;
        }
    }
}

