/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.data.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.data.common.constants.HisConstants;
import com.ebaiyihui.data.pojo.vo.bj.AccessTokenBJZRVo;
import com.ebaiyihui.framework.response.BaseResponse;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class HisTemplateBJZRUtils {
    private static final Logger log = LoggerFactory.getLogger(HisTemplateBJZRUtils.class);
    @Autowired
    private RedisTemplate<String, String> strRedisTemplate;
    private static HisTemplateBJZRUtils hisTemplateUtils;

    @PostConstruct
    public void init() {
        hisTemplateUtils = this;
        HisTemplateBJZRUtils.hisTemplateUtils.strRedisTemplate = this.strRedisTemplate;
    }

    public static BaseResponse<String> getAccessToken() {
        String accessToken = (String)HisTemplateBJZRUtils.hisTemplateUtils.strRedisTemplate.opsForValue().get((Object)"data_platfrom_access_token");
        if (null == accessToken) {
            RestTemplate restTemplate = new RestTemplate();
            String accessTokenUrl = MessageFormat.format("https://wstj.phic.org.cn/hlwyy/auth/token?appid={0}&secret={1}", "01594647-2b7c-4a68-a160-ed73d3ef9d76", "cd80906d11fc4a2988963ac5f3f89859");
            log.info("\u6570\u636e\u4e0a\u62a5\u83b7\u53d6access_token url==>{}", (Object)JSON.toJSONString((Object)accessTokenUrl));
            Object forObject = restTemplate.getForObject(accessTokenUrl, Object.class, new Object[0]);
            log.info("\u6570\u636e\u4e0a\u62a5\u83b7\u53d6access_token response==>{}", (Object)JSON.toJSONString((Object)forObject));
            AccessTokenBJZRVo accessTokenZRVo = (AccessTokenBJZRVo)JSONObject.parseObject((String)JSONObject.toJSONString((Object)forObject), AccessTokenBJZRVo.class);
            if (null != accessTokenZRVo.getErrcode() && HisConstants.HIS_ERRCODE.equals(accessTokenZRVo.getErrcode())) {
                log.info("\u6570\u636e\u4e0a\u62a5\u83b7\u53d6access_token \u5931\u8d25==>{}", (Object)JSON.toJSONString((Object)accessTokenZRVo));
                return BaseResponse.error((String)accessTokenZRVo.getErrmsg());
            }
            accessToken = accessTokenZRVo.getAccess_token();
            HisTemplateBJZRUtils.hisTemplateUtils.strRedisTemplate.opsForValue().set((Object)"data_platfrom_access_token", (Object)accessTokenZRVo.getAccess_token(), 86400L, TimeUnit.SECONDS);
        }
        log.info("\u6570\u636e\u4e0a\u62a5\u83b7\u53d6access_token \u6570\u636e\u5904\u7406==>{}", (Object)JSON.toJSONString((Object)accessToken));
        return BaseResponse.success((Object)accessToken);
    }

    public static BaseResponse restTemplate(String asXML, String accessToken) {
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        restTemplate.getMessageConverters().set(1, new StringHttpMessageConverter(StandardCharsets.UTF_8));
        MediaType type = MediaType.parseMediaType((String)"text/xml;charset=UTF-8");
        headers.setContentType(type);
        HttpEntity request = new HttpEntity((Object)asXML, (MultiValueMap)headers);
        String url = "https://wstj.phic.org.cn/hlwyy/ihosp/clinic?access_token=" + accessToken;
        log.info("url===>{}", (Object)JSON.toJSONString((Object)url));
        log.info("request==>{}", (Object)JSON.toJSONString((Object)request));
        Object forObject = restTemplate.postForObject(url, (Object)request, Object.class, new Object[0]);
        log.info("response===>{}", (Object)JSON.toJSONString((Object)forObject));
        AccessTokenBJZRVo accessTokenZRVo = (AccessTokenBJZRVo)JSONObject.parseObject((String)JSONObject.toJSONString((Object)forObject), AccessTokenBJZRVo.class);
        if (HisConstants.HIS_CODE.equals(Integer.valueOf(accessTokenZRVo.getErrcode())) || HisConstants.HIS_ERRCODES.equals(Integer.valueOf(accessTokenZRVo.getErrcode())) || HisConstants.HIS_ERRCODEN.equals(Integer.valueOf(accessTokenZRVo.getErrcode()))) {
            log.info("\u6570\u636e\u4e0a\u62a5\u5931\u8d25==>{}", (Object)JSON.toJSONString((Object)accessTokenZRVo));
            return BaseResponse.error((String)accessTokenZRVo.getErrmsg());
        }
        log.info("\u6570\u636e\u4e0a\u62a5\u6570\u636e\u5904\u7406==>{}", (Object)JSON.toJSONString((Object)accessTokenZRVo));
        return BaseResponse.success();
    }
}

