/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.invoice.utils.price;

import com.ebaiyihui.invoice.aop.execption.BusinessException;
import com.ebaiyihui.invoice.utils.array.ArrayUtil;
import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;

public class PriceUtil {
    private static final BigDecimal ZERO = new BigDecimal("0");

    public static BigDecimal add(Number ... numbers) {
        if (ArrayUtil.isNull(numbers)) {
            return ZERO;
        }
        BigDecimal sumNum = new BigDecimal("0");
        for (Number number : numbers) {
            BigDecimal num = new BigDecimal(String.valueOf(number.doubleValue()));
            sumNum = sumNum.add(num);
        }
        return sumNum;
    }

    public static BigDecimal sub(Number ... numbers) {
        if (ArrayUtil.isNull(numbers)) {
            return ZERO;
        }
        BigDecimal sumNum = BigDecimal.valueOf(numbers[0].doubleValue());
        for (int i = 1; i < numbers.length; ++i) {
            BigDecimal num = new BigDecimal(String.valueOf(numbers[i].doubleValue()));
            sumNum = sumNum.subtract(num);
        }
        return sumNum;
    }

    public static BigDecimal mul(Number ... numbers) {
        if (ArrayUtil.isNull(numbers)) {
            return ZERO;
        }
        BigDecimal sumNum = BigDecimal.valueOf(numbers[0].doubleValue());
        for (int i = 1; i < numbers.length; ++i) {
            BigDecimal num = new BigDecimal(String.valueOf(numbers[i].doubleValue()));
            sumNum = sumNum.multiply(num);
        }
        return sumNum;
    }

    public static BigDecimal div(Number ... numbers) {
        if (ArrayUtil.isNull(numbers)) {
            throw new BusinessException("400", "\u8fdb\u884c\u9664\u6cd5\u7684\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BigDecimal sumNum = BigDecimal.valueOf(numbers[0].doubleValue());
        for (int i = 1; i < numbers.length; ++i) {
            if (Double.valueOf(0.0).equals(numbers[i].doubleValue())) {
                throw new BusinessException("400", "\u9664\u6570\u4e0d\u80fd\u4e3a 0");
            }
            BigDecimal num = new BigDecimal(String.valueOf(numbers[i].doubleValue()));
            sumNum = sumNum.divide(num, 2, 4);
        }
        return sumNum;
    }

    public static String getPriceStringValue(Number price) {
        if (price == null) {
            price = 0;
        }
        return price.toString();
    }

    public static Double getDoubleValueByString(String price) {
        double value = 0.0;
        if (StringUtils.isEmpty((CharSequence)price)) {
            return value;
        }
        try {
            value = Double.parseDouble(price);
        }
        catch (NumberFormatException e) {
            value = 0.0;
        }
        return value;
    }

    public static int getIntegerValue(String price) {
        if (price == null) {
            return 0;
        }
        return Integer.parseInt(price);
    }

    public static int getIntegerValue(Number price) {
        if (price == null) {
            price = 0;
        }
        return price.intValue();
    }

    public static double getDoubleValue(Number price) {
        if (price == null) {
            price = 0.0;
        }
        return price.doubleValue();
    }

    public static long getLongValue(Integer price) {
        if (price == null) {
            price = 0;
        }
        return price.longValue();
    }

    public static long getLongValue(Number price) {
        if (price == null) {
            price = 0;
        }
        return price.longValue();
    }
}

