/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.eureka;

import com.ebaiyihui.eureka.util.MailUtils;
import com.ebaiyihui.eureka.vo.MailVo;
import com.netflix.appinfo.InstanceInfo;
import java.net.InetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.netflix.eureka.server.event.EurekaInstanceCanceledEvent;
import org.springframework.cloud.netflix.eureka.server.event.EurekaInstanceRegisteredEvent;
import org.springframework.cloud.netflix.eureka.server.event.EurekaInstanceRenewedEvent;
import org.springframework.cloud.netflix.eureka.server.event.EurekaRegistryAvailableEvent;
import org.springframework.cloud.netflix.eureka.server.event.EurekaServerStartedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class EurekaStateChangeListener {
    private static final Logger log = LoggerFactory.getLogger(EurekaStateChangeListener.class);
    public static final String PRO_ENV = "pro";
    private Logger logger = LoggerFactory.getLogger(EurekaStateChangeListener.class);
    @Autowired
    private MailUtils mailUtils;
    @Value(value="${spring.profiles.active}")
    private String environment;

    @EventListener
    public void listen(EurekaInstanceCanceledEvent eurekaInstanceCanceledEvent) {
        try {
            InetAddress address = InetAddress.getLocalHost();
            MailVo mailVo = new MailVo();
            String content = MarkerFactory.getMarker((String)"DOWN") + " \u670d\u52a1ID\uff1a" + eurekaInstanceCanceledEvent.getServerId() + "\t\u670d\u52a1\u5b9e\u4f8b\uff1a" + eurekaInstanceCanceledEvent.getAppName() + "\t\u670d\u52a1\u4e0b\u7ebf \neureka\u670d\u52a1\u6240\u5728\u670d\u52a1\u5668IP:\t" + address.getHostAddress();
            mailVo.setContent(content);
            mailVo.setSubject("\u670d\u52a1\u4e0b\u7ebf\u901a\u77e5");
            String[] toAccount = new String[]{"baixy@ebaiyihui.com", "yangming@ebaiyihui.com", "yangyw@ebaiyihui.com", "lifx@ebaiyihui.com", "zhanghj@ebaiyihui.com"};
            mailVo.setToAccount(toAccount);
            this.logger.info("\u670d\u52a1\u4e0b\u7ebf\u901a\u77e5: " + content);
            if (PRO_ENV.equals(this.environment)) {
                this.mailUtils.sendMail(mailVo);
            }
        }
        catch (Exception e) {
            log.error("\u670d\u52a1\u4e0b\u7ebf\u90ae\u4ef6\u53d1\u9001\u51fa\u73b0\u5f02\u5e38\uff1a " + e);
        }
    }

    @EventListener
    public void listen(EurekaInstanceRegisteredEvent event) {
        InstanceInfo instanceInfo = event.getInstanceInfo();
    }

    @EventListener
    public void listen(EurekaInstanceRenewedEvent event) {
        event.getAppName();
        event.getServerId();
    }

    @EventListener
    public void listen(EurekaRegistryAvailableEvent event) {
    }

    @EventListener
    public void listen(EurekaServerStartedEvent event) {
    }
}

