/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.excel.listener;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.exception.ExcelAnalysisException;
import com.alibaba.excel.read.metadata.holder.ReadRowHolder;
import com.alibaba.excel.util.StringUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AnalysisClassListener<T>
extends AnalysisEventListener<T> {
    private static final Logger log = LogManager.getLogger(AnalysisClassListener.class);
    private Map<Integer, String> headMap = new HashMap<Integer, String>();
    private List<T> dataList = new ArrayList<T>();
    private Class<T> dtoCla;
    private int headRowNumber;

    public AnalysisClassListener(Class<T> dtoCla) {
        this.dtoCla = dtoCla;
    }

    public AnalysisClassListener(Class<T> dtoCla, int headRowNumber) {
        this.dtoCla = dtoCla;
        this.headRowNumber = headRowNumber;
    }

    public void invokeHeadMap(Map<Integer, String> headMap, AnalysisContext context) {
        for (Map.Entry<Integer, String> integerStringEntry : headMap.entrySet()) {
            if (StringUtils.isEmpty((Object)integerStringEntry.getValue())) continue;
            this.headMap.put(integerStringEntry.getKey(), integerStringEntry.getValue());
        }
        ReadRowHolder readRowHolder = context.readRowHolder();
        Integer rowIndex = readRowHolder.getRowIndex();
        if (rowIndex + 1 == this.headRowNumber) {
            List<Field> excelFields = this.getExcelFields();
            if (this.headMap.size() != excelFields.size()) {
                throw new ExcelAnalysisException("\u8868\u5934\u68c0\u6d4b\u9519\u8bef\uff1a\u8868\u5934\u5b57\u6bb5\u6570\u76ee\u4e0d\u6b63\u786e");
            }
        }
    }

    public void invoke(T model, AnalysisContext context) {
        this.dataList.add(model);
    }

    public void doAfterAllAnalysed(AnalysisContext context) {
        log.info("\u8bfb\u53d6\u5b8c\u6bd5\uff01");
    }

    private List<Field> getExcelFields() {
        Field[] fields;
        ArrayList<Field> newFields = new ArrayList<Field>();
        for (Field field : fields = this.dtoCla.getDeclaredFields()) {
            if (!field.isAnnotationPresent(ExcelProperty.class)) continue;
            newFields.add(field);
        }
        return newFields;
    }

    public Map<Integer, String> getHeadMap() {
        return this.headMap;
    }

    public List<T> getDataList() {
        return this.dataList;
    }

    public Class<T> getDtoCla() {
        return this.dtoCla;
    }

    public int getHeadRowNumber() {
        return this.headRowNumber;
    }

    public void setHeadMap(Map<Integer, String> headMap) {
        this.headMap = headMap;
    }

    public void setDataList(List<T> dataList) {
        this.dataList = dataList;
    }

    public void setDtoCla(Class<T> dtoCla) {
        this.dtoCla = dtoCla;
    }

    public void setHeadRowNumber(int headRowNumber) {
        this.headRowNumber = headRowNumber;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnalysisClassListener)) {
            return false;
        }
        AnalysisClassListener other = (AnalysisClassListener)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getHeadRowNumber() != other.getHeadRowNumber()) {
            return false;
        }
        Map<Integer, String> this$headMap = this.getHeadMap();
        Map<Integer, String> other$headMap = other.getHeadMap();
        if (this$headMap == null ? other$headMap != null : !((Object)this$headMap).equals(other$headMap)) {
            return false;
        }
        List<T> this$dataList = this.getDataList();
        List<T> other$dataList = other.getDataList();
        if (this$dataList == null ? other$dataList != null : !((Object)this$dataList).equals(other$dataList)) {
            return false;
        }
        Class<T> this$dtoCla = this.getDtoCla();
        Class<T> other$dtoCla = other.getDtoCla();
        return !(this$dtoCla == null ? other$dtoCla != null : !this$dtoCla.equals(other$dtoCla));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AnalysisClassListener;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getHeadRowNumber();
        Map<Integer, String> $headMap = this.getHeadMap();
        result = result * 59 + ($headMap == null ? 43 : ((Object)$headMap).hashCode());
        List<T> $dataList = this.getDataList();
        result = result * 59 + ($dataList == null ? 43 : ((Object)$dataList).hashCode());
        Class<T> $dtoCla = this.getDtoCla();
        result = result * 59 + ($dtoCla == null ? 43 : $dtoCla.hashCode());
        return result;
    }

    public String toString() {
        return "AnalysisClassListener(headMap=" + this.getHeadMap() + ", dataList=" + this.getDataList() + ", dtoCla=" + this.getDtoCla() + ", headRowNumber=" + this.getHeadRowNumber() + ")";
    }

    public AnalysisClassListener() {
    }
}

