/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.excel.strategy;

import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.write.handler.CellWriteHandler;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.holder.WriteTableHolder;
import java.util.Arrays;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;

public class DataCellMergeStrategy
implements CellWriteHandler {
    private int[] mergeColumnIndex;
    private int mergeRowIndex;

    public DataCellMergeStrategy(int mergeRowIndex, int[] mergeColumnIndex) {
        this.mergeRowIndex = mergeRowIndex;
        this.mergeColumnIndex = mergeColumnIndex;
    }

    public void beforeCellCreate(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, Row row, Head head, Integer integer, Integer integer1, Boolean aBoolean) {
    }

    public void afterCellCreate(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, Cell cell, Head head, Integer integer, Boolean aBoolean) {
    }

    public void afterCellDataConverted(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, CellData cellData, Cell cell, Head head, Integer integer, Boolean aBoolean) {
    }

    public void afterCellDispose(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, List<CellData> list, Cell cell, Head head, Integer integer, Boolean aBoolean) {
        int curRowIndex = cell.getRowIndex();
        int curColIndex = cell.getColumnIndex();
        if (curRowIndex > this.mergeRowIndex) {
            for (int i = 0; i < this.mergeColumnIndex.length; ++i) {
                if (curColIndex != this.mergeColumnIndex[i]) continue;
                this.mergeWithPrevRow(writeSheetHolder, cell, curRowIndex, curColIndex);
                break;
            }
        }
    }

    private void mergeWithPrevRow(WriteSheetHolder writeSheetHolder, Cell cell, int curRowIndex, int curColIndex) {
        Object preData;
        Object curData = cell.getCellTypeEnum() == CellType.STRING ? cell.getStringCellValue() : Double.valueOf(cell.getNumericCellValue());
        Cell preCell = cell.getSheet().getRow(curRowIndex - 1).getCell(curColIndex);
        Object object = preData = preCell.getCellTypeEnum() == CellType.STRING ? preCell.getStringCellValue() : Double.valueOf(preCell.getNumericCellValue());
        if (curData.equals(preData)) {
            Sheet sheet = writeSheetHolder.getSheet();
            List mergeRegions = sheet.getMergedRegions();
            boolean isMerged = false;
            for (int i = 0; i < mergeRegions.size() && !isMerged; ++i) {
                CellRangeAddress cellRangeAddr = (CellRangeAddress)mergeRegions.get(i);
                if (!cellRangeAddr.isInRange(curRowIndex - 1, curColIndex)) continue;
                sheet.removeMergedRegion(i);
                cellRangeAddr.setLastRow(curRowIndex);
                sheet.addMergedRegion(cellRangeAddr);
                isMerged = true;
            }
            if (!isMerged) {
                CellRangeAddress cellRangeAddress = new CellRangeAddress(curRowIndex - 1, curRowIndex, curColIndex, curColIndex);
                sheet.addMergedRegion(cellRangeAddress);
            }
        }
    }

    public int[] getMergeColumnIndex() {
        return this.mergeColumnIndex;
    }

    public int getMergeRowIndex() {
        return this.mergeRowIndex;
    }

    public void setMergeColumnIndex(int[] mergeColumnIndex) {
        this.mergeColumnIndex = mergeColumnIndex;
    }

    public void setMergeRowIndex(int mergeRowIndex) {
        this.mergeRowIndex = mergeRowIndex;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataCellMergeStrategy)) {
            return false;
        }
        DataCellMergeStrategy other = (DataCellMergeStrategy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMergeRowIndex() != other.getMergeRowIndex()) {
            return false;
        }
        return Arrays.equals(this.getMergeColumnIndex(), other.getMergeColumnIndex());
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataCellMergeStrategy;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMergeRowIndex();
        result = result * 59 + Arrays.hashCode(this.getMergeColumnIndex());
        return result;
    }

    public String toString() {
        return "DataCellMergeStrategy(mergeColumnIndex=" + Arrays.toString(this.getMergeColumnIndex()) + ", mergeRowIndex=" + this.getMergeRowIndex() + ")";
    }

    public DataCellMergeStrategy() {
    }
}

