/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.excel.strategy;

import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.write.handler.CellWriteHandler;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.holder.WriteTableHolder;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;

public class RemarkCellMergeStrategy
implements CellWriteHandler {
    private int columnSize;

    public RemarkCellMergeStrategy(int columnSize) {
        this.columnSize = columnSize;
    }

    public void beforeCellCreate(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, Row row, Head head, Integer integer, Integer integer1, Boolean aBoolean) {
    }

    public void afterCellCreate(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, Cell cell, Head head, Integer integer, Boolean aBoolean) {
    }

    public void afterCellDataConverted(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, CellData cellData, Cell cell, Head head, Integer integer, Boolean aBoolean) {
    }

    public void afterCellDispose(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, List<CellData> list, Cell cell, Head head, Integer integer, Boolean aBoolean) {
        int curRowIndex = cell.getRowIndex();
        int curColIndex = cell.getColumnIndex();
        Sheet sheet = writeSheetHolder.getSheet();
        List mergedRegions = sheet.getMergedRegions();
        boolean isMerged = false;
        for (int i = 0; i < mergedRegions.size() && !isMerged; ++i) {
            CellRangeAddress cellRangeAddr = (CellRangeAddress)mergedRegions.get(i);
            if (!cellRangeAddr.isInRange(curRowIndex, curColIndex - 1)) continue;
            sheet.removeMergedRegion(i);
            cellRangeAddr.setLastRow(curRowIndex);
            sheet.addMergedRegion(cellRangeAddr);
            isMerged = true;
        }
        if (!isMerged) {
            CellRangeAddress cellRangeAddress = new CellRangeAddress(curRowIndex, curRowIndex, curColIndex, this.columnSize - 1);
            sheet.addMergedRegion(cellRangeAddress);
        }
    }

    public int getColumnSize() {
        return this.columnSize;
    }

    public void setColumnSize(int columnSize) {
        this.columnSize = columnSize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemarkCellMergeStrategy)) {
            return false;
        }
        RemarkCellMergeStrategy other = (RemarkCellMergeStrategy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.getColumnSize() == other.getColumnSize();
    }

    protected boolean canEqual(Object other) {
        return other instanceof RemarkCellMergeStrategy;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getColumnSize();
        return result;
    }

    public String toString() {
        return "RemarkCellMergeStrategy(columnSize=" + this.getColumnSize() + ")";
    }

    public RemarkCellMergeStrategy() {
    }
}

